/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.trino.sql.ExpressionFormatter;
import io.trino.sql.RowPatternFormatter;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.AssignmentStatement;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.CallArgument;
import io.trino.sql.tree.CaseStatement;
import io.trino.sql.tree.CaseStatementWhenClause;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.ColumnPosition;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.CommentCharacteristic;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.CompoundStatement;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.Corresponding;
import io.trino.sql.tree.CreateBranch;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateFunction;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.DeterministicCharacteristic;
import io.trino.sql.tree.DropBranch;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropDefaultValue;
import io.trino.sql.tree.DropFunction;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropNotNullConstraint;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.ElseClause;
import io.trino.sql.tree.ElseIfClause;
import io.trino.sql.tree.Except;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.ExecuteImmediate;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.ExplainFormat;
import io.trino.sql.tree.ExplainOption;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.FastForwardBranch;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantObject;
import io.trino.sql.tree.GrantRoles;
import io.trino.sql.tree.GrantorSpecification;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfStatement;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.Isolation;
import io.trino.sql.tree.IterateStatement;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinCriteria;
import io.trino.sql.tree.JoinOn;
import io.trino.sql.tree.JoinUsing;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonTable;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.JsonTableDefaultPlan;
import io.trino.sql.tree.LanguageCharacteristic;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.LeaveStatement;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LoopStatement;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.MergeCase;
import io.trino.sql.tree.MergeDelete;
import io.trino.sql.tree.MergeInsert;
import io.trino.sql.tree.MergeUpdate;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.NestedColumns;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NullInputCharacteristic;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.OrdinalityColumn;
import io.trino.sql.tree.ParameterDeclaration;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.PlanLeaf;
import io.trino.sql.tree.PlanParentChild;
import io.trino.sql.tree.PlanSiblings;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.PropertiesCharacteristic;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryColumn;
import io.trino.sql.tree.QueryPeriod;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.RefreshView;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.RepeatStatement;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.ResetSessionAuthorization;
import io.trino.sql.tree.ReturnStatement;
import io.trino.sql.tree.ReturnsClause;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.RevokeRoles;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.RoutineCharacteristic;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.SecurityCharacteristic;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SessionProperty;
import io.trino.sql.tree.SetAuthorizationStatement;
import io.trino.sql.tree.SetColumnType;
import io.trino.sql.tree.SetDefaultValue;
import io.trino.sql.tree.SetPath;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.SetRole;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetSessionAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.ShowBranches;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowCreate;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowGrants;
import io.trino.sql.tree.ShowRoleGrants;
import io.trino.sql.tree.ShowRoles;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableExecute;
import io.trino.sql.tree.TableFunctionArgument;
import io.trino.sql.tree.TableFunctionDescriptorArgument;
import io.trino.sql.tree.TableFunctionInvocation;
import io.trino.sql.tree.TableFunctionTableArgument;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.TransactionAccessMode;
import io.trino.sql.tree.TransactionMode;
import io.trino.sql.tree.TruncateTable;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.ValueColumn;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDeclaration;
import io.trino.sql.tree.WhileStatement;
import io.trino.sql.tree.WithQuery;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class SqlFormatter {
    private static final String INDENT = "   ";

    private SqlFormatter() {
    }

    public static String formatSql(Node root) {
        StringBuilder builder = new StringBuilder();
        new Formatter(builder).process(root, 0);
        return builder.toString();
    }

    private static String formatName(Identifier identifier) {
        return ExpressionFormatter.formatExpression(identifier);
    }

    public static String formatName(QualifiedName name) {
        return name.getOriginalParts().stream().map(SqlFormatter::formatName).collect(Collectors.joining("."));
    }

    private static String formatExpression(Expression expression) {
        return ExpressionFormatter.formatExpression(expression);
    }

    private static void appendAliasColumns(Formatter.SqlBuilder builder, List<Identifier> columns) {
        if (columns != null && !columns.isEmpty()) {
            String formattedColumns = columns.stream().map(SqlFormatter::formatName).collect(Collectors.joining(", "));
            builder.append(" (").append(formattedColumns).append(')');
        }
    }

    private static String formatGrantScope(GrantObject grantObject) {
        return String.format("%s%s%s", grantObject.getBranch().isPresent() ? "BRANCH " + SqlFormatter.formatName(grantObject.getBranch().get()) + " IN " : "", grantObject.getEntityKind().isPresent() ? grantObject.getEntityKind().get() + " " : "", SqlFormatter.formatName(grantObject.getName()));
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final SqlBuilder builder;

        public Formatter(StringBuilder builder) {
            this.builder = new SqlBuilder(builder);
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + String.valueOf(node));
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitExpression should only be called at root");
            this.builder.append(SqlFormatter.formatExpression(node));
            return null;
        }

        @Override
        protected Void visitRowPattern(RowPattern node, Integer indent) {
            Preconditions.checkArgument((indent == 0 ? 1 : 0) != 0, (Object)"visitRowPattern should only be called at root");
            this.builder.append(RowPatternFormatter.formatPattern(node));
            return null;
        }

        @Override
        protected Void visitUnnest(Unnest node, Integer indent) {
            this.builder.append("UNNEST(").append(node.getExpressions().stream().map(SqlFormatter::formatExpression).collect(Collectors.joining(", "))).append(")");
            if (node.isWithOrdinality()) {
                this.builder.append(" WITH ORDINALITY");
            }
            return null;
        }

        @Override
        protected Void visitJsonTable(JsonTable node, Integer indent) {
            this.builder.append("JSON_TABLE (").append(ExpressionFormatter.formatJsonPathInvocation(node.getJsonPathInvocation())).append("\n");
            this.appendJsonTableColumns(node.getColumns(), indent + 1);
            node.getPlan().ifPresent(plan -> {
                this.builder.append("\n");
                if (plan instanceof JsonTableDefaultPlan) {
                    this.append(indent + 1, "PLAN DEFAULT (");
                } else {
                    this.append(indent + 1, "PLAN (");
                }
                this.process((Node)plan, indent + 1);
                this.builder.append(")");
            });
            node.getErrorBehavior().ifPresent(behavior -> {
                this.builder.append("\n");
                this.append(indent + 1, String.valueOf(behavior) + " ON ERROR");
            });
            this.builder.append(")\n");
            return null;
        }

        private void appendJsonTableColumns(List<JsonTableColumnDefinition> columns, int indent) {
            this.append(indent, "COLUMNS (\n");
            for (int i = 0; i < columns.size() - 1; ++i) {
                this.process(columns.get(i), indent + 1);
                this.builder.append(",\n");
            }
            this.process(columns.getLast(), indent + 1);
            this.builder.append(")");
        }

        @Override
        protected Void visitOrdinalityColumn(OrdinalityColumn node, Integer indent) {
            this.append(indent, SqlFormatter.formatName(node.getName()) + " FOR ORDINALITY");
            return null;
        }

        @Override
        protected Void visitValueColumn(ValueColumn node, Integer indent) {
            this.append(indent, SqlFormatter.formatName(node.getName())).append(" ").append(SqlFormatter.formatExpression(node.getType()));
            node.getJsonPath().ifPresent(path -> this.builder.append(" PATH ").append(SqlFormatter.formatExpression(path)));
            this.builder.append(" ").append(node.getEmptyBehavior().name()).append(node.getEmptyDefault().map(expression -> " " + SqlFormatter.formatExpression(expression)).orElse("")).append(" ON EMPTY");
            node.getErrorBehavior().ifPresent(behavior -> this.builder.append(" ").append(behavior.name()).append(node.getErrorDefault().map(expression -> " " + SqlFormatter.formatExpression(expression)).orElse("")).append(" ON ERROR"));
            return null;
        }

        @Override
        protected Void visitQueryColumn(QueryColumn node, Integer indent) {
            this.append(indent, SqlFormatter.formatName(node.getName())).append(" ").append(SqlFormatter.formatExpression(node.getType())).append(" FORMAT ").append(node.getFormat().toString());
            node.getJsonPath().ifPresent(path -> this.builder.append(" PATH ").append(SqlFormatter.formatExpression(path)));
            this.builder.append(switch (node.getWrapperBehavior()) {
                default -> throw new MatchException(null, null);
                case JsonQuery.ArrayWrapperBehavior.WITHOUT -> " WITHOUT ARRAY WRAPPER";
                case JsonQuery.ArrayWrapperBehavior.CONDITIONAL -> " WITH CONDITIONAL ARRAY WRAPPER";
                case JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL -> " WITH UNCONDITIONAL ARRAY WRAPPER";
            });
            if (node.getQuotesBehavior().isPresent()) {
                this.builder.append(switch (node.getQuotesBehavior().get()) {
                    default -> throw new MatchException(null, null);
                    case JsonQuery.QuotesBehavior.KEEP -> " KEEP QUOTES ON SCALAR STRING";
                    case JsonQuery.QuotesBehavior.OMIT -> " OMIT QUOTES ON SCALAR STRING";
                });
            }
            this.builder.append(" ").append(node.getEmptyBehavior().toString()).append(" ON EMPTY");
            node.getErrorBehavior().ifPresent(behavior -> this.builder.append(" ").append(behavior.toString()).append(" ON ERROR"));
            return null;
        }

        @Override
        protected Void visitNestedColumns(NestedColumns node, Integer indent) {
            this.append(indent, "NESTED PATH ").append(SqlFormatter.formatExpression(node.getJsonPath()));
            node.getPathName().ifPresent(name -> this.builder.append(" AS ").append(SqlFormatter.formatName(name)));
            this.builder.append("\n");
            this.appendJsonTableColumns(node.getColumns(), indent + 1);
            return null;
        }

        @Override
        protected Void visitJsonTableDefaultPlan(JsonTableDefaultPlan node, Integer indent) {
            this.builder.append(node.getParentChild().name()).append(", ").append(node.getSiblings().name());
            return null;
        }

        @Override
        protected Void visitPlanParentChild(PlanParentChild node, Integer indent) {
            this.process(node.getParent());
            this.builder.append(" ").append(node.getType().name()).append(" (");
            this.process(node.getChild());
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitPlanSiblings(PlanSiblings node, Integer context) {
            for (int i = 0; i < node.getSiblings().size() - 1; ++i) {
                this.builder.append("(");
                this.process(node.getSiblings().get(i));
                this.builder.append(") ").append(node.getType().name()).append(" ");
            }
            this.builder.append("(");
            this.process(node.getSiblings().getLast());
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitPlanLeaf(PlanLeaf node, Integer context) {
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitLateral(Lateral node, Integer indent) {
            this.append(indent, "LATERAL (");
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ")");
            return null;
        }

        @Override
        protected Void visitTableFunctionInvocation(TableFunctionInvocation node, Integer indent) {
            this.append(indent, "TABLE(");
            this.appendTableFunctionInvocation(node, indent + 1);
            this.builder.append(")");
            return null;
        }

        private void appendTableFunctionInvocation(TableFunctionInvocation node, Integer indent) {
            this.builder.append(SqlFormatter.formatName(node.getName())).append("(\n");
            this.appendTableFunctionArguments(node.getArguments(), indent + 1);
            if (!node.getCopartitioning().isEmpty()) {
                this.builder.append("\n");
                this.append(indent + 1, "COPARTITION ");
                this.builder.append(node.getCopartitioning().stream().map(tableList -> tableList.stream().map(SqlFormatter::formatName).collect(Collectors.joining(", ", "(", ")"))).collect(Collectors.joining(", ")));
            }
            this.builder.append(")");
        }

        private void appendTableFunctionArguments(List<TableFunctionArgument> arguments, int indent) {
            for (int i = 0; i < arguments.size(); ++i) {
                TableFunctionArgument argument = arguments.get(i);
                if (argument.getName().isPresent()) {
                    this.append(indent, SqlFormatter.formatName(argument.getName().get()));
                    this.builder.append(" => ");
                } else {
                    this.append(indent, "");
                }
                Node value = argument.getValue();
                if (value instanceof Expression) {
                    Expression expression = (Expression)value;
                    this.builder.append(SqlFormatter.formatExpression(expression));
                } else {
                    this.process(value, indent + 1);
                }
                if (i >= arguments.size() - 1) continue;
                this.builder.append(",\n");
            }
        }

        @Override
        protected Void visitTableArgument(TableFunctionTableArgument node, Integer indent) {
            Node unaliased;
            AliasedRelation aliasedRelation;
            Relation relation = node.getTable();
            if (relation instanceof AliasedRelation) {
                aliasedRelation = (AliasedRelation)relation;
                v0 = aliasedRelation.getRelation();
            } else {
                v0 = unaliased = relation;
            }
            if (unaliased instanceof TableSubquery) {
                unaliased = ((TableSubquery)unaliased).getQuery();
            }
            this.builder.append("TABLE(");
            this.process(unaliased, indent);
            this.builder.append(")");
            if (relation instanceof AliasedRelation) {
                aliasedRelation = (AliasedRelation)relation;
                this.builder.append(" AS ").append(SqlFormatter.formatName(aliasedRelation.getAlias()));
                SqlFormatter.appendAliasColumns(this.builder, aliasedRelation.getColumnNames());
            }
            if (node.getPartitionBy().isPresent()) {
                this.builder.append("\n");
                this.append(indent, "PARTITION BY ").append(node.getPartitionBy().get().stream().map(SqlFormatter::formatExpression).collect(Collectors.joining(", ")));
            }
            node.getEmptyTableTreatment().ifPresent(treatment -> {
                this.builder.append("\n");
                this.append(indent, treatment.getTreatment().name() + " WHEN EMPTY");
            });
            node.getOrderBy().ifPresent(orderBy -> {
                this.builder.append("\n");
                this.append(indent, ExpressionFormatter.formatOrderBy(orderBy));
            });
            return null;
        }

        @Override
        protected Void visitDescriptorArgument(TableFunctionDescriptorArgument node, Integer indent) {
            if (node.getDescriptor().isPresent()) {
                this.builder.append(node.getDescriptor().get().getFields().stream().map(field -> {
                    Object formattedField = SqlFormatter.formatName(field.getName());
                    if (field.getType().isPresent()) {
                        formattedField = (String)formattedField + " " + SqlFormatter.formatExpression(field.getType().get());
                    }
                    return formattedField;
                }).collect(Collectors.joining(", ", "DESCRIPTOR(", ")")));
            } else {
                this.builder.append("CAST (NULL AS DESCRIPTOR)");
            }
            return null;
        }

        @Override
        protected Void visitPrepare(Prepare node, Integer indent) {
            this.append(indent, "PREPARE ");
            this.builder.append(SqlFormatter.formatName(node.getName()));
            this.builder.append(" FROM");
            this.builder.append("\n");
            this.process(node.getStatement(), indent + 1);
            return null;
        }

        @Override
        protected Void visitDeallocate(Deallocate node, Integer indent) {
            this.append(indent, "DEALLOCATE PREPARE ");
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitExecute(Execute node, Integer indent) {
            this.append(indent, "EXECUTE ");
            this.builder.append(SqlFormatter.formatName(node.getName()));
            List<Expression> parameters = node.getParameters();
            if (!parameters.isEmpty()) {
                this.builder.append(" USING ");
                this.builder.append(parameters.stream().map(SqlFormatter::formatExpression).collect(Collectors.joining(", ")));
            }
            return null;
        }

        @Override
        protected Void visitExecuteImmediate(ExecuteImmediate node, Integer indent) {
            this.append(indent, "EXECUTE IMMEDIATE\n").append(ExpressionFormatter.formatStringLiteral(node.getStatement().getValue()));
            List<Expression> parameters = node.getParameters();
            if (!parameters.isEmpty()) {
                this.builder.append("\nUSING ");
                this.builder.append(parameters.stream().map(SqlFormatter::formatExpression).collect(Collectors.joining(", ")));
            }
            return null;
        }

        @Override
        protected Void visitDescribeOutput(DescribeOutput node, Integer indent) {
            this.append(indent, "DESCRIBE OUTPUT ");
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitDescribeInput(DescribeInput node, Integer indent) {
            this.append(indent, "DESCRIBE INPUT ");
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            if (!node.getSessionProperties().isEmpty()) {
                this.builder.append("WITH SESSION\n");
                Iterator<SessionProperty> sessionProperties = node.getSessionProperties().iterator();
                while (sessionProperties.hasNext()) {
                    this.process(sessionProperties.next(), indent + 1);
                    if (sessionProperties.hasNext()) {
                        this.builder.append(',');
                    }
                    this.builder.append('\n');
                }
            }
            if (!node.getFunctions().isEmpty()) {
                this.builder.append("WITH\n");
                Iterator<FunctionSpecification> functions = node.getFunctions().iterator();
                while (functions.hasNext()) {
                    this.process(functions.next(), indent + 1);
                    if (functions.hasNext()) {
                        this.builder.append(',');
                    }
                    this.builder.append('\n');
                }
            }
            node.getWith().ifPresent(with -> {
                this.append(indent, "WITH");
                if (with.isRecursive()) {
                    this.builder.append(" RECURSIVE");
                }
                this.builder.append("\n  ");
                Iterator<WithQuery> queries = with.getQueries().iterator();
                while (queries.hasNext()) {
                    WithQuery query = queries.next();
                    this.append(indent, SqlFormatter.formatName(query.getName()));
                    query.getColumnNames().ifPresent(columnNames -> SqlFormatter.appendAliasColumns(this.builder, columnNames));
                    this.builder.append(" AS ");
                    this.process(new TableSubquery(query.getQuery()), indent);
                    this.builder.append('\n');
                    if (!queries.hasNext()) continue;
                    this.builder.append(", ");
                }
            });
            this.processRelation(node.getQueryBody(), indent);
            node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, indent));
            node.getOffset().ifPresent(offset -> this.process((Node)offset, indent));
            node.getLimit().ifPresent(limit -> this.process((Node)limit, indent));
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            this.process(node.getSelect(), indent);
            node.getFrom().ifPresent(from -> {
                this.append(indent, "FROM");
                this.builder.append('\n');
                this.append(indent, "  ");
                this.process((Node)from, indent);
            });
            this.builder.append('\n');
            node.getWhere().ifPresent(where -> this.append(indent, "WHERE " + SqlFormatter.formatExpression(where)).append('\n'));
            node.getGroupBy().ifPresent(groupBy -> this.append(indent, "GROUP BY " + (groupBy.isDistinct() ? " DISTINCT " : "") + ExpressionFormatter.formatGroupBy(groupBy.getGroupingElements())).append('\n'));
            node.getHaving().ifPresent(having -> this.append(indent, "HAVING " + SqlFormatter.formatExpression(having)).append('\n'));
            if (!node.getWindows().isEmpty()) {
                this.append(indent, "WINDOW");
                this.formatDefinitionList((List)node.getWindows().stream().map(definition -> SqlFormatter.formatName(definition.getName()) + " AS " + ExpressionFormatter.formatWindowSpecification(definition.getWindow())).collect(ImmutableList.toImmutableList()), indent + 1);
            }
            node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, indent));
            node.getOffset().ifPresent(offset -> this.process((Node)offset, indent));
            node.getLimit().ifPresent(limit -> this.process((Node)limit, indent));
            return null;
        }

        @Override
        protected Void visitOrderBy(OrderBy node, Integer indent) {
            this.append(indent, ExpressionFormatter.formatOrderBy(node)).append('\n');
            return null;
        }

        @Override
        protected Void visitOffset(Offset node, Integer indent) {
            this.append(indent, "OFFSET ").append(SqlFormatter.formatExpression(node.getRowCount())).append(" ROWS\n");
            return null;
        }

        @Override
        protected Void visitFetchFirst(FetchFirst node, Integer indent) {
            this.append(indent, "FETCH FIRST " + node.getRowCount().map(count -> SqlFormatter.formatExpression(count) + " ROWS ").orElse("ROW ")).append(node.isWithTies() ? "WITH TIES" : "ONLY").append('\n');
            return null;
        }

        @Override
        protected Void visitLimit(Limit node, Integer indent) {
            this.append(indent, "LIMIT ").append(SqlFormatter.formatExpression(node.getRowCount())).append('\n');
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                    this.process(item, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                this.process((Node)Iterables.getOnlyElement(node.getSelectItems()), indent);
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(SqlFormatter.formatExpression(node.getExpression()));
            node.getAlias().ifPresent(alias -> this.builder.append(' ').append(SqlFormatter.formatName(alias)));
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer indent) {
            node.getTarget().ifPresent(value -> this.builder.append(SqlFormatter.formatExpression(value)).append("."));
            this.builder.append("*");
            if (!node.getAliases().isEmpty()) {
                this.builder.append(" AS (").append(Joiner.on((String)", ").join((Iterable)node.getAliases().stream().map(SqlFormatter::formatName).collect(ImmutableList.toImmutableList()))).append(")");
            }
            return null;
        }

        @Override
        protected Void visitTable(Table node, Integer indent) {
            this.builder.append(SqlFormatter.formatName(node.getName()));
            node.getQueryPeriod().ifPresent(queryPeriod -> this.builder.append(" " + String.valueOf(queryPeriod)));
            return null;
        }

        @Override
        protected Void visitQueryPeriod(QueryPeriod node, Integer indent) {
            this.builder.append("FOR " + node.getRangeType().name() + " AS OF " + SqlFormatter.formatExpression(node.getEnd().get()));
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            Object type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + (String)type;
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append('(');
            }
            this.process(node.getLeft(), indent);
            this.builder.append('\n');
            if (node.getType() == Join.Type.IMPLICIT) {
                this.append(indent, ", ");
            } else {
                this.append(indent, (String)type).append(" JOIN ");
            }
            this.process(node.getRight(), indent);
            if (node.getType() != Join.Type.CROSS && node.getType() != Join.Type.IMPLICIT) {
                if (criteria instanceof JoinUsing) {
                    JoinUsing using = (JoinUsing)criteria;
                    this.builder.append(" USING (").append(Joiner.on((String)", ").join(using.getColumns())).append(")");
                } else if (criteria instanceof JoinOn) {
                    JoinOn on = (JoinOn)criteria;
                    this.builder.append(" ON ").append(SqlFormatter.formatExpression(on.getExpression()));
                } else if (!(criteria instanceof NaturalJoin)) {
                    throw new UnsupportedOperationException("unknown join criteria: " + String.valueOf(criteria));
                }
            }
            if (node.getType() != Join.Type.IMPLICIT) {
                this.builder.append(")");
            }
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            this.processRelationSuffix(node.getRelation(), indent);
            this.builder.append(' ').append(SqlFormatter.formatName(node.getAlias()));
            SqlFormatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitPatternRecognitionRelation(PatternRecognitionRelation node, Integer indent) {
            this.processRelationSuffix(node.getInput(), indent);
            this.builder.append(" MATCH_RECOGNIZE (\n");
            if (!node.getPartitionBy().isEmpty()) {
                this.append(indent + 1, "PARTITION BY ").append(node.getPartitionBy().stream().map(SqlFormatter::formatExpression).collect(Collectors.joining(", "))).append("\n");
            }
            node.getOrderBy().ifPresent(orderBy -> this.process((Node)orderBy, indent + 1));
            if (!node.getMeasures().isEmpty()) {
                this.append(indent + 1, "MEASURES");
                this.formatDefinitionList((List)node.getMeasures().stream().map(measure -> SqlFormatter.formatExpression(measure.getExpression()) + " AS " + SqlFormatter.formatName(measure.getName())).collect(ImmutableList.toImmutableList()), indent + 2);
            }
            node.getRowsPerMatch().ifPresent(rowsPerMatch -> {
                String rowsPerMatchDescription = switch (rowsPerMatch) {
                    case PatternRecognitionRelation.RowsPerMatch.ONE -> "ONE ROW PER MATCH";
                    case PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY -> "ALL ROWS PER MATCH SHOW EMPTY MATCHES";
                    case PatternRecognitionRelation.RowsPerMatch.ALL_OMIT_EMPTY -> "ALL ROWS PER MATCH OMIT EMPTY MATCHES";
                    case PatternRecognitionRelation.RowsPerMatch.ALL_WITH_UNMATCHED -> "ALL ROWS PER MATCH WITH UNMATCHED ROWS";
                    default -> throw new IllegalStateException("unexpected rowsPerMatch: " + String.valueOf((Object)node.getRowsPerMatch().get()));
                };
                this.append(indent + 1, rowsPerMatchDescription).append("\n");
            });
            node.getAfterMatchSkipTo().ifPresent(afterMatchSkipTo -> {
                String skipTo = ExpressionFormatter.formatSkipTo(afterMatchSkipTo);
                this.append(indent + 1, skipTo).append("\n");
            });
            node.getPatternSearchMode().ifPresent(patternSearchMode -> this.append(indent + 1, patternSearchMode.getMode().name()).append("\n"));
            this.append(indent + 1, "PATTERN (").append(RowPatternFormatter.formatPattern(node.getPattern())).append(")\n");
            if (!node.getSubsets().isEmpty()) {
                this.append(indent + 1, "SUBSET");
                this.formatDefinitionList((List)node.getSubsets().stream().map(subset -> SqlFormatter.formatName(subset.getName()) + " = " + subset.getIdentifiers().stream().map(SqlFormatter::formatName).collect(Collectors.joining(", ", "(", ")"))).collect(ImmutableList.toImmutableList()), indent + 2);
            }
            this.append(indent + 1, "DEFINE");
            this.formatDefinitionList((List)node.getVariableDefinitions().stream().map(variable -> SqlFormatter.formatName(variable.getName()) + " AS " + SqlFormatter.formatExpression(variable.getExpression())).collect(ImmutableList.toImmutableList()), indent + 2);
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitSampledRelation(SampledRelation node, Integer indent) {
            this.processRelationSuffix(node.getRelation(), indent);
            this.builder.append(" TABLESAMPLE ").append(node.getType().name()).append(" (").append(SqlFormatter.formatExpression(node.getSamplePercentage())).append(')');
            return null;
        }

        private void processRelationSuffix(Relation relation, Integer indent) {
            if (relation instanceof AliasedRelation || relation instanceof SampledRelation || relation instanceof PatternRecognitionRelation) {
                this.builder.append("( ");
                this.process(relation, indent + 1);
                this.append(indent, ")");
            } else {
                this.process(relation, indent);
            }
        }

        @Override
        protected Void visitValues(Values node, Integer indent) {
            this.builder.append(" VALUES ");
            boolean first = true;
            for (Expression row : node.getRows()) {
                this.builder.append("\n").append(Formatter.indentString(indent)).append(first ? "  " : ", ");
                this.builder.append(SqlFormatter.formatExpression(row));
                first = false;
            }
            this.builder.append('\n');
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append('\n');
            this.process(node.getQuery(), indent + 1);
            this.append(indent, ") ");
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("UNION ");
                if (!node.isDistinct()) {
                    this.builder.append("ALL ");
                }
                this.appendCorresponding(node.getCorresponding());
            }
            return null;
        }

        @Override
        protected Void visitExcept(Except node, Integer indent) {
            this.processRelation(node.getLeft(), indent);
            this.builder.append("EXCEPT ");
            if (!node.isDistinct()) {
                this.builder.append("ALL ");
            }
            this.appendCorresponding(node.getCorresponding());
            this.processRelation(node.getRight(), indent);
            return null;
        }

        @Override
        protected Void visitIntersect(Intersect node, Integer indent) {
            Iterator<Relation> relations = node.getRelations().iterator();
            while (relations.hasNext()) {
                this.processRelation(relations.next(), indent);
                if (!relations.hasNext()) continue;
                this.builder.append("INTERSECT ");
                if (!node.isDistinct()) {
                    this.builder.append("ALL ");
                }
                this.appendCorresponding(node.getCorresponding());
            }
            return null;
        }

        private void appendCorresponding(Optional<Corresponding> node) {
            node.ifPresent(corresponding -> {
                this.builder.append("CORRESPONDING ");
                if (!corresponding.getColumns().isEmpty()) {
                    this.builder.append("BY ");
                    this.builder.append(corresponding.getColumns().stream().map(SqlFormatter::formatName).collect(Collectors.joining(", ", "(", ") ")));
                }
            });
        }

        @Override
        protected Void visitMerge(Merge node, Integer indent) {
            this.builder.append("MERGE INTO ").append(SqlFormatter.formatName(node.getTargetTable().getName()));
            node.getTargetTable().getBranch().ifPresent(branch -> this.builder.append("@").append(SqlFormatter.formatName(branch)));
            node.getTargetAlias().ifPresent(value -> this.builder.append(' ').append(SqlFormatter.formatName(value)));
            this.builder.append("\n");
            this.append(indent + 1, "USING ");
            this.processRelation(node.getSource(), indent + 2);
            this.builder.append("\n");
            this.append(indent + 1, "ON ");
            this.builder.append(SqlFormatter.formatExpression(node.getPredicate()));
            for (MergeCase mergeCase : node.getMergeCases()) {
                this.builder.append("\n");
                this.process(mergeCase, indent);
            }
            return null;
        }

        @Override
        protected Void visitMergeInsert(MergeInsert node, Integer indent) {
            this.appendMergeCaseWhen(false, node.getExpression());
            this.append(indent + 1, "THEN INSERT ");
            if (!node.getColumns().isEmpty()) {
                this.builder.append(node.getColumns().stream().map(SqlFormatter::formatName).collect(Collectors.joining(", ", "(", ")")));
            }
            this.builder.append("VALUES ");
            this.builder.append(node.getValues().stream().map(SqlFormatter::formatExpression).collect(Collectors.joining(", ", "(", ")")));
            return null;
        }

        @Override
        protected Void visitMergeUpdate(MergeUpdate node, Integer indent) {
            this.appendMergeCaseWhen(true, node.getExpression());
            this.append(indent + 1, "THEN UPDATE SET");
            boolean first = true;
            for (MergeUpdate.Assignment assignment : node.getAssignments()) {
                this.builder.append("\n");
                this.append(indent + 1, first ? "  " : ", ");
                this.builder.append(SqlFormatter.formatName(assignment.getTarget())).append(" = ").append(SqlFormatter.formatExpression(assignment.getValue()));
                first = false;
            }
            return null;
        }

        @Override
        protected Void visitMergeDelete(MergeDelete node, Integer indent) {
            this.appendMergeCaseWhen(true, node.getExpression());
            this.append(indent + 1, "THEN DELETE");
            return null;
        }

        private void appendMergeCaseWhen(boolean matched, Optional<Expression> expression) {
            this.builder.append(matched ? "WHEN MATCHED" : "WHEN NOT MATCHED");
            expression.ifPresent(value -> this.builder.append(" AND ").append(SqlFormatter.formatExpression(value)));
            this.builder.append("\n");
        }

        @Override
        protected Void visitCreateView(CreateView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("VIEW ").append(SqlFormatter.formatName(node.getName()));
            node.getComment().ifPresent(comment -> this.builder.append(" COMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            node.getSecurity().ifPresent(security -> this.builder.append(" SECURITY ").append(security.name()));
            this.builder.append(Formatter.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitRenameView(RenameView node, Integer indent) {
            this.builder.append("ALTER VIEW ").append(SqlFormatter.formatName(node.getSource())).append(" RENAME TO ").append(SqlFormatter.formatName(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitRenameMaterializedView(RenameMaterializedView node, Integer indent) {
            this.builder.append("ALTER MATERIALIZED VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSource())).append(" RENAME TO ").append(SqlFormatter.formatName(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitSetAuthorization(SetAuthorizationStatement node, Integer indent) {
            this.builder.append("ALTER ").append(node.getOwnedEntityKind()).append(" ").append(SqlFormatter.formatName(node.getSource())).append(" SET AUTHORIZATION ").append(Formatter.formatPrincipal(node.getPrincipal()));
            return null;
        }

        @Override
        protected Void visitCreateMaterializedView(CreateMaterializedView node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("MATERIALIZED VIEW ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            node.getGracePeriod().ifPresent(interval -> this.builder.append("\nGRACE PERIOD ").append(SqlFormatter.formatExpression(interval)));
            node.getWhenStaleBehavior().ifPresent(whenStale -> this.builder.append("\nWHEN STALE ").append(whenStale.name()));
            node.getComment().ifPresent(comment -> this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            this.builder.append(Formatter.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" AS\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitRefreshMaterializedView(RefreshMaterializedView node, Integer indent) {
            this.builder.append("REFRESH MATERIALIZED VIEW ");
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitRefreshView(RefreshView node, Integer indent) {
            this.builder.append("ALTER VIEW ");
            this.builder.append(SqlFormatter.formatName(node.getName()));
            this.builder.append(" REFRESH");
            return null;
        }

        @Override
        protected Void visitDropMaterializedView(DropMaterializedView node, Integer indent) {
            this.builder.append("DROP MATERIALIZED VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitDropView(DropView node, Integer indent) {
            this.builder.append("DROP VIEW ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.builder.append("EXPLAIN ");
            ArrayList<CallSite> options = new ArrayList<CallSite>();
            for (ExplainOption option : node.getOptions()) {
                if (option instanceof ExplainType) {
                    ExplainType explainType = (ExplainType)option;
                    options.add((CallSite)((Object)("TYPE " + String.valueOf((Object)explainType.getType()))));
                    continue;
                }
                if (option instanceof ExplainFormat) {
                    ExplainFormat explainFormat = (ExplainFormat)option;
                    options.add((CallSite)((Object)("FORMAT " + String.valueOf((Object)explainFormat.getType()))));
                    continue;
                }
                throw new UnsupportedOperationException("unhandled explain option: " + String.valueOf(option));
            }
            if (!options.isEmpty()) {
                this.builder.append(options.stream().collect(Collectors.joining(", ", "(", ")")));
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitExplainAnalyze(ExplainAnalyze node, Integer indent) {
            this.builder.append("EXPLAIN ANALYZE");
            if (node.isVerbose()) {
                this.builder.append(" VERBOSE");
            }
            this.builder.append("\n");
            this.process(node.getStatement(), indent);
            return null;
        }

        @Override
        protected Void visitShowCatalogs(ShowCatalogs node, Integer indent) {
            this.builder.append("SHOW CATALOGS");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowSchemas(ShowSchemas node, Integer indent) {
            this.builder.append("SHOW SCHEMAS");
            node.getCatalog().ifPresent(catalog -> this.builder.append(" FROM ").append(SqlFormatter.formatName(catalog)));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowTables(ShowTables node, Integer indent) {
            this.builder.append("SHOW TABLES");
            node.getSchema().ifPresent(value -> this.builder.append(" FROM ").append(SqlFormatter.formatName(value)));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowCreate(ShowCreate node, Integer indent) {
            SqlBuilder sqlBuilder = this.builder.append("SHOW CREATE ");
            sqlBuilder.append(switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case ShowCreate.Type.SCHEMA -> "SCHEMA";
                case ShowCreate.Type.TABLE -> "TABLE";
                case ShowCreate.Type.VIEW -> "VIEW";
                case ShowCreate.Type.MATERIALIZED_VIEW -> "MATERIALIZED VIEW";
                case ShowCreate.Type.FUNCTION -> "FUNCTION";
            }).append(" ").append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitShowColumns(ShowColumns node, Integer indent) {
            this.builder.append("SHOW COLUMNS FROM ").append(SqlFormatter.formatName(node.getTable()));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowStats(ShowStats node, Integer indent) {
            this.builder.append("SHOW STATS FOR ");
            this.process(node.getRelation(), 0);
            return null;
        }

        @Override
        protected Void visitShowFunctions(ShowFunctions node, Integer indent) {
            this.builder.append("SHOW FUNCTIONS");
            node.getSchema().ifPresent(value -> this.builder.append(" FROM ").append(SqlFormatter.formatName(value)));
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitShowSession(ShowSession node, Integer indent) {
            this.builder.append("SHOW SESSION");
            node.getLikePattern().ifPresent(value -> this.builder.append(" LIKE ").append(ExpressionFormatter.formatStringLiteral(value)));
            node.getEscape().ifPresent(value -> this.builder.append(" ESCAPE ").append(ExpressionFormatter.formatStringLiteral(value)));
            return null;
        }

        @Override
        protected Void visitDelete(Delete node, Integer indent) {
            this.builder.append("DELETE FROM ").append(SqlFormatter.formatName(node.getTable().getName()));
            node.getTable().getBranch().ifPresent(branch -> this.builder.append("@").append(SqlFormatter.formatName(branch)));
            node.getWhere().ifPresent(where -> this.builder.append(" WHERE ").append(SqlFormatter.formatExpression(where)));
            return null;
        }

        @Override
        protected Void visitCreateCatalog(CreateCatalog node, Integer indent) {
            this.builder.append("CREATE CATALOG ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getCatalogName()));
            this.builder.append(" USING ").append(SqlFormatter.formatName(node.getConnectorName()));
            node.getComment().ifPresent(comment -> this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            node.getPrincipal().ifPresent(principal -> this.builder.append("\nAUTHORIZATION ").append(Formatter.formatPrincipal(principal)));
            this.builder.append(Formatter.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitDropCatalog(DropCatalog node, Integer indent) {
            this.builder.append("DROP CATALOG ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getCatalogName())).append(" ").append(node.isCascade() ? "CASCADE" : "RESTRICT");
            return null;
        }

        @Override
        protected Void visitCreateSchema(CreateSchema node, Integer indent) {
            this.builder.append("CREATE SCHEMA ");
            if (node.isNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSchemaName()));
            node.getPrincipal().ifPresent(principal -> this.builder.append("\nAUTHORIZATION ").append(Formatter.formatPrincipal(principal)));
            this.builder.append(Formatter.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitDropSchema(DropSchema node, Integer indent) {
            this.builder.append("DROP SCHEMA ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSchemaName())).append(" ").append(node.isCascade() ? "CASCADE" : "RESTRICT");
            return null;
        }

        @Override
        protected Void visitRenameSchema(RenameSchema node, Integer indent) {
            this.builder.append("ALTER SCHEMA ").append(SqlFormatter.formatName(node.getSource())).append(" RENAME TO ").append(SqlFormatter.formatName(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitCreateTableAsSelect(CreateTableAsSelect node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.getSaveMode() == SaveMode.REPLACE) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("TABLE ");
            if (node.getSaveMode() == SaveMode.IGNORE) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            node.getColumnAliases().ifPresent(columnAliases -> this.builder.append(columnAliases.stream().map(SqlFormatter::formatName).collect(Collectors.joining(", ", "( ", " )"))));
            node.getComment().ifPresent(comment -> this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            this.builder.append(Formatter.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" AS ");
            this.process(node.getQuery(), indent);
            if (!node.isWithData()) {
                this.builder.append(" WITH NO DATA");
            }
            return null;
        }

        @Override
        protected Void visitCreateTable(CreateTable node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.getSaveMode() == SaveMode.REPLACE) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("TABLE ");
            if (node.getSaveMode() == SaveMode.IGNORE) {
                this.builder.append("IF NOT EXISTS ");
            }
            String tableName = SqlFormatter.formatName(node.getName());
            this.builder.append(tableName).append(" (\n");
            String elementIndent = Formatter.indentString(indent + 1);
            String columnList = node.getElements().stream().map(element -> {
                if (element instanceof ColumnDefinition) {
                    ColumnDefinition column = (ColumnDefinition)element;
                    return elementIndent + Formatter.formatColumnDefinition(column);
                }
                if (element instanceof LikeClause) {
                    LikeClause likeClause = (LikeClause)element;
                    StringBuilder builder = new StringBuilder(elementIndent);
                    builder.append("LIKE ").append(SqlFormatter.formatName(likeClause.getTableName()));
                    likeClause.getPropertiesOption().ifPresent(propertiesOption -> builder.append(" ").append(propertiesOption.name()).append(" PROPERTIES"));
                    return builder.toString();
                }
                throw new UnsupportedOperationException("unknown table element: " + String.valueOf(element));
            }).collect(Collectors.joining(",\n"));
            this.builder.append(columnList);
            this.builder.append("\n").append(")");
            node.getComment().ifPresent(comment -> this.builder.append("\nCOMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            this.builder.append(Formatter.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        private static String formatPropertiesMultiLine(List<Property> properties) {
            if (properties.isEmpty()) {
                return "";
            }
            return properties.stream().map(property -> SqlFormatter.INDENT + Formatter.formatProperty(property)).collect(Collectors.joining(",\n", "\nWITH (\n", "\n)"));
        }

        private static String formatColumnDefinition(ColumnDefinition column) {
            StringBuilder builder = new StringBuilder().append(SqlFormatter.formatName(column.getName())).append(" ").append(column.getType());
            column.getDefaultValue().ifPresent(defaultValue -> builder.append(" DEFAULT ").append(SqlFormatter.formatExpression(defaultValue)));
            if (!column.isNullable()) {
                builder.append(" NOT NULL");
            }
            column.getComment().ifPresent(comment -> builder.append(" COMMENT ").append(ExpressionFormatter.formatStringLiteral(comment)));
            if (!column.getProperties().isEmpty()) {
                builder.append(" WITH (").append(Formatter.joinProperties(column.getProperties())).append(")");
            }
            return builder.toString();
        }

        private static String formatGrantor(GrantorSpecification grantor) {
            GrantorSpecification.Type type = grantor.type();
            return switch (type) {
                default -> throw new MatchException(null, null);
                case GrantorSpecification.Type.CURRENT_ROLE, GrantorSpecification.Type.CURRENT_USER -> type.name();
                case GrantorSpecification.Type.PRINCIPAL -> Formatter.formatPrincipal(grantor.principal().get());
            };
        }

        private static String formatPrincipal(PrincipalSpecification principal) {
            PrincipalSpecification.Type type = principal.type();
            return switch (type) {
                default -> throw new MatchException(null, null);
                case PrincipalSpecification.Type.UNSPECIFIED -> principal.name().toString();
                case PrincipalSpecification.Type.USER, PrincipalSpecification.Type.ROLE -> type.name() + " " + String.valueOf(principal.name());
            };
        }

        @Override
        protected Void visitDropTable(DropTable node, Integer indent) {
            this.builder.append("DROP TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTableName()));
            return null;
        }

        @Override
        protected Void visitRenameTable(RenameTable node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSource())).append(" RENAME TO ").append(SqlFormatter.formatName(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitSetProperties(SetProperties node, Integer context) {
            SetProperties.Type type = node.getType();
            this.builder.append("ALTER ");
            this.builder.append(switch (type) {
                default -> throw new MatchException(null, null);
                case SetProperties.Type.TABLE -> "TABLE ";
                case SetProperties.Type.MATERIALIZED_VIEW -> "MATERIALIZED VIEW ";
            });
            this.builder.append(SqlFormatter.formatName(node.getName())).append(" SET PROPERTIES ").append(Formatter.joinProperties(node.getProperties()));
            return null;
        }

        private static String joinProperties(List<Property> properties) {
            return properties.stream().map(Formatter::formatProperty).collect(Collectors.joining(", "));
        }

        private static String formatProperty(Property property) {
            return SqlFormatter.formatName(property.getName()) + " = " + (property.isSetToDefault() ? "DEFAULT" : SqlFormatter.formatExpression(property.getNonDefaultValue()));
        }

        @Override
        protected Void visitComment(Comment node, Integer context) {
            String comment = node.getComment().map(ExpressionFormatter::formatStringLiteral).orElse("NULL");
            String type = switch (node.getType()) {
                default -> throw new MatchException(null, null);
                case Comment.Type.TABLE -> "TABLE";
                case Comment.Type.VIEW -> "VIEW";
                case Comment.Type.COLUMN -> "COLUMN";
            };
            this.builder.append("COMMENT ON " + type + " " + SqlFormatter.formatName(node.getName()) + " IS " + comment);
            return null;
        }

        @Override
        protected Void visitRenameColumn(RenameColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTable())).append(" RENAME COLUMN ");
            if (node.isColumnExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getSource())).append(" TO ").append(SqlFormatter.formatName(node.getTarget()));
            return null;
        }

        @Override
        protected Void visitDropColumn(DropColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTable())).append(" DROP COLUMN ");
            if (node.isColumnExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getField()));
            return null;
        }

        @Override
        protected Void visitTableExecute(TableExecute node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            this.builder.append(SqlFormatter.formatName(node.getTable().getName()));
            this.builder.append(" EXECUTE ");
            this.builder.append(SqlFormatter.formatName(node.getProcedureName()));
            if (!node.getArguments().isEmpty()) {
                this.builder.append("(");
                this.formatCallArguments(indent, node.getArguments());
                this.builder.append(")");
            }
            node.getWhere().ifPresent(where -> this.builder.append("\n").append(Formatter.indentString(indent)).append("WHERE ").append(SqlFormatter.formatExpression(where)));
            return null;
        }

        @Override
        protected Void visitAnalyze(Analyze node, Integer indent) {
            this.builder.append("ANALYZE ").append(SqlFormatter.formatName(node.getTableName()));
            this.builder.append(Formatter.formatPropertiesMultiLine(node.getProperties()));
            return null;
        }

        @Override
        protected Void visitAddColumn(AddColumn node, Integer indent) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName())).append(" ADD COLUMN ");
            if (node.isColumnNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(Formatter.formatColumnDefinition(node.getColumn()));
            node.getPosition().ifPresent(position -> {
                ColumnPosition columnPosition = position;
                Objects.requireNonNull(columnPosition);
                ColumnPosition selector0$temp = columnPosition;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ColumnPosition.First.class, ColumnPosition.After.class, ColumnPosition.Last.class}, (ColumnPosition)selector0$temp, index$1)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        this.builder.append(" FIRST");
                        break;
                    }
                    case 1: {
                        ColumnPosition.After after = (ColumnPosition.After)selector0$temp;
                        this.builder.append(" AFTER ").append(SqlFormatter.formatName(after.column()));
                        break;
                    }
                    case 2: {
                        this.builder.append(" LAST");
                    }
                }
            });
            return null;
        }

        @Override
        protected Void visitSetDefaultValue(SetDefaultValue node, Integer context) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTableName())).append(" ALTER COLUMN ").append(SqlFormatter.formatName(node.getColumnName())).append(" SET DEFAULT ").append(SqlFormatter.formatExpression(node.getDefaultValue()));
            return null;
        }

        @Override
        protected Void visitDropDefaultValue(DropDefaultValue node, Integer context) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTableName())).append(" ALTER COLUMN ").append(SqlFormatter.formatName(node.getColumnName())).append(" DROP DEFAULT");
            return null;
        }

        @Override
        protected Void visitSetColumnType(SetColumnType node, Integer context) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTableName())).append(" ALTER COLUMN ").append(SqlFormatter.formatName(node.getColumnName())).append(" SET DATA TYPE ").append(node.getType().toString());
            return null;
        }

        @Override
        protected Void visitDropNotNullConstraint(DropNotNullConstraint node, Integer context) {
            this.builder.append("ALTER TABLE ");
            if (node.isTableExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getTable())).append(" ALTER COLUMN ").append(SqlFormatter.formatName(node.getColumn())).append(" DROP NOT NULL");
            return null;
        }

        @Override
        protected Void visitInsert(Insert node, Integer indent) {
            this.builder.append("INSERT INTO ").append(SqlFormatter.formatName(node.getTarget()));
            node.getTable().getBranch().ifPresent(branch -> this.builder.append("@").append(SqlFormatter.formatName(branch)));
            node.getColumns().ifPresent(columns -> this.builder.append(" (").append(Joiner.on((String)", ").join((Iterable)columns)).append(")"));
            this.builder.append("\n");
            this.process(node.getQuery(), indent);
            return null;
        }

        @Override
        protected Void visitUpdate(Update node, Integer indent) {
            this.builder.append("UPDATE ").append(SqlFormatter.formatName(node.getTable().getName()));
            node.getTable().getBranch().ifPresent(branch -> this.builder.append("@").append(SqlFormatter.formatName(branch)));
            this.builder.append(" SET");
            int setCounter = node.getAssignments().size() - 1;
            for (UpdateAssignment assignment : node.getAssignments()) {
                this.builder.append("\n").append(Formatter.indentString(indent + 1)).append(assignment.getName().getValue()).append(" = ").append(SqlFormatter.formatExpression(assignment.getValue()));
                if (setCounter > 0) {
                    this.builder.append(",");
                }
                --setCounter;
            }
            node.getWhere().ifPresent(where -> this.builder.append("\n").append(Formatter.indentString(indent)).append("WHERE ").append(SqlFormatter.formatExpression(where)));
            return null;
        }

        @Override
        protected Void visitTruncateTable(TruncateTable node, Integer indent) {
            this.builder.append("TRUNCATE TABLE ");
            this.builder.append(SqlFormatter.formatName(node.getTableName()));
            return null;
        }

        @Override
        public Void visitSetSession(SetSession node, Integer indent) {
            this.builder.append("SET SESSION ").append(SqlFormatter.formatName(node.getName())).append(" = ").append(SqlFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        public Void visitResetSession(ResetSession node, Integer indent) {
            this.builder.append("RESET SESSION ").append(SqlFormatter.formatName(node.getName()));
            return null;
        }

        @Override
        protected Void visitSetSessionAuthorization(SetSessionAuthorization node, Integer context) {
            this.builder.append("SET SESSION AUTHORIZATION ");
            this.builder.append(SqlFormatter.formatExpression(node.getUser()));
            return null;
        }

        @Override
        protected Void visitResetSessionAuthorization(ResetSessionAuthorization node, Integer context) {
            this.builder.append("RESET SESSION AUTHORIZATION");
            return null;
        }

        @Override
        protected Void visitCallArgument(CallArgument node, Integer indent) {
            node.getName().ifPresent(name -> this.builder.append(SqlFormatter.formatName(name)).append(" => "));
            this.builder.append(SqlFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        protected Void visitCall(Call node, Integer indent) {
            this.builder.append("CALL ").append(SqlFormatter.formatName(node.getName())).append("(");
            this.formatCallArguments(indent, node.getArguments());
            this.builder.append(")");
            return null;
        }

        private void formatCallArguments(Integer indent, List<CallArgument> arguments) {
            Iterator<CallArgument> iterator = arguments.iterator();
            while (iterator.hasNext()) {
                this.process(iterator.next(), indent);
                if (!iterator.hasNext()) continue;
                this.builder.append(", ");
            }
        }

        @Override
        protected Void visitRow(Row node, Integer indent) {
            this.builder.append("ROW(");
            boolean firstItem = true;
            for (Row.Field field : node.getFields()) {
                if (!firstItem) {
                    this.builder.append(", ");
                }
                this.process(field, indent);
                firstItem = false;
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitRowField(Row.Field node, Integer context) {
            this.builder.append(SqlFormatter.formatExpression(node.getExpression()));
            node.getName().ifPresent(name -> this.builder.append(" AS ").append(SqlFormatter.formatName(name)));
            return null;
        }

        @Override
        protected Void visitStartTransaction(StartTransaction node, Integer indent) {
            this.builder.append("START TRANSACTION");
            Iterator<TransactionMode> iterator = node.getTransactionModes().iterator();
            while (iterator.hasNext()) {
                this.builder.append(" ");
                this.process(iterator.next(), indent);
                if (!iterator.hasNext()) continue;
                this.builder.append(",");
            }
            return null;
        }

        @Override
        protected Void visitIsolationLevel(Isolation node, Integer indent) {
            this.builder.append("ISOLATION LEVEL ").append(node.getLevel().getText());
            return null;
        }

        @Override
        protected Void visitTransactionAccessMode(TransactionAccessMode node, Integer indent) {
            this.builder.append(node.isReadOnly() ? "READ ONLY" : "READ WRITE");
            return null;
        }

        @Override
        protected Void visitCommit(Commit node, Integer indent) {
            this.builder.append("COMMIT");
            return null;
        }

        @Override
        protected Void visitRollback(Rollback node, Integer indent) {
            this.builder.append("ROLLBACK");
            return null;
        }

        @Override
        protected Void visitCreateRole(CreateRole node, Integer indent) {
            this.builder.append("CREATE ROLE ").append(SqlFormatter.formatName(node.getName()));
            node.getGrantor().ifPresent(grantor -> this.builder.append(" WITH ADMIN ").append(Formatter.formatGrantor(grantor)));
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(SqlFormatter.formatName(catalog)));
            return null;
        }

        @Override
        protected Void visitDropRole(DropRole node, Integer indent) {
            this.builder.append("DROP ROLE ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(SqlFormatter.formatName(catalog)));
            return null;
        }

        @Override
        protected Void visitGrantRoles(GrantRoles node, Integer indent) {
            this.builder.append("GRANT ");
            this.builder.append(node.getRoles().stream().map(Expression::toString).collect(Collectors.joining(", ")));
            this.builder.append(" TO ");
            this.builder.append(node.getGrantees().stream().map(Formatter::formatPrincipal).collect(Collectors.joining(", ")));
            if (node.isAdminOption()) {
                this.builder.append(" WITH ADMIN OPTION");
            }
            node.getGrantor().ifPresent(grantor -> this.builder.append(" GRANTED BY ").append(Formatter.formatGrantor(grantor)));
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(SqlFormatter.formatName(catalog)));
            return null;
        }

        @Override
        protected Void visitRevokeRoles(RevokeRoles node, Integer indent) {
            this.builder.append("REVOKE ");
            if (node.isAdminOption()) {
                this.builder.append("ADMIN OPTION FOR ");
            }
            this.builder.append(node.getRoles().stream().map(Expression::toString).collect(Collectors.joining(", ")));
            this.builder.append(" FROM ");
            this.builder.append(node.getGrantees().stream().map(Formatter::formatPrincipal).collect(Collectors.joining(", ")));
            node.getGrantor().ifPresent(grantor -> this.builder.append(" GRANTED BY ").append(Formatter.formatGrantor(grantor)));
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(SqlFormatter.formatName(catalog)));
            return null;
        }

        @Override
        protected Void visitSetRole(SetRole node, Integer indent) {
            this.builder.append("SET ROLE ");
            SetRole.Type type = node.getType();
            this.builder.append(switch (type) {
                default -> throw new MatchException(null, null);
                case SetRole.Type.ALL, SetRole.Type.NONE -> type.name();
                case SetRole.Type.ROLE -> SqlFormatter.formatName(node.getRole().get());
            });
            node.getCatalog().ifPresent(catalog -> this.builder.append(" IN ").append(SqlFormatter.formatName(catalog)));
            return null;
        }

        @Override
        public Void visitGrant(Grant node, Integer indent) {
            this.builder.append("GRANT ");
            if (node.getPrivileges().isEmpty()) {
                this.builder.append("ALL PRIVILEGES");
            } else {
                this.builder.append(node.getPrivileges().map(privileges -> String.join((CharSequence)", ", privileges)).orElseThrow());
            }
            this.builder.append(" ON ").append(SqlFormatter.formatGrantScope(node.getGrantObject())).append(" TO ").append(Formatter.formatPrincipal(node.getGrantee()));
            if (node.isWithGrantOption()) {
                this.builder.append(" WITH GRANT OPTION");
            }
            return null;
        }

        @Override
        public Void visitDeny(Deny node, Integer indent) {
            this.builder.append("DENY ");
            if (node.getPrivileges().isPresent()) {
                this.builder.append(String.join((CharSequence)", ", (Iterable<? extends CharSequence>)node.getPrivileges().get()));
            } else {
                this.builder.append("ALL PRIVILEGES");
            }
            this.builder.append(" ON ").append(SqlFormatter.formatGrantScope(node.getGrantObject())).append(" TO ").append(Formatter.formatPrincipal(node.getGrantee()));
            return null;
        }

        @Override
        public Void visitRevoke(Revoke node, Integer indent) {
            this.builder.append("REVOKE ");
            if (node.isGrantOptionFor()) {
                this.builder.append("GRANT OPTION FOR ");
            }
            if (node.getPrivileges().isEmpty()) {
                this.builder.append("ALL PRIVILEGES");
            } else {
                this.builder.append(node.getPrivileges().map(privileges -> String.join((CharSequence)", ", privileges)).orElseThrow());
            }
            this.builder.append(" ON ").append(SqlFormatter.formatGrantScope(node.getGrantObject())).append(" FROM ").append(Formatter.formatPrincipal(node.getGrantee()));
            return null;
        }

        @Override
        public Void visitShowGrants(ShowGrants node, Integer indent) {
            this.builder.append("SHOW GRANTS ");
            node.getGrantObject().ifPresent(scope -> this.builder.append("ON ").append(SqlFormatter.formatGrantScope(scope)));
            return null;
        }

        @Override
        protected Void visitShowRoles(ShowRoles node, Integer indent) {
            this.builder.append("SHOW ");
            if (node.isCurrent()) {
                this.builder.append("CURRENT ");
            }
            this.builder.append("ROLES");
            node.getCatalog().ifPresent(catalog -> this.builder.append(" FROM ").append(SqlFormatter.formatName(catalog)));
            return null;
        }

        @Override
        protected Void visitShowRoleGrants(ShowRoleGrants node, Integer indent) {
            this.builder.append("SHOW ROLE GRANTS");
            node.getCatalog().ifPresent(catalog -> this.builder.append(" FROM ").append(SqlFormatter.formatName(catalog)));
            return null;
        }

        @Override
        public Void visitSetPath(SetPath node, Integer indent) {
            this.builder.append("SET PATH ");
            this.builder.append(Joiner.on((String)", ").join(node.getPathSpecification().getPath()));
            return null;
        }

        @Override
        public Void visitSetTimeZone(SetTimeZone node, Integer indent) {
            this.builder.append("SET TIME ZONE ");
            this.builder.append(node.getTimeZone().map(SqlFormatter::formatExpression).orElse("LOCAL"));
            return null;
        }

        @Override
        protected Void visitCreateFunction(CreateFunction node, Integer indent) {
            this.builder.append("CREATE ");
            if (node.isReplace()) {
                this.builder.append("OR REPLACE ");
            }
            this.process(node.getSpecification(), indent);
            return null;
        }

        @Override
        protected Void visitDropFunction(DropFunction node, Integer indent) {
            this.builder.append("DROP FUNCTION ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getName()));
            this.processParameters(node.getParameters(), indent);
            return null;
        }

        @Override
        protected Void visitFunctionSpecification(FunctionSpecification node, Integer indent) {
            this.append(indent, "FUNCTION ").append(SqlFormatter.formatName(node.getName()));
            this.processParameters(node.getParameters(), indent);
            this.builder.append("\n");
            this.process(node.getReturnsClause(), indent);
            this.builder.append("\n");
            for (RoutineCharacteristic characteristic : node.getRoutineCharacteristics()) {
                this.process(characteristic, indent);
                this.builder.append("\n");
            }
            node.getStatement().ifPresent(statement -> this.process((Node)statement, indent));
            node.getDefinition().map(StringLiteral::getValue).ifPresent(definition -> {
                this.append(indent, "AS ");
                this.builder.append("$$\n").append((CharSequence)definition).append("$$");
            });
            return null;
        }

        @Override
        protected Void visitCreateBranch(CreateBranch node, Integer context) {
            this.builder.append("CREATE ");
            if (node.getSaveMode() == SaveMode.REPLACE) {
                this.builder.append("OR REPLACE ");
            }
            this.builder.append("BRANCH ");
            if (node.getSaveMode() == SaveMode.IGNORE) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getBranchName()));
            this.builder.append(Formatter.formatPropertiesMultiLine(node.getProperties()));
            this.builder.append(" IN TABLE ");
            this.builder.append(SqlFormatter.formatName(node.getTableName()));
            if (node.getFromBranch().isPresent()) {
                this.builder.append(" FROM " + SqlFormatter.formatName(node.getFromBranch().get()));
            }
            return null;
        }

        @Override
        protected Void visitDropBranch(DropBranch node, Integer context) {
            this.builder.append("DROP BRANCH ");
            if (node.isExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(SqlFormatter.formatName(node.getBranchName()));
            this.builder.append(" IN TABLE ");
            this.builder.append(SqlFormatter.formatName(node.getTableName()));
            return null;
        }

        @Override
        protected Void visitFastForwardBranch(FastForwardBranch node, Integer context) {
            this.builder.append("ALTER BRANCH ");
            this.builder.append(SqlFormatter.formatName(node.getSourceBranchName()));
            this.builder.append(" IN TABLE ");
            this.builder.append(SqlFormatter.formatName(node.geTableName()));
            this.builder.append(" FAST FORWARD TO ");
            this.builder.append(SqlFormatter.formatName(node.getTargetBranchName()));
            return null;
        }

        @Override
        protected Void visitShowBranches(ShowBranches node, Integer context) {
            this.builder.append("SHOW BRANCHES FROM TABLE ").append(SqlFormatter.formatName(node.getTableName()));
            return null;
        }

        @Override
        protected Void visitSessionProperty(SessionProperty node, Integer indent) {
            this.append(indent, SqlFormatter.formatName(node.getName())).append(" = ").append(SqlFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        protected Void visitParameterDeclaration(ParameterDeclaration node, Integer indent) {
            node.getName().ifPresent(value -> this.builder.append(SqlFormatter.formatName(value)).append(" "));
            this.builder.append(SqlFormatter.formatExpression(node.getType()));
            return null;
        }

        @Override
        protected Void visitLanguageCharacteristic(LanguageCharacteristic node, Integer indent) {
            this.append(indent, "LANGUAGE ").append(SqlFormatter.formatName(node.getLanguage()));
            return null;
        }

        @Override
        protected Void visitDeterministicCharacteristic(DeterministicCharacteristic node, Integer indent) {
            this.append(indent, (node.isDeterministic() ? "" : "NOT ") + "DETERMINISTIC");
            return null;
        }

        @Override
        protected Void visitNullInputCharacteristic(NullInputCharacteristic node, Integer indent) {
            if (node.isCalledOnNull()) {
                this.append(indent, "CALLED ON NULL INPUT");
            } else {
                this.append(indent, "RETURNS NULL ON NULL INPUT");
            }
            return null;
        }

        @Override
        protected Void visitSecurityCharacteristic(SecurityCharacteristic node, Integer indent) {
            this.append(indent, "SECURITY ").append(node.getSecurity().name());
            return null;
        }

        @Override
        protected Void visitCommentCharacteristic(CommentCharacteristic node, Integer indent) {
            this.append(indent, "COMMENT ").append(ExpressionFormatter.formatStringLiteral(node.getComment()));
            return null;
        }

        @Override
        protected Void visitPropertiesCharacteristic(PropertiesCharacteristic node, Integer indent) {
            this.append(indent, "WITH (\n");
            Iterator<Property> iterator = node.getProperties().iterator();
            while (iterator.hasNext()) {
                Property property = iterator.next();
                this.append(indent + 1, Formatter.formatProperty(property));
                this.builder.append(iterator.hasNext() ? ",\n" : "\n");
            }
            this.append(indent, ")");
            return null;
        }

        @Override
        protected Void visitReturnClause(ReturnsClause node, Integer indent) {
            this.append(indent, "RETURNS ").append(SqlFormatter.formatExpression(node.getReturnType()));
            return null;
        }

        @Override
        protected Void visitReturnStatement(ReturnStatement node, Integer indent) {
            this.append(indent, "RETURN ").append(SqlFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        protected Void visitCompoundStatement(CompoundStatement node, Integer indent) {
            this.append(indent, "BEGIN\n");
            for (VariableDeclaration variableDeclaration : node.getVariableDeclarations()) {
                this.process(variableDeclaration, indent + 1);
                this.builder.append(";\n");
            }
            for (ControlStatement statement : node.getStatements()) {
                this.process(statement, indent + 1);
                this.builder.append(";\n");
            }
            this.append(indent, "END");
            return null;
        }

        @Override
        protected Void visitVariableDeclaration(VariableDeclaration node, Integer indent) {
            this.append(indent, "DECLARE ").append(node.getNames().stream().map(SqlFormatter::formatName).collect(Collectors.joining(", "))).append(" ").append(SqlFormatter.formatExpression(node.getType()));
            if (node.getDefaultValue().isPresent()) {
                this.builder.append(" DEFAULT ").append(SqlFormatter.formatExpression(node.getDefaultValue().get()));
            }
            return null;
        }

        @Override
        protected Void visitAssignmentStatement(AssignmentStatement node, Integer indent) {
            this.append(indent, "SET ");
            this.builder.append(SqlFormatter.formatName(node.getTarget())).append(" = ").append(SqlFormatter.formatExpression(node.getValue()));
            return null;
        }

        @Override
        protected Void visitCaseStatement(CaseStatement node, Integer indent) {
            this.append(indent, "CASE");
            if (node.getExpression().isPresent()) {
                this.builder.append(" ").append(SqlFormatter.formatExpression(node.getExpression().get()));
            }
            this.builder.append("\n");
            for (CaseStatementWhenClause whenClause : node.getWhenClauses()) {
                this.process(whenClause, indent + 1);
            }
            if (node.getElseClause().isPresent()) {
                this.process(node.getElseClause().get(), indent + 1);
            }
            this.append(indent, "END CASE");
            return null;
        }

        @Override
        protected Void visitCaseStatementWhenClause(CaseStatementWhenClause node, Integer indent) {
            this.append(indent, "WHEN ").append(SqlFormatter.formatExpression(node.getExpression())).append(" THEN\n");
            for (ControlStatement statement : node.getStatements()) {
                this.process(statement, indent + 1);
                this.builder.append(";\n");
            }
            return null;
        }

        @Override
        protected Void visitIfStatement(IfStatement node, Integer indent) {
            this.append(indent, "IF ").append(SqlFormatter.formatExpression(node.getExpression())).append(" THEN\n");
            for (ControlStatement statement : node.getStatements()) {
                this.process(statement, indent + 1);
                this.builder.append(";\n");
            }
            for (ElseIfClause elseIfClause : node.getElseIfClauses()) {
                this.process(elseIfClause, indent);
            }
            if (node.getElseClause().isPresent()) {
                this.process(node.getElseClause().get(), indent);
            }
            this.append(indent, "END IF");
            return null;
        }

        @Override
        protected Void visitElseIfClause(ElseIfClause node, Integer indent) {
            this.append(indent, "ELSEIF ").append(SqlFormatter.formatExpression(node.getExpression())).append(" THEN\n");
            for (ControlStatement statement : node.getStatements()) {
                this.process(statement, indent + 1);
                this.builder.append(";\n");
            }
            return null;
        }

        @Override
        protected Void visitElseClause(ElseClause node, Integer indent) {
            this.append(indent, "ELSE\n");
            for (ControlStatement statement : node.getStatements()) {
                this.process(statement, indent + 1);
                this.builder.append(";\n");
            }
            return null;
        }

        @Override
        protected Void visitIterateStatement(IterateStatement node, Integer indent) {
            this.append(indent, "ITERATE ").append(SqlFormatter.formatName(node.getLabel()));
            return null;
        }

        @Override
        protected Void visitLeaveStatement(LeaveStatement node, Integer indent) {
            this.append(indent, "LEAVE ").append(SqlFormatter.formatName(node.getLabel()));
            return null;
        }

        @Override
        protected Void visitLoopStatement(LoopStatement node, Integer indent) {
            this.builder.append(Formatter.indentString(indent));
            this.appendBeginLabel(node.getLabel());
            this.builder.append("LOOP\n");
            for (ControlStatement statement : node.getStatements()) {
                this.process(statement, indent + 1);
                this.builder.append(";\n");
            }
            this.append(indent, "END LOOP");
            return null;
        }

        @Override
        protected Void visitWhileStatement(WhileStatement node, Integer indent) {
            this.builder.append(Formatter.indentString(indent));
            this.appendBeginLabel(node.getLabel());
            this.builder.append("WHILE ").append(SqlFormatter.formatExpression(node.getExpression())).append(" DO\n");
            for (ControlStatement statement : node.getStatements()) {
                this.process(statement, indent + 1);
                this.builder.append(";\n");
            }
            this.append(indent, "END WHILE");
            return null;
        }

        @Override
        protected Void visitRepeatStatement(RepeatStatement node, Integer indent) {
            this.builder.append(Formatter.indentString(indent));
            this.appendBeginLabel(node.getLabel());
            this.builder.append("REPEAT\n");
            for (ControlStatement statement : node.getStatements()) {
                this.process(statement, indent + 1);
                this.builder.append(";\n");
            }
            this.append(indent, "UNTIL ").append(SqlFormatter.formatExpression(node.getCondition())).append("\n");
            this.append(indent, "END REPEAT");
            return null;
        }

        private void appendBeginLabel(Optional<Identifier> label) {
            label.ifPresent(value -> this.builder.append(SqlFormatter.formatName(value)).append(": "));
        }

        private void processRelation(Relation relation, Integer indent) {
            if (relation instanceof Table) {
                Table table = (Table)relation;
                this.builder.append("TABLE ").append(SqlFormatter.formatName(table.getName())).append('\n');
            } else {
                this.process(relation, indent);
            }
        }

        private void processParameters(List<ParameterDeclaration> parameters, Integer indent) {
            this.builder.append("(");
            Iterator<ParameterDeclaration> iterator = parameters.iterator();
            while (iterator.hasNext()) {
                this.process(iterator.next(), indent);
                if (!iterator.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
        }

        private SqlBuilder append(int indent, String value) {
            return this.builder.append(Formatter.indentString(indent)).append(value);
        }

        private static String indentString(int indent) {
            return SqlFormatter.INDENT.repeat(indent);
        }

        private void formatDefinitionList(List<String> elements, int indent) {
            if (elements.size() == 1) {
                this.builder.append(" ").append((CharSequence)Iterables.getOnlyElement(elements)).append("\n");
            } else {
                this.builder.append("\n");
                for (int i = 0; i < elements.size() - 1; ++i) {
                    this.append(indent, elements.get(i)).append(",\n");
                }
                this.append(indent, elements.getLast()).append("\n");
            }
        }

        private static class SqlBuilder {
            private final StringBuilder builder;

            public SqlBuilder(StringBuilder builder) {
                this.builder = Objects.requireNonNull(builder, "builder is null");
            }

            @CanIgnoreReturnValue
            public SqlBuilder append(CharSequence value) {
                this.builder.append(value);
                return this;
            }

            @CanIgnoreReturnValue
            public SqlBuilder append(char c) {
                this.builder.append(c);
                return this;
            }
        }
    }
}

