/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.JsonTableSpecificPlan;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;

public class PlanLeaf
extends JsonTableSpecificPlan {
    private final Identifier name;

    public PlanLeaf(NodeLocation location, Identifier name) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPlanLeaf(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.name, ((PlanLeaf)o).name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!PlanLeaf.sameClass(this, other)) {
            return false;
        }
        return this.name.equals(((PlanLeaf)other).name);
    }
}

