/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.JsonTablePlan;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;

public class JsonTableDefaultPlan
extends JsonTablePlan {
    private final JsonTablePlan.ParentChildPlanType parentChild;
    private final JsonTablePlan.SiblingsPlanType siblings;

    public JsonTableDefaultPlan(NodeLocation location, JsonTablePlan.ParentChildPlanType parentChildPlanType, JsonTablePlan.SiblingsPlanType siblingsPlanType) {
        super(location);
        this.parentChild = Objects.requireNonNull(parentChildPlanType, "parentChild is null");
        this.siblings = Objects.requireNonNull(siblingsPlanType, "siblings is null");
    }

    public JsonTablePlan.ParentChildPlanType getParentChild() {
        return this.parentChild;
    }

    public JsonTablePlan.SiblingsPlanType getSiblings() {
        return this.siblings;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitJsonTableDefaultPlan(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("parentChild", (Object)this.parentChild).add("siblings", (Object)this.siblings).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonTableDefaultPlan that = (JsonTableDefaultPlan)o;
        return this.parentChild == that.parentChild && this.siblings == that.siblings;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.parentChild, this.siblings});
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!JsonTableDefaultPlan.sameClass(this, other)) {
            return false;
        }
        JsonTableDefaultPlan otherPlan = (JsonTableDefaultPlan)other;
        return this.parentChild == otherPlan.parentChild && this.siblings == otherPlan.siblings;
    }
}

