/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.SessionProperty;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.With;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Query
extends Statement {
    private final List<SessionProperty> sessionProperties;
    private final List<FunctionSpecification> functions;
    private final Optional<With> with;
    private final QueryBody queryBody;
    private final Optional<OrderBy> orderBy;
    private final Optional<Offset> offset;
    private final Optional<Node> limit;

    @Deprecated
    public Query(List<SessionProperty> sessionProperties, List<FunctionSpecification> functions, Optional<With> with, QueryBody queryBody, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        this(Optional.empty(), sessionProperties, functions, with, queryBody, orderBy, offset, limit);
    }

    public Query(NodeLocation location, List<SessionProperty> sessionProperties, List<FunctionSpecification> functions, Optional<With> with, QueryBody queryBody, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        this(Optional.of(location), sessionProperties, functions, with, queryBody, orderBy, offset, limit);
    }

    private Query(Optional<NodeLocation> location, List<SessionProperty> sessionProperties, List<FunctionSpecification> functions, Optional<With> with, QueryBody queryBody, Optional<OrderBy> orderBy, Optional<Offset> offset, Optional<Node> limit) {
        super(location);
        Objects.requireNonNull(sessionProperties, "sessionProperties is null");
        Objects.requireNonNull(functions, "functions is null");
        Objects.requireNonNull(with, "with is null");
        Objects.requireNonNull(queryBody, "queryBody is null");
        Objects.requireNonNull(orderBy, "orderBy is null");
        Objects.requireNonNull(offset, "offset is null");
        Objects.requireNonNull(limit, "limit is null");
        Preconditions.checkArgument((!limit.isPresent() || limit.get() instanceof FetchFirst || limit.get() instanceof Limit ? 1 : 0) != 0, (Object)"limit must be optional of either FetchFirst or Limit type");
        this.sessionProperties = ImmutableList.copyOf(sessionProperties);
        this.functions = ImmutableList.copyOf(functions);
        this.with = with;
        this.queryBody = queryBody;
        this.orderBy = orderBy;
        this.offset = offset;
        this.limit = limit;
    }

    public List<SessionProperty> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<FunctionSpecification> getFunctions() {
        return this.functions;
    }

    public Optional<With> getWith() {
        return this.with;
    }

    public QueryBody getQueryBody() {
        return this.queryBody;
    }

    public Optional<OrderBy> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Offset> getOffset() {
        return this.offset;
    }

    public Optional<Node> getLimit() {
        return this.limit;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuery(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.addAll(this.functions);
        nodes.addAll(this.sessionProperties);
        this.with.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        nodes.add((Object)this.queryBody);
        this.orderBy.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.offset.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.limit.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        return nodes.build();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sessionProperties", this.sessionProperties.isEmpty() ? null : this.sessionProperties).add("functions", this.functions.isEmpty() ? null : this.functions).add("with", this.with.orElse(null)).add("queryBody", (Object)this.queryBody).add("orderBy", this.orderBy).add("offset", this.offset.orElse(null)).add("limit", this.limit.orElse(null)).omitNullValues().toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Query o = (Query)obj;
        return Objects.equals(this.sessionProperties, o.sessionProperties) && Objects.equals(this.functions, o.functions) && Objects.equals(this.with, o.with) && Objects.equals(this.queryBody, o.queryBody) && Objects.equals(this.orderBy, o.orderBy) && Objects.equals(this.offset, o.offset) && Objects.equals(this.limit, o.limit);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.sessionProperties, this.functions, this.with, this.queryBody, this.orderBy, this.offset, this.limit);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return Query.sameClass(this, other);
    }
}

