/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;

public class BetweenPredicate
extends Expression {
    private final Expression value;
    private final Expression min;
    private final Expression max;

    public BetweenPredicate(NodeLocation location, Expression value, Expression min, Expression max) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(min, "min is null");
        Objects.requireNonNull(max, "max is null");
        this.value = value;
        this.min = min;
        this.max = max;
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getMin() {
        return this.min;
    }

    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.value, (Object)this.min, (Object)this.max);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.min, this.max);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return BetweenPredicate.sameClass(this, other);
    }
}

