/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.RoutineCharacteristic;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class PropertiesCharacteristic
extends RoutineCharacteristic {
    private final List<Property> properties;

    public PropertiesCharacteristic(NodeLocation location, List<Property> properties) {
        super(location);
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        Preconditions.checkArgument((!properties.isEmpty() ? 1 : 0) != 0, (Object)"properties is empty");
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPropertiesCharacteristic(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PropertiesCharacteristic)) return false;
        PropertiesCharacteristic other = (PropertiesCharacteristic)obj;
        if (!this.properties.equals(other.properties)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.properties.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("properties", this.properties).toString();
    }
}

