/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ElseIfClause
extends Node {
    private final Expression expression;
    private final List<ControlStatement> statements;

    @Deprecated
    public ElseIfClause(Expression expression, List<ControlStatement> statements) {
        super(Optional.empty());
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.statements = Objects.requireNonNull(statements, "statements is null");
    }

    public ElseIfClause(NodeLocation location, Expression expression, List<ControlStatement> statements) {
        super(location);
        this.expression = Objects.requireNonNull(expression, "expression is null");
        this.statements = Objects.requireNonNull(statements, "statements is null");
    }

    public Expression getExpression() {
        return this.expression;
    }

    public List<ControlStatement> getStatements() {
        return this.statements;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitElseIfClause(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.builder().add((Object)this.expression).addAll(this.statements).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ElseIfClause)) return false;
        ElseIfClause other = (ElseIfClause)obj;
        if (!Objects.equals(this.expression, other.expression)) return false;
        if (!Objects.equals(this.statements, other.statements)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.expression, this.statements);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("expression", (Object)this.expression).add("statements", this.statements).toString();
    }
}

