/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;

public class SessionProperty
extends Node {
    private final QualifiedName name;
    private final Expression value;

    public SessionProperty(NodeLocation location, QualifiedName name, Expression value) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.value = Objects.requireNonNull(value, "value is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of((Object)this.value);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSessionProperty(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SessionProperty)) return false;
        SessionProperty other = (SessionProperty)obj;
        if (!Objects.equals(this.name, other.name)) return false;
        if (!Objects.equals(this.value, other.value)) return false;
        return true;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", (Object)this.value).toString();
    }
}

