/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.RoutineCharacteristic;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class NullInputCharacteristic
extends RoutineCharacteristic {
    private final boolean calledOnNull;

    @Deprecated
    public static NullInputCharacteristic returnsNullOnNullInput() {
        return new NullInputCharacteristic(Optional.empty(), false);
    }

    public static NullInputCharacteristic returnsNullOnNullInput(NodeLocation location) {
        return new NullInputCharacteristic(location, false);
    }

    @Deprecated
    public static NullInputCharacteristic calledOnNullInput() {
        return new NullInputCharacteristic(Optional.empty(), true);
    }

    public static NullInputCharacteristic calledOnNullInput(NodeLocation location) {
        return new NullInputCharacteristic(location, true);
    }

    private NullInputCharacteristic(Optional<NodeLocation> location, boolean calledOnNull) {
        super(location);
        this.calledOnNull = calledOnNull;
    }

    private NullInputCharacteristic(NodeLocation location, boolean calledOnNull) {
        super(location);
        this.calledOnNull = calledOnNull;
    }

    public boolean isCalledOnNull() {
        return this.calledOnNull;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNullInputCharacteristic(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NullInputCharacteristic)) return false;
        NullInputCharacteristic other = (NullInputCharacteristic)obj;
        if (this.calledOnNull != other.calledOnNull) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.calledOnNull);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("calledOnNull", this.calledOnNull).toString();
    }
}

