/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.errorprone.annotations.ThreadSafe;
import io.trino.grammar.sql.SqlBaseLexer;
import io.trino.grammar.sql.SqlBaseParser;
import io.trino.sql.parser.AntlrATNCacheFields;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;

@ThreadSafe
public final class RefreshableSqlBaseParserInitializer
implements BiConsumer<SqlBaseLexer, SqlBaseParser> {
    private final AtomicReference<SqlBaseParserAndLexerATNCaches> caches = new AtomicReference();

    public RefreshableSqlBaseParserInitializer() {
        this.refresh();
    }

    public void refresh() {
        this.caches.set(new SqlBaseParserAndLexerATNCaches());
    }

    @Override
    public void accept(SqlBaseLexer lexer, SqlBaseParser parser) {
        SqlBaseParserAndLexerATNCaches caches = this.caches.get();
        caches.lexer.configureLexer((Lexer)lexer);
        caches.parser.configureParser((Parser)parser);
    }

    private static final class SqlBaseParserAndLexerATNCaches {
        public final AntlrATNCacheFields lexer = new AntlrATNCacheFields(SqlBaseLexer._ATN);
        public final AntlrATNCacheFields parser = new AntlrATNCacheFields(SqlBaseParser._ATN);

        private SqlBaseParserAndLexerATNCaches() {
        }
    }
}

