/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.RowPattern;
import java.util.List;
import java.util.Objects;

public class PatternVariable
extends RowPattern {
    private final Identifier name;

    public PatternVariable(NodeLocation location, Identifier name) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public Identifier getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPatternVariable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.name);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PatternVariable o = (PatternVariable)obj;
        return Objects.equals(this.name, o.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return PatternVariable.sameClass(this, other);
    }
}

