/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class Identifier
extends Expression {
    private static final CharMatcher FIRST_CHAR_DISALLOWED_MATCHER = CharMatcher.inRange((char)'0', (char)'9').precomputed();
    private static final CharMatcher ALLOWED_CHARS_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_')).or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();
    private final String value;
    private final boolean delimited;

    public Identifier(NodeLocation location, String value, boolean delimited) {
        this(Optional.of(location), value, delimited);
    }

    public Identifier(String value, boolean delimited) {
        this(Optional.empty(), value, delimited);
    }

    public Identifier(String value) {
        this(Optional.empty(), value, !Identifier.isValidIdentifier(value));
    }

    private Identifier(Optional<NodeLocation> location, String value, boolean delimited) {
        super(location);
        this.value = Objects.requireNonNull(value, "value is null");
        this.delimited = delimited;
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"value is empty");
        Preconditions.checkArgument((delimited || Identifier.isValidIdentifier(value) ? 1 : 0) != 0, (String)"value contains illegal characters: %s", (Object)value);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDelimited() {
        return this.delimited;
    }

    public String getCanonicalValue() {
        if (this.isDelimited()) {
            return this.value;
        }
        return this.value.toUpperCase(Locale.ENGLISH);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIdentifier(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Identifier.sameClass(this, other)) {
            return false;
        }
        Identifier that = (Identifier)other;
        return Objects.equals(this.value, that.value) && this.delimited == that.delimited;
    }

    private static boolean isValidIdentifier(String value) {
        Verify.verify((!Strings.isNullOrEmpty((String)value) ? 1 : 0) != 0, (String)"Identifier cannot be empty or null", (Object[])new Object[0]);
        if (FIRST_CHAR_DISALLOWED_MATCHER.matches(value.charAt(0))) {
            return false;
        }
        return ALLOWED_CHARS_MATCHER.matchesAllOf((CharSequence)value);
    }
}

