/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.ParameterDeclaration;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.ReturnsClause;
import io.trino.sql.tree.RoutineCharacteristic;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class FunctionSpecification
extends Node {
    private final QualifiedName name;
    private final List<ParameterDeclaration> parameters;
    private final ReturnsClause returnsClause;
    private final List<RoutineCharacteristic> routineCharacteristics;
    private final ControlStatement statement;

    public FunctionSpecification(NodeLocation location, QualifiedName name, List<ParameterDeclaration> parameters, ReturnsClause returnsClause, List<RoutineCharacteristic> routineCharacteristics, ControlStatement statement) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        this.returnsClause = Objects.requireNonNull(returnsClause, "returnClause is null");
        this.routineCharacteristics = ImmutableList.copyOf((Collection)Objects.requireNonNull(routineCharacteristics, "routineCharacteristics is null"));
        this.statement = Objects.requireNonNull(statement, "statement is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public List<ParameterDeclaration> getParameters() {
        return this.parameters;
    }

    public ReturnsClause getReturnsClause() {
        return this.returnsClause;
    }

    public List<RoutineCharacteristic> getRoutineCharacteristics() {
        return this.routineCharacteristics;
    }

    public ControlStatement getStatement() {
        return this.statement;
    }

    public List<Node> getChildren() {
        return ImmutableList.builder().addAll(this.parameters).add((Object)this.returnsClause).addAll(this.routineCharacteristics).add((Object)this.statement).build();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionSpecification(this, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FunctionSpecification)) return false;
        FunctionSpecification other = (FunctionSpecification)obj;
        if (!Objects.equals(this.name, other.name)) return false;
        if (!Objects.equals(this.parameters, other.parameters)) return false;
        if (!Objects.equals(this.returnsClause, other.returnsClause)) return false;
        if (!Objects.equals(this.routineCharacteristics, other.routineCharacteristics)) return false;
        if (!Objects.equals(this.statement, other.statement)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.parameters, this.returnsClause, this.routineCharacteristics, this.statement);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("parameters", this.parameters).add("returnsClause", (Object)this.returnsClause).add("routineCharacteristics", this.routineCharacteristics).add("statement", (Object)this.statement).toString();
    }
}

