/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CreateMaterializedView
extends Statement {
    private final QualifiedName name;
    private final Query query;
    private final boolean replace;
    private final boolean notExists;
    private final Optional<IntervalLiteral> gracePeriod;
    private final List<Property> properties;
    private final Optional<String> comment;

    public CreateMaterializedView(NodeLocation location, QualifiedName name, Query query, boolean replace, boolean notExists, Optional<IntervalLiteral> gracePeriod, List<Property> properties, Optional<String> comment) {
        super(location);
        this.name = Objects.requireNonNull(name, "name is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.replace = replace;
        this.notExists = notExists;
        this.gracePeriod = Objects.requireNonNull(gracePeriod, "gracePeriod is null");
        this.properties = ImmutableList.copyOf((Collection)Objects.requireNonNull(properties, "properties is null"));
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public boolean isNotExists() {
        return this.notExists;
    }

    public Optional<IntervalLiteral> getGracePeriod() {
        return this.gracePeriod;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateMaterializedView(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder children = ImmutableList.builder();
        children.add((Object)this.query);
        this.gracePeriod.ifPresent(arg_0 -> ((ImmutableList.Builder)children).add(arg_0));
        return children.build();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.replace, this.notExists, this.gracePeriod, this.properties, this.comment);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateMaterializedView o = (CreateMaterializedView)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && this.replace == o.replace && this.notExists == o.notExists && Objects.equals(this.gracePeriod, o.gracePeriod) && Objects.equals(this.properties, o.properties) && Objects.equals(this.comment, o.comment);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("replace", this.replace).add("notExists", this.notExists).add("gracePeriod", this.gracePeriod).add("properties", this.properties).add("comment", this.comment).toString();
    }
}

