/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TruncateTable
extends Statement {
    private final QualifiedName tableName;

    public TruncateTable(NodeLocation location, QualifiedName tableName) {
        super(Optional.of(location));
        this.tableName = tableName;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTruncateTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TruncateTable o = (TruncateTable)obj;
        return Objects.equals(this.tableName, o.tableName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).toString();
    }
}

