/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ShowFunctions
extends Statement {
    private final Optional<QualifiedName> schema;
    private final Optional<String> likePattern;
    private final Optional<String> escape;

    public ShowFunctions(NodeLocation location, Optional<QualifiedName> schema, Optional<String> likePattern, Optional<String> escape) {
        super(Optional.of(location));
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.likePattern = Objects.requireNonNull(likePattern, "likePattern is null");
        this.escape = Objects.requireNonNull(escape, "escape is null");
    }

    public Optional<QualifiedName> getSchema() {
        return this.schema;
    }

    public Optional<String> getLikePattern() {
        return this.likePattern;
    }

    public Optional<String> getEscape() {
        return this.escape;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowFunctions(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.schema, this.likePattern, this.escape);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ShowFunctions)) return false;
        ShowFunctions other = (ShowFunctions)obj;
        if (!Objects.equals(this.schema, other.schema)) return false;
        if (!Objects.equals(this.likePattern, other.likePattern)) return false;
        if (!Objects.equals(this.escape, other.escape)) return false;
        return true;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schema", this.schema.orElse(null)).add("likePattern", this.likePattern.orElse(null)).add("escape", this.escape.orElse(null)).omitNullValues().toString();
    }
}

