/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowRoleGrants
extends Statement {
    private final Optional<Identifier> catalog;

    public ShowRoleGrants(NodeLocation location, Optional<Identifier> catalog) {
        super(Optional.of(location));
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
    }

    public Optional<Identifier> getCatalog() {
        return this.catalog;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowRoleGrants(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.catalog);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowRoleGrants o = (ShowRoleGrants)obj;
        return Objects.equals(this.catalog, o.catalog);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("catalog", this.catalog).toString();
    }
}

