/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.RoutineCharacteristic;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class LanguageCharacteristic
extends RoutineCharacteristic {
    private final Identifier language;

    public LanguageCharacteristic(NodeLocation location, Identifier language) {
        super(Optional.of(location));
        this.language = Objects.requireNonNull(language, "comment is null");
    }

    public Identifier getLanguage() {
        return this.language;
    }

    @Override
    protected <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLanguageCharacteristic(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LanguageCharacteristic)) return false;
        LanguageCharacteristic other = (LanguageCharacteristic)obj;
        if (!this.language.equals(other.language)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.language.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("language", (Object)this.language).toString();
    }
}

