/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PatternQuantifier;
import io.trino.sql.tree.RowPattern;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QuantifiedPattern
extends RowPattern {
    private final RowPattern pattern;
    private final PatternQuantifier patternQuantifier;

    public QuantifiedPattern(NodeLocation location, RowPattern pattern, PatternQuantifier patternQuantifier) {
        super(Optional.of(location));
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.patternQuantifier = Objects.requireNonNull(patternQuantifier, "patternQuantifier is null");
    }

    public RowPattern getPattern() {
        return this.pattern;
    }

    public PatternQuantifier getPatternQuantifier() {
        return this.patternQuantifier;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuantifiedPattern(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.pattern, (Object)this.patternQuantifier);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QuantifiedPattern o = (QuantifiedPattern)obj;
        return Objects.equals(this.pattern, o.pattern) && Objects.equals(this.patternQuantifier, o.patternQuantifier);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern, this.patternQuantifier);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pattern", (Object)this.pattern).add("patternQuantifier", (Object)this.patternQuantifier).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        return QuantifiedPattern.sameClass(this, other);
    }
}

