/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ElseClause
extends Node {
    private final List<ControlStatement> statements;

    public ElseClause(NodeLocation location, List<ControlStatement> statements) {
        super(Optional.of(location));
        this.statements = Objects.requireNonNull(statements, "statements is null");
    }

    public List<ControlStatement> getStatements() {
        return this.statements;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitElseClause(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return this.statements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ElseClause)) return false;
        ElseClause other = (ElseClause)obj;
        if (!Objects.equals(this.statements, other.statements)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.statements);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("statements", this.statements).toString();
    }
}

