/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class CreateFunction
extends Statement {
    private final FunctionSpecification specification;
    private final boolean replace;

    public CreateFunction(NodeLocation location, FunctionSpecification specification, boolean replace) {
        super(Optional.of(location));
        this.specification = Objects.requireNonNull(specification, "specification is null");
        this.replace = replace;
    }

    public FunctionSpecification getSpecification() {
        return this.specification;
    }

    public boolean isReplace() {
        return this.replace;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateFunction(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.specification);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CreateFunction)) return false;
        CreateFunction other = (CreateFunction)obj;
        if (!Objects.equals(this.specification, other.specification)) return false;
        if (this.replace != other.replace) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.specification, this.replace);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("specification", (Object)this.specification).add("replace", this.replace).toString();
    }
}

