/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ReturnsClause
extends Node {
    private final DataType returnType;

    public ReturnsClause(NodeLocation location, DataType returnType) {
        super(Optional.of(location));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
    }

    public DataType getReturnType() {
        return this.returnType;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitReturnClause(this, context);
    }

    @Override
    public List<? extends Node> getChildren() {
        return ImmutableList.of();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ReturnsClause)) return false;
        ReturnsClause other = (ReturnsClause)obj;
        if (!this.returnType.equals(other.returnType)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.returnType.hashCode();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("returnType", (Object)this.returnType).toString();
    }
}

