/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropColumn
extends Statement {
    private final QualifiedName table;
    private final QualifiedName field;
    private final boolean tableExists;
    private final boolean columnExists;

    public DropColumn(QualifiedName table, QualifiedName field, boolean tableExists, boolean columnExists) {
        this(Optional.empty(), table, field, tableExists, columnExists);
    }

    public DropColumn(NodeLocation location, QualifiedName table, QualifiedName field, boolean tableExists, boolean columnExists) {
        this(Optional.of(location), table, field, tableExists, columnExists);
    }

    private DropColumn(Optional<NodeLocation> location, QualifiedName table, QualifiedName field, boolean tableExists, boolean columnExists) {
        super(location);
        this.table = Objects.requireNonNull(table, "table is null");
        this.field = Objects.requireNonNull(field, "field is null");
        this.tableExists = tableExists;
        this.columnExists = columnExists;
    }

    public QualifiedName getTable() {
        return this.table;
    }

    public QualifiedName getField() {
        return this.field;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    public boolean isColumnExists() {
        return this.columnExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropColumn(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropColumn that = (DropColumn)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.field, that.field);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.field);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("field", (Object)this.field).toString();
    }
}

