/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ShowCreate
extends Statement {
    private final Type type;
    private final QualifiedName name;

    public ShowCreate(Type type, QualifiedName name) {
        this(Optional.empty(), type, name);
    }

    public ShowCreate(NodeLocation location, Type type, QualifiedName name) {
        this(Optional.of(location), type, name);
    }

    private ShowCreate(Optional<NodeLocation> location, Type type, QualifiedName name) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.name = Objects.requireNonNull(name, "name is null");
    }

    public QualifiedName getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitShowCreate(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowCreate o = (ShowCreate)obj;
        return Objects.equals(this.name, o.name) && this.type == o.type;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("name", (Object)this.name).toString();
    }

    public static enum Type {
        TABLE,
        VIEW,
        SCHEMA,
        MATERIALIZED_VIEW,
        FUNCTION;

    }
}

