/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.trino.grammar.sql.SqlBaseBaseVisitor;
import io.trino.grammar.sql.SqlBaseParser;
import io.trino.sql.parser.ParsingException;
import io.trino.sql.tree.AddColumn;
import io.trino.sql.tree.AliasedRelation;
import io.trino.sql.tree.AllColumns;
import io.trino.sql.tree.AllRows;
import io.trino.sql.tree.Analyze;
import io.trino.sql.tree.AnchorPattern;
import io.trino.sql.tree.ArithmeticBinaryExpression;
import io.trino.sql.tree.ArithmeticUnaryExpression;
import io.trino.sql.tree.Array;
import io.trino.sql.tree.AssignmentStatement;
import io.trino.sql.tree.AtTimeZone;
import io.trino.sql.tree.BetweenPredicate;
import io.trino.sql.tree.BinaryLiteral;
import io.trino.sql.tree.BindExpression;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Call;
import io.trino.sql.tree.CallArgument;
import io.trino.sql.tree.CaseStatement;
import io.trino.sql.tree.CaseStatementWhenClause;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.CharLiteral;
import io.trino.sql.tree.CoalesceExpression;
import io.trino.sql.tree.ColumnDefinition;
import io.trino.sql.tree.Comment;
import io.trino.sql.tree.CommentCharacteristic;
import io.trino.sql.tree.Commit;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.CompoundStatement;
import io.trino.sql.tree.ControlStatement;
import io.trino.sql.tree.CreateCatalog;
import io.trino.sql.tree.CreateFunction;
import io.trino.sql.tree.CreateMaterializedView;
import io.trino.sql.tree.CreateRole;
import io.trino.sql.tree.CreateSchema;
import io.trino.sql.tree.CreateTable;
import io.trino.sql.tree.CreateTableAsSelect;
import io.trino.sql.tree.CreateView;
import io.trino.sql.tree.CurrentCatalog;
import io.trino.sql.tree.CurrentPath;
import io.trino.sql.tree.CurrentSchema;
import io.trino.sql.tree.CurrentTime;
import io.trino.sql.tree.CurrentUser;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.DataTypeParameter;
import io.trino.sql.tree.DateTimeDataType;
import io.trino.sql.tree.Deallocate;
import io.trino.sql.tree.DecimalLiteral;
import io.trino.sql.tree.Delete;
import io.trino.sql.tree.Deny;
import io.trino.sql.tree.DereferenceExpression;
import io.trino.sql.tree.DescribeInput;
import io.trino.sql.tree.DescribeOutput;
import io.trino.sql.tree.Descriptor;
import io.trino.sql.tree.DescriptorField;
import io.trino.sql.tree.DeterministicCharacteristic;
import io.trino.sql.tree.DoubleLiteral;
import io.trino.sql.tree.DropCatalog;
import io.trino.sql.tree.DropColumn;
import io.trino.sql.tree.DropFunction;
import io.trino.sql.tree.DropMaterializedView;
import io.trino.sql.tree.DropRole;
import io.trino.sql.tree.DropSchema;
import io.trino.sql.tree.DropTable;
import io.trino.sql.tree.DropView;
import io.trino.sql.tree.ElseClause;
import io.trino.sql.tree.ElseIfClause;
import io.trino.sql.tree.EmptyPattern;
import io.trino.sql.tree.EmptyTableTreatment;
import io.trino.sql.tree.Except;
import io.trino.sql.tree.ExcludedPattern;
import io.trino.sql.tree.Execute;
import io.trino.sql.tree.ExecuteImmediate;
import io.trino.sql.tree.ExistsPredicate;
import io.trino.sql.tree.Explain;
import io.trino.sql.tree.ExplainAnalyze;
import io.trino.sql.tree.ExplainFormat;
import io.trino.sql.tree.ExplainOption;
import io.trino.sql.tree.ExplainType;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Extract;
import io.trino.sql.tree.FetchFirst;
import io.trino.sql.tree.Format;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.FunctionCall;
import io.trino.sql.tree.FunctionSpecification;
import io.trino.sql.tree.GenericDataType;
import io.trino.sql.tree.GenericLiteral;
import io.trino.sql.tree.Grant;
import io.trino.sql.tree.GrantOnType;
import io.trino.sql.tree.GrantRoles;
import io.trino.sql.tree.GrantorSpecification;
import io.trino.sql.tree.GroupBy;
import io.trino.sql.tree.GroupingElement;
import io.trino.sql.tree.GroupingOperation;
import io.trino.sql.tree.GroupingSets;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.IfStatement;
import io.trino.sql.tree.InListExpression;
import io.trino.sql.tree.InPredicate;
import io.trino.sql.tree.Insert;
import io.trino.sql.tree.Intersect;
import io.trino.sql.tree.IntervalDayTimeDataType;
import io.trino.sql.tree.IntervalLiteral;
import io.trino.sql.tree.IsNotNullPredicate;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.Isolation;
import io.trino.sql.tree.IterateStatement;
import io.trino.sql.tree.Join;
import io.trino.sql.tree.JoinCriteria;
import io.trino.sql.tree.JoinOn;
import io.trino.sql.tree.JoinUsing;
import io.trino.sql.tree.JsonArray;
import io.trino.sql.tree.JsonArrayElement;
import io.trino.sql.tree.JsonExists;
import io.trino.sql.tree.JsonObject;
import io.trino.sql.tree.JsonObjectMember;
import io.trino.sql.tree.JsonPathInvocation;
import io.trino.sql.tree.JsonPathParameter;
import io.trino.sql.tree.JsonQuery;
import io.trino.sql.tree.JsonTable;
import io.trino.sql.tree.JsonTableColumnDefinition;
import io.trino.sql.tree.JsonTableDefaultPlan;
import io.trino.sql.tree.JsonTablePlan;
import io.trino.sql.tree.JsonTableSpecificPlan;
import io.trino.sql.tree.JsonValue;
import io.trino.sql.tree.LambdaArgumentDeclaration;
import io.trino.sql.tree.LambdaExpression;
import io.trino.sql.tree.LanguageCharacteristic;
import io.trino.sql.tree.Lateral;
import io.trino.sql.tree.LeaveStatement;
import io.trino.sql.tree.LikeClause;
import io.trino.sql.tree.LikePredicate;
import io.trino.sql.tree.Limit;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.LongLiteral;
import io.trino.sql.tree.LoopStatement;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Merge;
import io.trino.sql.tree.MergeCase;
import io.trino.sql.tree.MergeDelete;
import io.trino.sql.tree.MergeInsert;
import io.trino.sql.tree.MergeUpdate;
import io.trino.sql.tree.NaturalJoin;
import io.trino.sql.tree.NestedColumns;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullInputCharacteristic;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.NumericParameter;
import io.trino.sql.tree.Offset;
import io.trino.sql.tree.OneOrMoreQuantifier;
import io.trino.sql.tree.OrderBy;
import io.trino.sql.tree.OrdinalityColumn;
import io.trino.sql.tree.Parameter;
import io.trino.sql.tree.ParameterDeclaration;
import io.trino.sql.tree.PathElement;
import io.trino.sql.tree.PathSpecification;
import io.trino.sql.tree.PatternAlternation;
import io.trino.sql.tree.PatternConcatenation;
import io.trino.sql.tree.PatternPermutation;
import io.trino.sql.tree.PatternQuantifier;
import io.trino.sql.tree.PatternRecognitionRelation;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.PatternVariable;
import io.trino.sql.tree.PlanLeaf;
import io.trino.sql.tree.PlanParentChild;
import io.trino.sql.tree.PlanSiblings;
import io.trino.sql.tree.Prepare;
import io.trino.sql.tree.PrincipalSpecification;
import io.trino.sql.tree.ProcessingMode;
import io.trino.sql.tree.Property;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.QuantifiedComparisonExpression;
import io.trino.sql.tree.QuantifiedPattern;
import io.trino.sql.tree.Query;
import io.trino.sql.tree.QueryBody;
import io.trino.sql.tree.QueryColumn;
import io.trino.sql.tree.QueryPeriod;
import io.trino.sql.tree.QuerySpecification;
import io.trino.sql.tree.RangeQuantifier;
import io.trino.sql.tree.RefreshMaterializedView;
import io.trino.sql.tree.Relation;
import io.trino.sql.tree.RenameColumn;
import io.trino.sql.tree.RenameMaterializedView;
import io.trino.sql.tree.RenameSchema;
import io.trino.sql.tree.RenameTable;
import io.trino.sql.tree.RenameView;
import io.trino.sql.tree.RepeatStatement;
import io.trino.sql.tree.ResetSession;
import io.trino.sql.tree.ResetSessionAuthorization;
import io.trino.sql.tree.ReturnStatement;
import io.trino.sql.tree.ReturnsClause;
import io.trino.sql.tree.Revoke;
import io.trino.sql.tree.RevokeRoles;
import io.trino.sql.tree.Rollback;
import io.trino.sql.tree.RoutineCharacteristic;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.RowDataType;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SampledRelation;
import io.trino.sql.tree.SaveMode;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SecurityCharacteristic;
import io.trino.sql.tree.Select;
import io.trino.sql.tree.SelectItem;
import io.trino.sql.tree.SetColumnType;
import io.trino.sql.tree.SetPath;
import io.trino.sql.tree.SetProperties;
import io.trino.sql.tree.SetRole;
import io.trino.sql.tree.SetSchemaAuthorization;
import io.trino.sql.tree.SetSession;
import io.trino.sql.tree.SetSessionAuthorization;
import io.trino.sql.tree.SetTableAuthorization;
import io.trino.sql.tree.SetTimeZone;
import io.trino.sql.tree.SetViewAuthorization;
import io.trino.sql.tree.ShowCatalogs;
import io.trino.sql.tree.ShowColumns;
import io.trino.sql.tree.ShowCreate;
import io.trino.sql.tree.ShowFunctions;
import io.trino.sql.tree.ShowGrants;
import io.trino.sql.tree.ShowRoleGrants;
import io.trino.sql.tree.ShowRoles;
import io.trino.sql.tree.ShowSchemas;
import io.trino.sql.tree.ShowSession;
import io.trino.sql.tree.ShowStats;
import io.trino.sql.tree.ShowTables;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.SimpleGroupBy;
import io.trino.sql.tree.SingleColumn;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SortItem;
import io.trino.sql.tree.StartTransaction;
import io.trino.sql.tree.Statement;
import io.trino.sql.tree.StringLiteral;
import io.trino.sql.tree.SubqueryExpression;
import io.trino.sql.tree.SubscriptExpression;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.Table;
import io.trino.sql.tree.TableElement;
import io.trino.sql.tree.TableExecute;
import io.trino.sql.tree.TableFunctionArgument;
import io.trino.sql.tree.TableFunctionDescriptorArgument;
import io.trino.sql.tree.TableFunctionInvocation;
import io.trino.sql.tree.TableFunctionTableArgument;
import io.trino.sql.tree.TableSubquery;
import io.trino.sql.tree.TimeLiteral;
import io.trino.sql.tree.TimestampLiteral;
import io.trino.sql.tree.TransactionAccessMode;
import io.trino.sql.tree.TransactionMode;
import io.trino.sql.tree.Trim;
import io.trino.sql.tree.TruncateTable;
import io.trino.sql.tree.TryExpression;
import io.trino.sql.tree.TypeParameter;
import io.trino.sql.tree.Union;
import io.trino.sql.tree.Unnest;
import io.trino.sql.tree.Update;
import io.trino.sql.tree.UpdateAssignment;
import io.trino.sql.tree.Use;
import io.trino.sql.tree.ValueColumn;
import io.trino.sql.tree.Values;
import io.trino.sql.tree.VariableDeclaration;
import io.trino.sql.tree.VariableDefinition;
import io.trino.sql.tree.WhenClause;
import io.trino.sql.tree.WhileStatement;
import io.trino.sql.tree.Window;
import io.trino.sql.tree.WindowDefinition;
import io.trino.sql.tree.WindowFrame;
import io.trino.sql.tree.WindowOperation;
import io.trino.sql.tree.WindowReference;
import io.trino.sql.tree.WindowSpecification;
import io.trino.sql.tree.With;
import io.trino.sql.tree.WithQuery;
import io.trino.sql.tree.ZeroOrMoreQuantifier;
import io.trino.sql.tree.ZeroOrOneQuantifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

class AstBuilder
extends SqlBaseBaseVisitor<Node> {
    private int parameterPosition;
    private final Optional<NodeLocation> baseLocation;

    AstBuilder(Optional<NodeLocation> baseLocation) {
        this.baseLocation = Objects.requireNonNull(baseLocation, "location is null");
    }

    public Node visitSingleStatement(SqlBaseParser.SingleStatementContext context) {
        return (Node)this.visit((ParseTree)context.statement());
    }

    public Node visitStandaloneExpression(SqlBaseParser.StandaloneExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    public Node visitStandaloneType(SqlBaseParser.StandaloneTypeContext context) {
        return (Node)this.visit((ParseTree)context.type());
    }

    public Node visitStandalonePathSpecification(SqlBaseParser.StandalonePathSpecificationContext context) {
        return (Node)this.visit((ParseTree)context.pathSpecification());
    }

    public Node visitStandaloneRowPattern(SqlBaseParser.StandaloneRowPatternContext context) {
        return (Node)this.visit((ParseTree)context.rowPattern());
    }

    public Node visitStandaloneFunctionSpecification(SqlBaseParser.StandaloneFunctionSpecificationContext context) {
        return (Node)this.visit((ParseTree)context.functionSpecification());
    }

    public Node visitUse(SqlBaseParser.UseContext context) {
        return new Use(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.catalog, Identifier.class), (Identifier)this.visit((ParseTree)context.schema));
    }

    public Node visitCreateCatalog(SqlBaseParser.CreateCatalogContext context) {
        Optional<PrincipalSpecification> principal = Optional.empty();
        if (context.AUTHORIZATION() != null) {
            principal = Optional.of(this.getPrincipalSpecification(context.principal()));
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().propertyAssignments().property(), Property.class);
        }
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        return new CreateCatalog(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.catalog), context.EXISTS() != null, (Identifier)this.visit((ParseTree)context.connectorName), (List<Property>)properties, principal, comment);
    }

    public Node visitDropCatalog(SqlBaseParser.DropCatalogContext context) {
        return new DropCatalog(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.catalog), context.EXISTS() != null, context.CASCADE() != null);
    }

    public Node visitCreateSchema(SqlBaseParser.CreateSchemaContext context) {
        Optional<PrincipalSpecification> principal = Optional.empty();
        if (context.AUTHORIZATION() != null) {
            principal = Optional.of(this.getPrincipalSpecification(context.principal()));
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().propertyAssignments().property(), Property.class);
        }
        return new CreateSchema(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null, (List<Property>)properties, principal);
    }

    public Node visitDropSchema(SqlBaseParser.DropSchemaContext context) {
        return new DropSchema(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null, context.CASCADE() != null);
    }

    public Node visitRenameSchema(SqlBaseParser.RenameSchemaContext context) {
        return new RenameSchema(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitSetSchemaAuthorization(SqlBaseParser.SetSchemaAuthorizationContext context) {
        return new SetSchemaAuthorization(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), this.getPrincipalSpecification(context.principal()));
    }

    private static SaveMode toSaveMode(TerminalNode replace, TerminalNode exists) {
        boolean isReplace = replace != null;
        boolean isNotExists = exists != null;
        Preconditions.checkArgument((!isReplace || !isNotExists ? 1 : 0) != 0, (Object)"'OR REPLACE' and 'IF NOT EXISTS' clauses can not be used together");
        if (isReplace) {
            return SaveMode.REPLACE;
        }
        if (isNotExists) {
            return SaveMode.IGNORE;
        }
        return SaveMode.FAIL;
    }

    public Node visitCreateTableAsSelect(SqlBaseParser.CreateTableAsSelectContext context) {
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        Optional<List<Identifier>> columnAliases = Optional.empty();
        if (context.columnAliases() != null) {
            columnAliases = Optional.of(this.visit(context.columnAliases().identifier(), Identifier.class));
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().propertyAssignments().property(), Property.class);
        }
        if (context.REPLACE() != null && context.EXISTS() != null) {
            throw AstBuilder.parseError("'OR REPLACE' and 'IF NOT EXISTS' clauses can not be used together", (ParserRuleContext)context);
        }
        return new CreateTableAsSelect(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.rootQuery()), AstBuilder.toSaveMode(context.REPLACE(), context.EXISTS()), (List<Property>)properties, context.NO() == null, columnAliases, comment);
    }

    public Node visitCreateTable(SqlBaseParser.CreateTableContext context) {
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().propertyAssignments().property(), Property.class);
        }
        if (context.REPLACE() != null && context.EXISTS() != null) {
            throw AstBuilder.parseError("'OR REPLACE' and 'IF NOT EXISTS' clauses can not be used together", (ParserRuleContext)context);
        }
        return new CreateTable(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), this.visit(context.tableElement(), TableElement.class), AstBuilder.toSaveMode(context.REPLACE(), context.EXISTS()), (List<Property>)properties, comment);
    }

    public Node visitCreateMaterializedView(SqlBaseParser.CreateMaterializedViewContext context) {
        Optional<IntervalLiteral> gracePeriod = Optional.empty();
        if (context.GRACE() != null) {
            gracePeriod = Optional.of((IntervalLiteral)this.visit((ParseTree)context.interval()));
        }
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().propertyAssignments().property(), Property.class);
        }
        return new CreateMaterializedView(Optional.of(this.getLocation((ParserRuleContext)context)), this.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.rootQuery()), context.REPLACE() != null, context.EXISTS() != null, gracePeriod, (List<Property>)properties, comment);
    }

    public Node visitRefreshMaterializedView(SqlBaseParser.RefreshMaterializedViewContext context) {
        return new RefreshMaterializedView(Optional.of(this.getLocation((ParserRuleContext)context)), new Table(this.getQualifiedName(context.qualifiedName())));
    }

    public Node visitDropMaterializedView(SqlBaseParser.DropMaterializedViewContext context) {
        return new DropMaterializedView(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    public Node visitShowCreateTable(SqlBaseParser.ShowCreateTableContext context) {
        return new ShowCreate(this.getLocation((ParserRuleContext)context), ShowCreate.Type.TABLE, this.getQualifiedName(context.qualifiedName()));
    }

    public Node visitDropTable(SqlBaseParser.DropTableContext context) {
        return new DropTable(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    public Node visitDropView(SqlBaseParser.DropViewContext context) {
        return new DropView(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), context.EXISTS() != null);
    }

    public Node visitInsertInto(SqlBaseParser.InsertIntoContext context) {
        Optional<List<Identifier>> columnAliases = Optional.empty();
        if (context.columnAliases() != null) {
            columnAliases = Optional.of(this.visit(context.columnAliases().identifier(), Identifier.class));
        }
        return new Insert(new Table(this.getQualifiedName(context.qualifiedName())), columnAliases, (Query)this.visit((ParseTree)context.rootQuery()));
    }

    public Node visitDelete(SqlBaseParser.DeleteContext context) {
        return new Delete(this.getLocation((ParserRuleContext)context), new Table(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName())), this.visitIfPresent((ParserRuleContext)context.booleanExpression(), Expression.class));
    }

    public Node visitUpdate(SqlBaseParser.UpdateContext context) {
        return new Update(this.getLocation((ParserRuleContext)context), new Table(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName())), this.visit(context.updateAssignment(), UpdateAssignment.class), this.visitIfPresent((ParserRuleContext)context.booleanExpression(), Expression.class));
    }

    public Node visitUpdateAssignment(SqlBaseParser.UpdateAssignmentContext context) {
        return new UpdateAssignment((Identifier)this.visit((ParseTree)context.identifier()), (Expression)this.visit((ParseTree)context.expression()));
    }

    public Node visitTruncateTable(SqlBaseParser.TruncateTableContext context) {
        return new TruncateTable(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()));
    }

    public Node visitMerge(SqlBaseParser.MergeContext context) {
        Table table;
        Relation targetRelation = table = new Table(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()));
        if (context.identifier() != null) {
            targetRelation = new AliasedRelation(table, (Identifier)this.visit((ParseTree)context.identifier()), null);
        }
        return new Merge(this.getLocation((ParserRuleContext)context), targetRelation, (Relation)this.visit((ParseTree)context.relation()), (Expression)this.visit((ParseTree)context.expression()), this.visit(context.mergeCase(), MergeCase.class));
    }

    public Node visitMergeInsert(SqlBaseParser.MergeInsertContext context) {
        return new MergeInsert(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.condition, Expression.class), this.visit(context.targets, Identifier.class), this.visit(context.values, Expression.class));
    }

    public Node visitMergeUpdate(SqlBaseParser.MergeUpdateContext context) {
        ImmutableList.Builder assignments = ImmutableList.builder();
        for (int i = 0; i < context.targets.size(); ++i) {
            assignments.add((Object)new MergeUpdate.Assignment((Identifier)this.visit((ParseTree)context.targets.get(i)), (Expression)this.visit((ParseTree)context.values.get(i))));
        }
        return new MergeUpdate(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.condition, Expression.class), (List<MergeUpdate.Assignment>)assignments.build());
    }

    public Node visitMergeDelete(SqlBaseParser.MergeDeleteContext context) {
        return new MergeDelete(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.condition, Expression.class));
    }

    public Node visitRenameTable(SqlBaseParser.RenameTableContext context) {
        return new RenameTable(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.from), this.getQualifiedName(context.to), context.EXISTS() != null);
    }

    public Node visitSetTableProperties(SqlBaseParser.SetTablePropertiesContext context) {
        Object properties = ImmutableList.of();
        if (context.propertyAssignments() != null) {
            properties = this.visit(context.propertyAssignments().property(), Property.class);
        }
        return new SetProperties(this.getLocation((ParserRuleContext)context), SetProperties.Type.TABLE, this.getQualifiedName(context.qualifiedName()), (List<Property>)properties);
    }

    public Node visitCommentTable(SqlBaseParser.CommentTableContext context) {
        Optional<String> comment = Optional.empty();
        if (context.string() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        return new Comment(this.getLocation((ParserRuleContext)context), Comment.Type.TABLE, this.getQualifiedName(context.qualifiedName()), comment);
    }

    public Node visitCommentView(SqlBaseParser.CommentViewContext context) {
        Optional<String> comment = Optional.empty();
        if (context.string() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        return new Comment(this.getLocation((ParserRuleContext)context), Comment.Type.VIEW, this.getQualifiedName(context.qualifiedName()), comment);
    }

    public Node visitCommentColumn(SqlBaseParser.CommentColumnContext context) {
        Optional<String> comment = Optional.empty();
        if (context.string() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        return new Comment(this.getLocation((ParserRuleContext)context), Comment.Type.COLUMN, this.getQualifiedName(context.qualifiedName()), comment);
    }

    public Node visitRenameColumn(SqlBaseParser.RenameColumnContext context) {
        return new RenameColumn(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.tableName), this.getQualifiedName(context.from), (Identifier)this.visit((ParseTree)context.to), context.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() < context.COLUMN().getSymbol().getTokenIndex()), context.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() > context.COLUMN().getSymbol().getTokenIndex()));
    }

    public Node visitAnalyze(SqlBaseParser.AnalyzeContext context) {
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().propertyAssignments().property(), Property.class);
        }
        return new Analyze(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), (List<Property>)properties);
    }

    public Node visitAddColumn(SqlBaseParser.AddColumnContext context) {
        return new AddColumn(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), (ColumnDefinition)this.visit((ParseTree)context.columnDefinition()), context.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() < context.COLUMN().getSymbol().getTokenIndex()), context.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() > context.COLUMN().getSymbol().getTokenIndex()));
    }

    public Node visitSetColumnType(SqlBaseParser.SetColumnTypeContext context) {
        return new SetColumnType(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.tableName), this.getQualifiedName(context.columnName), (DataType)this.visit((ParseTree)context.type()), context.EXISTS() != null);
    }

    public Node visitSetTableAuthorization(SqlBaseParser.SetTableAuthorizationContext context) {
        return new SetTableAuthorization(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), this.getPrincipalSpecification(context.principal()));
    }

    public Node visitDropColumn(SqlBaseParser.DropColumnContext context) {
        return new DropColumn(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.tableName), this.getQualifiedName(context.column), context.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() < context.COLUMN().getSymbol().getTokenIndex()), context.EXISTS().stream().anyMatch(node -> node.getSymbol().getTokenIndex() > context.COLUMN().getSymbol().getTokenIndex()));
    }

    public Node visitTableExecute(SqlBaseParser.TableExecuteContext context) {
        Object arguments = ImmutableList.of();
        if (context.callArgument() != null) {
            arguments = this.visit(context.callArgument(), CallArgument.class);
        }
        return new TableExecute(this.getLocation((ParserRuleContext)context), new Table(this.getLocation(context.TABLE()), this.getQualifiedName(context.tableName)), (Identifier)this.visit((ParseTree)context.procedureName), (List<CallArgument>)arguments, this.visitIfPresent((ParserRuleContext)context.booleanExpression(), Expression.class));
    }

    public Node visitCreateView(SqlBaseParser.CreateViewContext context) {
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        Optional<CreateView.Security> security = Optional.empty();
        if (context.DEFINER() != null) {
            security = Optional.of(CreateView.Security.DEFINER);
        } else if (context.INVOKER() != null) {
            security = Optional.of(CreateView.Security.INVOKER);
        }
        return new CreateView(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), (Query)this.visit((ParseTree)context.rootQuery()), context.REPLACE() != null, comment, security);
    }

    public Node visitRenameView(SqlBaseParser.RenameViewContext context) {
        return new RenameView(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.from), this.getQualifiedName(context.to));
    }

    public Node visitRenameMaterializedView(SqlBaseParser.RenameMaterializedViewContext context) {
        return new RenameMaterializedView(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.from), this.getQualifiedName(context.to), context.EXISTS() != null);
    }

    public Node visitSetViewAuthorization(SqlBaseParser.SetViewAuthorizationContext context) {
        return new SetViewAuthorization(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), this.getPrincipalSpecification(context.principal()));
    }

    public Node visitSetMaterializedViewProperties(SqlBaseParser.SetMaterializedViewPropertiesContext context) {
        return new SetProperties(this.getLocation((ParserRuleContext)context), SetProperties.Type.MATERIALIZED_VIEW, this.getQualifiedName(context.qualifiedName()), this.visit(context.propertyAssignments().property(), Property.class));
    }

    public Node visitCreateFunction(SqlBaseParser.CreateFunctionContext context) {
        return new CreateFunction(this.getLocation((ParserRuleContext)context), (FunctionSpecification)this.visit((ParseTree)context.functionSpecification()), context.REPLACE() != null);
    }

    public Node visitDropFunction(SqlBaseParser.DropFunctionContext context) {
        return new DropFunction(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.functionDeclaration().qualifiedName()), this.visit(context.functionDeclaration().parameterDeclaration(), ParameterDeclaration.class), context.EXISTS() != null);
    }

    public Node visitStartTransaction(SqlBaseParser.StartTransactionContext context) {
        return new StartTransaction(this.visit(context.transactionMode(), TransactionMode.class));
    }

    public Node visitCommit(SqlBaseParser.CommitContext context) {
        return new Commit(this.getLocation((ParserRuleContext)context));
    }

    public Node visitRollback(SqlBaseParser.RollbackContext context) {
        return new Rollback(this.getLocation((ParserRuleContext)context));
    }

    public Node visitTransactionAccessMode(SqlBaseParser.TransactionAccessModeContext context) {
        return new TransactionAccessMode(this.getLocation((ParserRuleContext)context), context.accessMode.getType() == 192);
    }

    public Node visitIsolationLevel(SqlBaseParser.IsolationLevelContext context) {
        return (Node)this.visit((ParseTree)context.levelOfIsolation());
    }

    public Node visitReadUncommitted(SqlBaseParser.ReadUncommittedContext context) {
        return new Isolation(this.getLocation((ParserRuleContext)context), Isolation.Level.READ_UNCOMMITTED);
    }

    public Node visitReadCommitted(SqlBaseParser.ReadCommittedContext context) {
        return new Isolation(this.getLocation((ParserRuleContext)context), Isolation.Level.READ_COMMITTED);
    }

    public Node visitRepeatableRead(SqlBaseParser.RepeatableReadContext context) {
        return new Isolation(this.getLocation((ParserRuleContext)context), Isolation.Level.REPEATABLE_READ);
    }

    public Node visitSerializable(SqlBaseParser.SerializableContext context) {
        return new Isolation(this.getLocation((ParserRuleContext)context), Isolation.Level.SERIALIZABLE);
    }

    public Node visitCall(SqlBaseParser.CallContext context) {
        return new Call(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), this.visit(context.callArgument(), CallArgument.class));
    }

    public Node visitPrepare(SqlBaseParser.PrepareContext context) {
        return new Prepare(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (Statement)this.visit((ParseTree)context.statement()));
    }

    public Node visitDeallocate(SqlBaseParser.DeallocateContext context) {
        return new Deallocate(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitExecute(SqlBaseParser.ExecuteContext context) {
        return new Execute(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), this.visit(context.expression(), Expression.class));
    }

    public Node visitExecuteImmediate(SqlBaseParser.ExecuteImmediateContext context) {
        return new ExecuteImmediate(this.getLocation((ParserRuleContext)context), (StringLiteral)this.visit((ParseTree)context.string()), this.visit(context.expression(), Expression.class));
    }

    public Node visitDescribeOutput(SqlBaseParser.DescribeOutputContext context) {
        return new DescribeOutput(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitDescribeInput(SqlBaseParser.DescribeInputContext context) {
        return new DescribeInput(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitProperty(SqlBaseParser.PropertyContext context) {
        NodeLocation location = this.getLocation((ParserRuleContext)context);
        Identifier name = (Identifier)this.visit((ParseTree)context.identifier());
        SqlBaseParser.PropertyValueContext valueContext = context.propertyValue();
        if (valueContext instanceof SqlBaseParser.DefaultPropertyValueContext) {
            return new Property(location, name);
        }
        Expression value = (Expression)this.visit((ParseTree)((SqlBaseParser.NonDefaultPropertyValueContext)valueContext).expression());
        return new Property(location, name, value);
    }

    public Node visitRootQuery(SqlBaseParser.RootQueryContext context) {
        Query query = (Query)this.visit((ParseTree)context.query());
        return new Query(this.getLocation((ParserRuleContext)context), (List<FunctionSpecification>)Optional.ofNullable(context.withFunction()).map(SqlBaseParser.WithFunctionContext::functionSpecification).map(contexts -> this.visit((List<? extends ParserRuleContext>)contexts, (Class)FunctionSpecification.class)).orElseGet(ImmutableList::of), query.getWith(), query.getQueryBody(), query.getOrderBy(), query.getOffset(), query.getLimit());
    }

    public Node visitQuery(SqlBaseParser.QueryContext context) {
        Query body = (Query)this.visit((ParseTree)context.queryNoWith());
        return new Query(this.getLocation((ParserRuleContext)context), (List<FunctionSpecification>)ImmutableList.of(), this.visitIfPresent((ParserRuleContext)context.with(), With.class), body.getQueryBody(), body.getOrderBy(), body.getOffset(), body.getLimit());
    }

    public Node visitWith(SqlBaseParser.WithContext context) {
        return new With(this.getLocation((ParserRuleContext)context), context.RECURSIVE() != null, this.visit(context.namedQuery(), WithQuery.class));
    }

    public Node visitNamedQuery(SqlBaseParser.NamedQueryContext context) {
        Optional<List<Identifier>> columns = Optional.empty();
        if (context.columnAliases() != null) {
            columns = Optional.of(this.visit(context.columnAliases().identifier(), Identifier.class));
        }
        return new WithQuery(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.name), (Query)this.visit((ParseTree)context.query()), columns);
    }

    public Node visitQueryNoWith(SqlBaseParser.QueryNoWithContext context) {
        QueryBody term = (QueryBody)this.visit((ParseTree)context.queryTerm());
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.getLocation(context.ORDER()), this.visit(context.sortItem(), SortItem.class)));
        }
        Optional<Offset> offset = Optional.empty();
        if (context.OFFSET() != null) {
            Expression rowCount;
            if (context.offset.INTEGER_VALUE() != null) {
                rowCount = new LongLiteral(this.getLocation(context.offset.INTEGER_VALUE()), context.offset.getText());
            } else {
                rowCount = new Parameter(this.getLocation(context.offset.QUESTION_MARK()), this.parameterPosition);
                ++this.parameterPosition;
            }
            offset = Optional.of(new Offset(Optional.of(this.getLocation(context.OFFSET())), rowCount));
        }
        Optional<Node> limit = Optional.empty();
        if (context.FETCH() != null) {
            rowCount = Optional.empty();
            if (context.fetchFirst != null) {
                if (context.fetchFirst.INTEGER_VALUE() != null) {
                    rowCount = Optional.of(new LongLiteral(this.getLocation(context.fetchFirst.INTEGER_VALUE()), context.fetchFirst.getText()));
                } else {
                    rowCount = Optional.of(new Parameter(this.getLocation(context.fetchFirst.QUESTION_MARK()), this.parameterPosition));
                    ++this.parameterPosition;
                }
            }
            limit = Optional.of(new FetchFirst(Optional.of(this.getLocation(context.FETCH())), (Optional<Expression>)rowCount, context.TIES() != null));
        } else if (context.LIMIT() != null) {
            if (context.limit == null) {
                throw new IllegalStateException("Missing LIMIT value");
            }
            if (context.limit.ALL() != null) {
                rowCount = new AllRows(this.getLocation(context.limit.ALL()));
            } else if (context.limit.rowCount().INTEGER_VALUE() != null) {
                rowCount = new LongLiteral(this.getLocation(context.limit.rowCount().INTEGER_VALUE()), context.limit.getText());
            } else {
                rowCount = new Parameter(this.getLocation(context.limit.rowCount().QUESTION_MARK()), this.parameterPosition);
                ++this.parameterPosition;
            }
            limit = Optional.of(new Limit(Optional.of(this.getLocation(context.LIMIT())), (Expression)rowCount));
        }
        if (term instanceof QuerySpecification) {
            QuerySpecification query = (QuerySpecification)term;
            return new Query(this.getLocation((ParserRuleContext)context), (List<FunctionSpecification>)ImmutableList.of(), Optional.empty(), (QueryBody)new QuerySpecification(this.getLocation((ParserRuleContext)context), query.getSelect(), query.getFrom(), query.getWhere(), query.getGroupBy(), query.getHaving(), query.getWindows(), orderBy, offset, limit), Optional.empty(), Optional.empty(), Optional.empty());
        }
        return new Query(this.getLocation((ParserRuleContext)context), (List<FunctionSpecification>)ImmutableList.of(), Optional.empty(), term, orderBy, offset, limit);
    }

    public Node visitQuerySpecification(SqlBaseParser.QuerySpecificationContext context) {
        Optional<Relation> from = Optional.empty();
        List<SelectItem> selectItems = this.visit(context.selectItem(), SelectItem.class);
        List<Relation> relations = this.visit(context.relation(), Relation.class);
        if (!relations.isEmpty()) {
            Iterator<Relation> iterator = relations.iterator();
            Relation relation = iterator.next();
            while (iterator.hasNext()) {
                relation = new Join(this.getLocation((ParserRuleContext)context), Join.Type.IMPLICIT, relation, iterator.next(), Optional.empty());
            }
            from = Optional.of(relation);
        }
        return new QuerySpecification(this.getLocation((ParserRuleContext)context), new Select(this.getLocation(context.SELECT()), AstBuilder.isDistinct(context.setQuantifier()), selectItems), from, this.visitIfPresent((ParserRuleContext)context.where, Expression.class), this.visitIfPresent((ParserRuleContext)context.groupBy(), GroupBy.class), this.visitIfPresent((ParserRuleContext)context.having, Expression.class), this.visit(context.windowDefinition(), WindowDefinition.class), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public Node visitGroupBy(SqlBaseParser.GroupByContext context) {
        return new GroupBy(this.getLocation((ParserRuleContext)context), AstBuilder.isDistinct(context.setQuantifier()), this.visit(context.groupingElement(), GroupingElement.class));
    }

    public Node visitSingleGroupingSet(SqlBaseParser.SingleGroupingSetContext context) {
        return new SimpleGroupBy(this.getLocation((ParserRuleContext)context), this.visit(context.groupingSet().expression(), Expression.class));
    }

    public Node visitRollup(SqlBaseParser.RollupContext context) {
        return new GroupingSets(this.getLocation((ParserRuleContext)context), GroupingSets.Type.ROLLUP, context.groupingSet().stream().map(groupingSet -> this.visit(groupingSet.expression(), Expression.class)).collect(Collectors.toList()));
    }

    public Node visitCube(SqlBaseParser.CubeContext context) {
        return new GroupingSets(this.getLocation((ParserRuleContext)context), GroupingSets.Type.CUBE, context.groupingSet().stream().map(groupingSet -> this.visit(groupingSet.expression(), Expression.class)).collect(Collectors.toList()));
    }

    public Node visitMultipleGroupingSets(SqlBaseParser.MultipleGroupingSetsContext context) {
        return new GroupingSets(this.getLocation((ParserRuleContext)context), GroupingSets.Type.EXPLICIT, context.groupingSet().stream().map(groupingSet -> this.visit(groupingSet.expression(), Expression.class)).collect(Collectors.toList()));
    }

    public Node visitWindowSpecification(SqlBaseParser.WindowSpecificationContext context) {
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.getLocation(context.ORDER()), this.visit(context.sortItem(), SortItem.class)));
        }
        return new WindowSpecification(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.existingWindowName, Identifier.class), this.visit(context.partition, Expression.class), orderBy, this.visitIfPresent((ParserRuleContext)context.windowFrame(), WindowFrame.class));
    }

    public Node visitWindowDefinition(SqlBaseParser.WindowDefinitionContext context) {
        return new WindowDefinition(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.name), (WindowSpecification)this.visit((ParseTree)context.windowSpecification()));
    }

    public Node visitSetOperation(SqlBaseParser.SetOperationContext context) {
        QueryBody left = (QueryBody)this.visit((ParseTree)context.left);
        QueryBody right = (QueryBody)this.visit((ParseTree)context.right);
        boolean distinct = context.setQuantifier() == null || context.setQuantifier().DISTINCT() != null;
        return switch (context.operator.getType()) {
            case 281 -> new Union(this.getLocation(context.UNION()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            case 128 -> new Intersect(this.getLocation(context.INTERSECT()), (List<Relation>)ImmutableList.of((Object)left, (Object)right), distinct);
            case 91 -> new Except(this.getLocation(context.EXCEPT()), (Relation)left, (Relation)right, distinct);
            default -> throw new IllegalArgumentException("Unsupported set operation: " + context.operator.getText());
        };
    }

    public Node visitSelectAll(SqlBaseParser.SelectAllContext context) {
        Object aliases = ImmutableList.of();
        if (context.columnAliases() != null) {
            aliases = this.visit(context.columnAliases().identifier(), Identifier.class);
        }
        return new AllColumns(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.primaryExpression(), Expression.class), (List<Identifier>)aliases);
    }

    public Node visitSelectSingle(SqlBaseParser.SelectSingleContext context) {
        return new SingleColumn(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), this.visitIfPresent((ParserRuleContext)context.identifier(), Identifier.class));
    }

    public Node visitTable(SqlBaseParser.TableContext context) {
        return new Table(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()));
    }

    public Node visitSubquery(SqlBaseParser.SubqueryContext context) {
        return new TableSubquery(this.getLocation((ParserRuleContext)context), (Query)this.visit((ParseTree)context.queryNoWith()));
    }

    public Node visitInlineTable(SqlBaseParser.InlineTableContext context) {
        return new Values(this.getLocation((ParserRuleContext)context), this.visit(context.expression(), Expression.class));
    }

    public Node visitExplain(SqlBaseParser.ExplainContext context) {
        return new Explain(this.getLocation((ParserRuleContext)context), (Statement)this.visit((ParseTree)context.statement()), this.visit(context.explainOption(), ExplainOption.class));
    }

    public Node visitExplainAnalyze(SqlBaseParser.ExplainAnalyzeContext context) {
        return new ExplainAnalyze(this.getLocation((ParserRuleContext)context), context.VERBOSE() != null, (Statement)this.visit((ParseTree)context.statement()));
    }

    public Node visitExplainFormat(SqlBaseParser.ExplainFormatContext context) {
        return switch (context.value.getType()) {
            case 113 -> new ExplainFormat(this.getLocation((ParserRuleContext)context), ExplainFormat.Type.GRAPHVIZ);
            case 263 -> new ExplainFormat(this.getLocation((ParserRuleContext)context), ExplainFormat.Type.TEXT);
            case 137 -> new ExplainFormat(this.getLocation((ParserRuleContext)context), ExplainFormat.Type.JSON);
            default -> throw new IllegalArgumentException("Unsupported EXPLAIN format: " + context.value.getText());
        };
    }

    public Node visitExplainType(SqlBaseParser.ExplainTypeContext context) {
        return switch (context.value.getType()) {
            case 160 -> new ExplainType(this.getLocation((ParserRuleContext)context), ExplainType.Type.LOGICAL);
            case 80 -> new ExplainType(this.getLocation((ParserRuleContext)context), ExplainType.Type.DISTRIBUTED);
            case 294 -> new ExplainType(this.getLocation((ParserRuleContext)context), ExplainType.Type.VALIDATE);
            case 132 -> new ExplainType(this.getLocation((ParserRuleContext)context), ExplainType.Type.IO);
            default -> throw new IllegalArgumentException("Unsupported EXPLAIN type: " + context.value.getText());
        };
    }

    public Node visitShowTables(SqlBaseParser.ShowTablesContext context) {
        return new ShowTables(this.getLocation((ParserRuleContext)context), Optional.ofNullable(context.qualifiedName()).map(this::getQualifiedName), AstBuilder.getTextIfPresent((ParserRuleContext)context.pattern).map(AstBuilder::unquote), AstBuilder.getTextIfPresent((ParserRuleContext)context.escape).map(AstBuilder::unquote));
    }

    public Node visitShowSchemas(SqlBaseParser.ShowSchemasContext context) {
        return new ShowSchemas(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.identifier(), Identifier.class), AstBuilder.getTextIfPresent((ParserRuleContext)context.pattern).map(AstBuilder::unquote), AstBuilder.getTextIfPresent((ParserRuleContext)context.escape).map(AstBuilder::unquote));
    }

    public Node visitShowCatalogs(SqlBaseParser.ShowCatalogsContext context) {
        return new ShowCatalogs(this.getLocation((ParserRuleContext)context), AstBuilder.getTextIfPresent((ParserRuleContext)context.pattern).map(AstBuilder::unquote), AstBuilder.getTextIfPresent((ParserRuleContext)context.escape).map(AstBuilder::unquote));
    }

    public Node visitShowColumns(SqlBaseParser.ShowColumnsContext context) {
        return new ShowColumns(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), AstBuilder.getTextIfPresent((ParserRuleContext)context.pattern).map(AstBuilder::unquote), AstBuilder.getTextIfPresent((ParserRuleContext)context.escape).map(AstBuilder::unquote));
    }

    public Node visitShowStats(SqlBaseParser.ShowStatsContext context) {
        return new ShowStats(Optional.of(this.getLocation((ParserRuleContext)context)), new Table(this.getQualifiedName(context.qualifiedName())));
    }

    public Node visitShowStatsForQuery(SqlBaseParser.ShowStatsForQueryContext context) {
        Query query = (Query)this.visit((ParseTree)context.rootQuery());
        return new ShowStats(Optional.of(this.getLocation((ParserRuleContext)context)), new TableSubquery(query));
    }

    public Node visitShowCreateSchema(SqlBaseParser.ShowCreateSchemaContext context) {
        return new ShowCreate(this.getLocation((ParserRuleContext)context), ShowCreate.Type.SCHEMA, this.getQualifiedName(context.qualifiedName()));
    }

    public Node visitShowCreateView(SqlBaseParser.ShowCreateViewContext context) {
        return new ShowCreate(this.getLocation((ParserRuleContext)context), ShowCreate.Type.VIEW, this.getQualifiedName(context.qualifiedName()));
    }

    public Node visitShowCreateMaterializedView(SqlBaseParser.ShowCreateMaterializedViewContext context) {
        return new ShowCreate(this.getLocation((ParserRuleContext)context), ShowCreate.Type.MATERIALIZED_VIEW, this.getQualifiedName(context.qualifiedName()));
    }

    public Node visitShowFunctions(SqlBaseParser.ShowFunctionsContext context) {
        return new ShowFunctions(this.getLocation((ParserRuleContext)context), Optional.ofNullable(context.qualifiedName()).map(this::getQualifiedName), AstBuilder.getTextIfPresent((ParserRuleContext)context.pattern).map(AstBuilder::unquote), AstBuilder.getTextIfPresent((ParserRuleContext)context.escape).map(AstBuilder::unquote));
    }

    public Node visitShowSession(SqlBaseParser.ShowSessionContext context) {
        return new ShowSession(this.getLocation((ParserRuleContext)context), AstBuilder.getTextIfPresent((ParserRuleContext)context.pattern).map(AstBuilder::unquote), AstBuilder.getTextIfPresent((ParserRuleContext)context.escape).map(AstBuilder::unquote));
    }

    public Node visitSetSession(SqlBaseParser.SetSessionContext context) {
        return new SetSession(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), (Expression)this.visit((ParseTree)context.expression()));
    }

    public Node visitResetSession(SqlBaseParser.ResetSessionContext context) {
        return new ResetSession(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()));
    }

    public Node visitSetSessionAuthorization(SqlBaseParser.SetSessionAuthorizationContext context) {
        if (context.authorizationUser() instanceof SqlBaseParser.IdentifierUserContext || context.authorizationUser() instanceof SqlBaseParser.StringUserContext) {
            return new SetSessionAuthorization(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.authorizationUser()));
        }
        throw new IllegalArgumentException("Unsupported Session Authorization User: " + String.valueOf(context.authorizationUser()));
    }

    public Node visitResetSessionAuthorization(SqlBaseParser.ResetSessionAuthorizationContext context) {
        return new ResetSessionAuthorization(this.getLocation((ParserRuleContext)context));
    }

    public Node visitCreateRole(SqlBaseParser.CreateRoleContext context) {
        return new CreateRole(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.name), this.getGrantorSpecificationIfPresent(context.grantor()), this.visitIfPresent((ParserRuleContext)context.catalog, Identifier.class));
    }

    public Node visitDropRole(SqlBaseParser.DropRoleContext context) {
        return new DropRole(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.name), this.visitIfPresent((ParserRuleContext)context.catalog, Identifier.class));
    }

    public Node visitGrantRoles(SqlBaseParser.GrantRolesContext context) {
        return new GrantRoles(this.getLocation((ParserRuleContext)context), (Set<Identifier>)ImmutableSet.copyOf(this.getIdentifiers(context.roles().identifier())), (Set<PrincipalSpecification>)ImmutableSet.copyOf(this.getPrincipalSpecifications(context.principal())), context.OPTION() != null, this.getGrantorSpecificationIfPresent(context.grantor()), this.visitIfPresent((ParserRuleContext)context.catalog, Identifier.class));
    }

    public Node visitRevokeRoles(SqlBaseParser.RevokeRolesContext context) {
        return new RevokeRoles(this.getLocation((ParserRuleContext)context), (Set<Identifier>)ImmutableSet.copyOf(this.getIdentifiers(context.roles().identifier())), (Set<PrincipalSpecification>)ImmutableSet.copyOf(this.getPrincipalSpecifications(context.principal())), context.OPTION() != null, this.getGrantorSpecificationIfPresent(context.grantor()), this.visitIfPresent((ParserRuleContext)context.catalog, Identifier.class));
    }

    public Node visitSetRole(SqlBaseParser.SetRoleContext context) {
        SetRole.Type type = SetRole.Type.ROLE;
        if (context.ALL() != null) {
            type = SetRole.Type.ALL;
        } else if (context.NONE() != null) {
            type = SetRole.Type.NONE;
        }
        return new SetRole(this.getLocation((ParserRuleContext)context), type, this.getIdentifierIfPresent((ParserRuleContext)context.role), this.visitIfPresent((ParserRuleContext)context.catalog, Identifier.class));
    }

    public Node visitGrant(SqlBaseParser.GrantContext context) {
        Optional<Object> privileges = context.ALL() != null ? Optional.empty() : Optional.of(context.privilege().stream().map(RuleContext::getText).collect(Collectors.toList()));
        Optional<GrantOnType> type = context.SCHEMA() != null ? Optional.of(GrantOnType.SCHEMA) : (context.TABLE() != null ? Optional.of(GrantOnType.TABLE) : Optional.empty());
        return new Grant(this.getLocation((ParserRuleContext)context), privileges, type, this.getQualifiedName(context.qualifiedName()), this.getPrincipalSpecification(context.grantee), context.OPTION() != null);
    }

    public Node visitDeny(SqlBaseParser.DenyContext context) {
        Optional<Object> privileges = context.ALL() != null ? Optional.empty() : Optional.of(context.privilege().stream().map(RuleContext::getText).collect(Collectors.toList()));
        Optional<GrantOnType> type = context.SCHEMA() != null ? Optional.of(GrantOnType.SCHEMA) : (context.TABLE() != null ? Optional.of(GrantOnType.TABLE) : Optional.empty());
        return new Deny(this.getLocation((ParserRuleContext)context), privileges, type, this.getQualifiedName(context.qualifiedName()), this.getPrincipalSpecification(context.grantee));
    }

    public Node visitRevoke(SqlBaseParser.RevokeContext context) {
        Optional<Object> privileges = context.ALL() != null ? Optional.empty() : Optional.of(context.privilege().stream().map(RuleContext::getText).collect(Collectors.toList()));
        Optional<GrantOnType> type = context.SCHEMA() != null ? Optional.of(GrantOnType.SCHEMA) : (context.TABLE() != null ? Optional.of(GrantOnType.TABLE) : Optional.empty());
        return new Revoke(this.getLocation((ParserRuleContext)context), context.OPTION() != null, privileges, type, this.getQualifiedName(context.qualifiedName()), this.getPrincipalSpecification(context.grantee));
    }

    public Node visitShowGrants(SqlBaseParser.ShowGrantsContext context) {
        Optional<QualifiedName> tableName = Optional.empty();
        if (context.qualifiedName() != null) {
            tableName = Optional.of(this.getQualifiedName(context.qualifiedName()));
        }
        return new ShowGrants(this.getLocation((ParserRuleContext)context), context.TABLE() != null, tableName);
    }

    public Node visitShowRoles(SqlBaseParser.ShowRolesContext context) {
        return new ShowRoles(this.getLocation((ParserRuleContext)context), this.getIdentifierIfPresent((ParserRuleContext)context.identifier()), context.CURRENT() != null);
    }

    public Node visitShowRoleGrants(SqlBaseParser.ShowRoleGrantsContext context) {
        return new ShowRoleGrants(this.getLocation((ParserRuleContext)context), this.getIdentifierIfPresent((ParserRuleContext)context.identifier()));
    }

    public Node visitSetPath(SqlBaseParser.SetPathContext context) {
        return new SetPath(this.getLocation((ParserRuleContext)context), (PathSpecification)this.visit((ParseTree)context.pathSpecification()));
    }

    public Node visitSetTimeZone(SqlBaseParser.SetTimeZoneContext context) {
        Optional<Expression> timeZone = Optional.empty();
        if (context.expression() != null) {
            timeZone = Optional.of((Expression)this.visit((ParseTree)context.expression()));
        }
        return new SetTimeZone(this.getLocation((ParserRuleContext)context), timeZone);
    }

    public Node visitLogicalNot(SqlBaseParser.LogicalNotContext context) {
        return new NotExpression(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.booleanExpression()));
    }

    public Node visitOr(SqlBaseParser.OrContext context) {
        List<ParserRuleContext> terms = AstBuilder.flatten((ParserRuleContext)context, element -> {
            if (element instanceof SqlBaseParser.OrContext) {
                SqlBaseParser.OrContext or = (SqlBaseParser.OrContext)element;
                return Optional.of(or.booleanExpression());
            }
            return Optional.empty();
        });
        return new LogicalExpression(this.getLocation((ParserRuleContext)context), LogicalExpression.Operator.OR, this.visit(terms, Expression.class));
    }

    public Node visitAnd(SqlBaseParser.AndContext context) {
        List<ParserRuleContext> terms = AstBuilder.flatten((ParserRuleContext)context, element -> {
            if (element instanceof SqlBaseParser.AndContext) {
                SqlBaseParser.AndContext and = (SqlBaseParser.AndContext)element;
                return Optional.of(and.booleanExpression());
            }
            return Optional.empty();
        });
        return new LogicalExpression(this.getLocation((ParserRuleContext)context), LogicalExpression.Operator.AND, this.visit(terms, Expression.class));
    }

    private static List<ParserRuleContext> flatten(ParserRuleContext root, Function<ParserRuleContext, Optional<List<? extends ParserRuleContext>>> extractChildren) {
        ArrayList<ParserRuleContext> result = new ArrayList<ParserRuleContext>();
        ArrayDeque<ParserRuleContext> pending = new ArrayDeque<ParserRuleContext>();
        pending.push(root);
        while (!pending.isEmpty()) {
            ParserRuleContext next = (ParserRuleContext)pending.pop();
            Optional<List<? extends ParserRuleContext>> children = extractChildren.apply(next);
            if (!children.isPresent()) {
                result.add(next);
                continue;
            }
            for (int i = children.get().size() - 1; i >= 0; --i) {
                pending.push(children.get().get(i));
            }
        }
        return result;
    }

    public Node visitJoinRelation(SqlBaseParser.JoinRelationContext context) {
        JoinCriteria criteria;
        Relation right;
        Relation left = (Relation)this.visit((ParseTree)context.left);
        if (context.CROSS() != null) {
            Relation right2 = (Relation)this.visit((ParseTree)context.right);
            return new Join(this.getLocation((ParserRuleContext)context), Join.Type.CROSS, left, right2, Optional.empty());
        }
        if (context.NATURAL() != null) {
            right = (Relation)this.visit((ParseTree)context.right);
            criteria = new NaturalJoin();
        } else {
            right = (Relation)this.visit((ParseTree)context.rightRelation);
            if (context.joinCriteria().ON() != null) {
                criteria = new JoinOn((Expression)this.visit((ParseTree)context.joinCriteria().booleanExpression()));
            } else if (context.joinCriteria().USING() != null) {
                criteria = new JoinUsing(this.visit(context.joinCriteria().identifier(), Identifier.class));
            } else {
                throw new IllegalArgumentException("Unsupported join criteria");
            }
        }
        Join.Type joinType = context.joinType().LEFT() != null ? Join.Type.LEFT : (context.joinType().RIGHT() != null ? Join.Type.RIGHT : (context.joinType().FULL() != null ? Join.Type.FULL : Join.Type.INNER));
        return new Join(this.getLocation((ParserRuleContext)context), joinType, left, right, Optional.of(criteria));
    }

    public Node visitSampledRelation(SqlBaseParser.SampledRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.patternRecognition());
        if (context.TABLESAMPLE() == null) {
            return child;
        }
        return new SampledRelation(this.getLocation((ParserRuleContext)context), child, AstBuilder.getSamplingMethod((Token)context.sampleType().getChild(0).getPayload()), (Expression)this.visit((ParseTree)context.percentage));
    }

    public Node visitPatternRecognition(SqlBaseParser.PatternRecognitionContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.aliasedRelation());
        if (context.MATCH_RECOGNIZE() == null) {
            return child;
        }
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.getLocation(context.ORDER()), this.visit(context.sortItem(), SortItem.class)));
        }
        Optional<PatternSearchMode> searchMode = Optional.empty();
        if (context.INITIAL() != null) {
            searchMode = Optional.of(new PatternSearchMode(this.getLocation(context.INITIAL()), PatternSearchMode.Mode.INITIAL));
        } else if (context.SEEK() != null) {
            searchMode = Optional.of(new PatternSearchMode(this.getLocation(context.SEEK()), PatternSearchMode.Mode.SEEK));
        }
        PatternRecognitionRelation relation = new PatternRecognitionRelation(this.getLocation((ParserRuleContext)context), child, this.visit(context.partition, Expression.class), orderBy, this.visit(context.measureDefinition(), MeasureDefinition.class), this.getRowsPerMatch(context.rowsPerMatch()), this.visitIfPresent((ParserRuleContext)context.skipTo(), SkipTo.class), searchMode, (RowPattern)this.visit((ParseTree)context.rowPattern()), this.visit(context.subsetDefinition(), SubsetDefinition.class), this.visit(context.variableDefinition(), VariableDefinition.class));
        if (context.identifier() == null) {
            return relation;
        }
        List<Identifier> aliases = null;
        if (context.columnAliases() != null) {
            aliases = this.visit(context.columnAliases().identifier(), Identifier.class);
        }
        return new AliasedRelation(this.getLocation((ParserRuleContext)context), (Relation)relation, (Identifier)this.visit((ParseTree)context.identifier()), aliases);
    }

    public Node visitMeasureDefinition(SqlBaseParser.MeasureDefinitionContext context) {
        return new MeasureDefinition(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    private Optional<PatternRecognitionRelation.RowsPerMatch> getRowsPerMatch(SqlBaseParser.RowsPerMatchContext context) {
        if (context == null) {
            return Optional.empty();
        }
        if (context.ONE() != null) {
            return Optional.of(PatternRecognitionRelation.RowsPerMatch.ONE);
        }
        if (context.emptyMatchHandling() == null) {
            return Optional.of(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY);
        }
        if (context.emptyMatchHandling().SHOW() != null) {
            return Optional.of(PatternRecognitionRelation.RowsPerMatch.ALL_SHOW_EMPTY);
        }
        if (context.emptyMatchHandling().OMIT() != null) {
            return Optional.of(PatternRecognitionRelation.RowsPerMatch.ALL_OMIT_EMPTY);
        }
        return Optional.of(PatternRecognitionRelation.RowsPerMatch.ALL_WITH_UNMATCHED);
    }

    public Node visitSkipTo(SqlBaseParser.SkipToContext context) {
        if (context.PAST() != null) {
            return SkipTo.skipPastLastRow(this.getLocation((ParserRuleContext)context));
        }
        if (context.NEXT() != null) {
            return SkipTo.skipToNextRow(this.getLocation((ParserRuleContext)context));
        }
        if (context.FIRST() != null) {
            return SkipTo.skipToFirst(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
        }
        return SkipTo.skipToLast(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitSubsetDefinition(SqlBaseParser.SubsetDefinitionContext context) {
        return new SubsetDefinition(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.name), this.visit(context.union, Identifier.class));
    }

    public Node visitVariableDefinition(SqlBaseParser.VariableDefinitionContext context) {
        return new VariableDefinition(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (Expression)this.visit((ParseTree)context.expression()));
    }

    public Node visitAliasedRelation(SqlBaseParser.AliasedRelationContext context) {
        Relation child = (Relation)this.visit((ParseTree)context.relationPrimary());
        if (context.identifier() == null) {
            return child;
        }
        List<Identifier> aliases = null;
        if (context.columnAliases() != null) {
            aliases = this.visit(context.columnAliases().identifier(), Identifier.class);
        }
        return new AliasedRelation(this.getLocation((ParserRuleContext)context), child, (Identifier)this.visit((ParseTree)context.identifier()), aliases);
    }

    public Node visitTableName(SqlBaseParser.TableNameContext context) {
        if (context.queryPeriod() != null) {
            return new Table(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), (QueryPeriod)this.visit((ParseTree)context.queryPeriod()));
        }
        return new Table(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()));
    }

    public Node visitSubqueryRelation(SqlBaseParser.SubqueryRelationContext context) {
        return new TableSubquery(this.getLocation((ParserRuleContext)context), (Query)this.visit((ParseTree)context.query()));
    }

    public Node visitUnnest(SqlBaseParser.UnnestContext context) {
        return new Unnest(this.getLocation((ParserRuleContext)context), this.visit(context.expression(), Expression.class), context.ORDINALITY() != null);
    }

    public Node visitLateral(SqlBaseParser.LateralContext context) {
        return new Lateral(this.getLocation((ParserRuleContext)context), (Query)this.visit((ParseTree)context.query()));
    }

    public Node visitTableFunctionInvocation(SqlBaseParser.TableFunctionInvocationContext context) {
        return (Node)this.visit((ParseTree)context.tableFunctionCall());
    }

    public Node visitTableFunctionCall(SqlBaseParser.TableFunctionCallContext context) {
        QualifiedName name = this.getQualifiedName(context.qualifiedName());
        List<TableFunctionArgument> arguments = this.visit(context.tableFunctionArgument(), TableFunctionArgument.class);
        Object copartitioning = ImmutableList.of();
        if (context.COPARTITION() != null) {
            copartitioning = (List)context.copartitionTables().stream().map(tablesList -> (ImmutableList)tablesList.qualifiedName().stream().map(this::getQualifiedName).collect(ImmutableList.toImmutableList())).collect(ImmutableList.toImmutableList());
        }
        return new TableFunctionInvocation(this.getLocation((ParserRuleContext)context), name, arguments, (List<List<QualifiedName>>)copartitioning);
    }

    public Node visitTableFunctionArgument(SqlBaseParser.TableFunctionArgumentContext context) {
        Optional<Identifier> name = this.visitIfPresent((ParserRuleContext)context.identifier(), Identifier.class);
        Node value = context.tableArgument() != null ? (Node)this.visit((ParseTree)context.tableArgument()) : (context.descriptorArgument() != null ? (Node)this.visit((ParseTree)context.descriptorArgument()) : (Node)this.visit((ParseTree)context.expression()));
        return new TableFunctionArgument(this.getLocation((ParserRuleContext)context), name, value);
    }

    public Node visitTableArgument(SqlBaseParser.TableArgumentContext context) {
        Relation table = (Relation)this.visit((ParseTree)context.tableArgumentRelation());
        Optional<List<Expression>> partitionBy = Optional.empty();
        if (context.PARTITION() != null) {
            partitionBy = Optional.of(this.visit(context.expression(), Expression.class));
        }
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.visit(context.sortItem(), SortItem.class)));
        }
        Optional<Object> emptyTableTreatment = Optional.empty();
        if (context.PRUNE() != null) {
            emptyTableTreatment = Optional.of(new EmptyTableTreatment(this.getLocation(context.PRUNE()), EmptyTableTreatment.Treatment.PRUNE));
        } else if (context.KEEP() != null) {
            emptyTableTreatment = Optional.of(new EmptyTableTreatment(this.getLocation(context.KEEP()), EmptyTableTreatment.Treatment.KEEP));
        }
        return new TableFunctionTableArgument(this.getLocation((ParserRuleContext)context), table, partitionBy, orderBy, emptyTableTreatment);
    }

    public Node visitTableArgumentTable(SqlBaseParser.TableArgumentTableContext context) {
        Relation relation = new Table(this.getLocation(context.TABLE()), this.getQualifiedName(context.qualifiedName()));
        if (context.identifier() != null) {
            Identifier alias = (Identifier)this.visit((ParseTree)context.identifier());
            if (context.AS() == null) {
                AstBuilder.validateArgumentAlias(alias, (ParserRuleContext)context.identifier());
            }
            List<Identifier> columnNames = null;
            if (context.columnAliases() != null) {
                columnNames = this.visit(context.columnAliases().identifier(), Identifier.class);
            }
            relation = new AliasedRelation(this.getLocation(context.TABLE()), relation, alias, columnNames);
        }
        return relation;
    }

    public Node visitTableArgumentQuery(SqlBaseParser.TableArgumentQueryContext context) {
        Relation relation = new TableSubquery(this.getLocation(context.TABLE()), (Query)this.visit((ParseTree)context.query()));
        if (context.identifier() != null) {
            Identifier alias = (Identifier)this.visit((ParseTree)context.identifier());
            if (context.AS() == null) {
                AstBuilder.validateArgumentAlias(alias, (ParserRuleContext)context.identifier());
            }
            List<Identifier> columnNames = null;
            if (context.columnAliases() != null) {
                columnNames = this.visit(context.columnAliases().identifier(), Identifier.class);
            }
            relation = new AliasedRelation(this.getLocation(context.TABLE()), relation, alias, columnNames);
        }
        return relation;
    }

    public Node visitDescriptorArgument(SqlBaseParser.DescriptorArgumentContext context) {
        if (context.NULL() != null) {
            return TableFunctionDescriptorArgument.nullDescriptorArgument(this.getLocation((ParserRuleContext)context));
        }
        List<DescriptorField> fields = this.visit(context.descriptorField(), DescriptorField.class);
        return TableFunctionDescriptorArgument.descriptorArgument(this.getLocation((ParserRuleContext)context), new Descriptor(this.getLocation(context.DESCRIPTOR()), fields));
    }

    public Node visitDescriptorField(SqlBaseParser.DescriptorFieldContext context) {
        return new DescriptorField(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), this.visitIfPresent((ParserRuleContext)context.type(), DataType.class));
    }

    public Node visitParenthesizedRelation(SqlBaseParser.ParenthesizedRelationContext context) {
        return (Node)this.visit((ParseTree)context.relation());
    }

    public Node visitPredicated(SqlBaseParser.PredicatedContext context) {
        if (context.predicate() != null) {
            return (Node)this.visit((ParseTree)context.predicate());
        }
        return (Node)this.visit((ParseTree)context.valueExpression);
    }

    public Node visitComparison(SqlBaseParser.ComparisonContext context) {
        return new ComparisonExpression(this.getLocation((ParserRuleContext)context.comparisonOperator()), AstBuilder.getComparisonOperator(((TerminalNode)context.comparisonOperator().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
    }

    public Node visitDistinctFrom(SqlBaseParser.DistinctFromContext context) {
        Expression expression = new ComparisonExpression(this.getLocation((ParserRuleContext)context), ComparisonExpression.Operator.IS_DISTINCT_FROM, (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.right));
        if (context.NOT() != null) {
            expression = new NotExpression(this.getLocation((ParserRuleContext)context), expression);
        }
        return expression;
    }

    public Node visitBetween(SqlBaseParser.BetweenContext context) {
        Expression expression = new BetweenPredicate(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.lower), (Expression)this.visit((ParseTree)context.upper));
        if (context.NOT() != null) {
            expression = new NotExpression(this.getLocation((ParserRuleContext)context), expression);
        }
        return expression;
    }

    public Node visitNullPredicate(SqlBaseParser.NullPredicateContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.value);
        if (context.NOT() == null) {
            return new IsNullPredicate(this.getLocation((ParserRuleContext)context), child);
        }
        return new IsNotNullPredicate(this.getLocation((ParserRuleContext)context), child);
    }

    public Node visitLike(SqlBaseParser.LikeContext context) {
        Expression result = new LikePredicate(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.pattern), this.visitIfPresent((ParserRuleContext)context.escape, Expression.class));
        if (context.NOT() != null) {
            result = new NotExpression(this.getLocation((ParserRuleContext)context), result);
        }
        return result;
    }

    public Node visitInList(SqlBaseParser.InListContext context) {
        Expression result = new InPredicate(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.value), (Expression)new InListExpression(this.getLocation((ParserRuleContext)context), this.visit(context.expression(), Expression.class)));
        if (context.NOT() != null) {
            result = new NotExpression(this.getLocation((ParserRuleContext)context), result);
        }
        return result;
    }

    public Node visitInSubquery(SqlBaseParser.InSubqueryContext context) {
        Expression result = new InPredicate(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.value), (Expression)new SubqueryExpression(this.getLocation((ParserRuleContext)context), (Query)this.visit((ParseTree)context.query())));
        if (context.NOT() != null) {
            result = new NotExpression(this.getLocation((ParserRuleContext)context), result);
        }
        return result;
    }

    public Node visitExists(SqlBaseParser.ExistsContext context) {
        return new ExistsPredicate(this.getLocation((ParserRuleContext)context), (Expression)new SubqueryExpression(this.getLocation((ParserRuleContext)context), (Query)this.visit((ParseTree)context.query())));
    }

    public Node visitQuantifiedComparison(SqlBaseParser.QuantifiedComparisonContext context) {
        return new QuantifiedComparisonExpression(this.getLocation((ParserRuleContext)context.comparisonOperator()), AstBuilder.getComparisonOperator(((TerminalNode)context.comparisonOperator().getChild(0)).getSymbol()), AstBuilder.getComparisonQuantifier(((TerminalNode)context.comparisonQuantifier().getChild(0)).getSymbol()), (Expression)this.visit((ParseTree)context.value), (Expression)new SubqueryExpression(this.getLocation((ParserRuleContext)context.query()), (Query)this.visit((ParseTree)context.query())));
    }

    public Node visitArithmeticUnary(SqlBaseParser.ArithmeticUnaryContext context) {
        Expression child = (Expression)this.visit((ParseTree)context.valueExpression());
        return switch (context.operator.getType()) {
            case 319 -> ArithmeticUnaryExpression.negative(this.getLocation((ParserRuleContext)context), child);
            case 318 -> ArithmeticUnaryExpression.positive(this.getLocation((ParserRuleContext)context), child);
            default -> throw new UnsupportedOperationException("Unsupported sign: " + context.operator.getText());
        };
    }

    public Node visitArithmeticBinary(SqlBaseParser.ArithmeticBinaryContext context) {
        return new ArithmeticBinaryExpression(this.getLocation(context.operator), AstBuilder.getArithmeticBinaryOperator(context.operator), (Expression)this.visit((ParseTree)context.left), (Expression)this.visit((ParseTree)context.right));
    }

    public Node visitConcatenation(SqlBaseParser.ConcatenationContext context) {
        return new FunctionCall(this.getLocation(context.CONCAT()), QualifiedName.of("concat"), (List<Expression>)ImmutableList.of((Object)((Expression)this.visit((ParseTree)context.left)), (Object)((Expression)this.visit((ParseTree)context.right))));
    }

    public Node visitAtTimeZone(SqlBaseParser.AtTimeZoneContext context) {
        return new AtTimeZone(this.getLocation(context.AT()), (Expression)this.visit((ParseTree)context.valueExpression()), (Expression)this.visit((ParseTree)context.timeZoneSpecifier()));
    }

    public Node visitTimeZoneInterval(SqlBaseParser.TimeZoneIntervalContext context) {
        return (Node)this.visit((ParseTree)context.interval());
    }

    public Node visitTimeZoneString(SqlBaseParser.TimeZoneStringContext context) {
        return (Node)this.visit((ParseTree)context.string());
    }

    public Node visitParenthesizedExpression(SqlBaseParser.ParenthesizedExpressionContext context) {
        return (Node)this.visit((ParseTree)context.expression());
    }

    public Node visitRowConstructor(SqlBaseParser.RowConstructorContext context) {
        return new Row(this.getLocation((ParserRuleContext)context), this.visit(context.expression(), Expression.class));
    }

    public Node visitArrayConstructor(SqlBaseParser.ArrayConstructorContext context) {
        return new Array(this.getLocation((ParserRuleContext)context), this.visit(context.expression(), Expression.class));
    }

    public Node visitCast(SqlBaseParser.CastContext context) {
        boolean isTryCast = context.TRY_CAST() != null;
        return new Cast(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), (DataType)this.visit((ParseTree)context.type()), isTryCast);
    }

    public Node visitSpecialDateTimeFunction(SqlBaseParser.SpecialDateTimeFunctionContext context) {
        CurrentTime.Function function = AstBuilder.getDateTimeFunctionType(context.name);
        if (context.precision != null) {
            return new CurrentTime(this.getLocation((ParserRuleContext)context), function, (Integer)Integer.parseInt(context.precision.getText()));
        }
        return new CurrentTime(this.getLocation((ParserRuleContext)context), function);
    }

    public Node visitCurrentCatalog(SqlBaseParser.CurrentCatalogContext context) {
        return new CurrentCatalog(this.getLocation(context.CURRENT_CATALOG()));
    }

    public Node visitCurrentSchema(SqlBaseParser.CurrentSchemaContext context) {
        return new CurrentSchema(this.getLocation(context.CURRENT_SCHEMA()));
    }

    public Node visitCurrentUser(SqlBaseParser.CurrentUserContext context) {
        return new CurrentUser(this.getLocation(context.CURRENT_USER()));
    }

    public Node visitCurrentPath(SqlBaseParser.CurrentPathContext context) {
        return new CurrentPath(this.getLocation(context.CURRENT_PATH()));
    }

    public Node visitExtract(SqlBaseParser.ExtractContext context) {
        Extract.Field field;
        String fieldString = context.identifier().getText();
        try {
            field = Extract.Field.valueOf(fieldString.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw AstBuilder.parseError("Invalid EXTRACT field: " + fieldString, (ParserRuleContext)context);
        }
        return new Extract(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.valueExpression()), field);
    }

    public Node visitListagg(SqlBaseParser.ListaggContext context) {
        Optional<Window> window = Optional.empty();
        OrderBy orderBy = new OrderBy(this.visit(context.sortItem(), SortItem.class));
        boolean distinct = AstBuilder.isDistinct(context.setQuantifier());
        Expression expression = (Expression)this.visit((ParseTree)context.expression());
        StringLiteral separator = context.string() == null ? new StringLiteral(this.getLocation((ParserRuleContext)context), "") : (StringLiteral)this.visit((ParseTree)context.string());
        BooleanLiteral overflowError = new BooleanLiteral(this.getLocation((ParserRuleContext)context), "true");
        StringLiteral overflowFiller = new StringLiteral(this.getLocation((ParserRuleContext)context), "...");
        BooleanLiteral showOverflowEntryCount = new BooleanLiteral(this.getLocation((ParserRuleContext)context), "false");
        SqlBaseParser.ListAggOverflowBehaviorContext overflowBehavior = context.listAggOverflowBehavior();
        if (overflowBehavior != null) {
            if (overflowBehavior.ERROR() != null) {
                overflowError = new BooleanLiteral(this.getLocation((ParserRuleContext)context), "true");
            } else if (overflowBehavior.TRUNCATE() != null) {
                SqlBaseParser.ListaggCountIndicationContext listaggCountIndicationContext;
                overflowError = new BooleanLiteral(this.getLocation((ParserRuleContext)context), "false");
                if (overflowBehavior.string() != null) {
                    overflowFiller = (StringLiteral)this.visit((ParseTree)overflowBehavior.string());
                }
                if ((listaggCountIndicationContext = overflowBehavior.listaggCountIndication()).WITH() != null) {
                    showOverflowEntryCount = new BooleanLiteral(this.getLocation((ParserRuleContext)context), "true");
                } else if (listaggCountIndicationContext.WITHOUT() != null) {
                    showOverflowEntryCount = new BooleanLiteral(this.getLocation((ParserRuleContext)context), "false");
                }
            }
        }
        ImmutableList arguments = ImmutableList.of((Object)expression, (Object)separator, (Object)overflowError, (Object)overflowFiller, (Object)showOverflowEntryCount);
        return new FunctionCall(Optional.of(this.getLocation((ParserRuleContext)context)), QualifiedName.of("LISTAGG"), window, this.visitIfPresent((ParserRuleContext)context.filter(), Expression.class), Optional.of(orderBy), distinct, Optional.empty(), Optional.empty(), (List<Expression>)arguments);
    }

    public Node visitTrim(SqlBaseParser.TrimContext context) {
        if (context.FROM() != null && context.trimsSpecification() == null && context.trimChar == null) {
            throw AstBuilder.parseError("The 'trim' function must have specification, char or both arguments when it takes FROM", (ParserRuleContext)context);
        }
        Trim.Specification specification = context.trimsSpecification() == null ? Trim.Specification.BOTH : AstBuilder.toTrimSpecification((Token)context.trimsSpecification().getChild(0).getPayload());
        return new Trim(this.getLocation((ParserRuleContext)context), specification, (Expression)this.visit((ParseTree)context.trimSource), this.visitIfPresent((ParserRuleContext)context.trimChar, Expression.class));
    }

    private static Trim.Specification toTrimSpecification(Token token) {
        return switch (token.getType()) {
            case 35 -> Trim.Specification.BOTH;
            case 150 -> Trim.Specification.LEADING;
            case 270 -> Trim.Specification.TRAILING;
            default -> throw new IllegalArgumentException("Unsupported trim specification: " + token.getText());
        };
    }

    public Node visitJsonExists(SqlBaseParser.JsonExistsContext context) {
        JsonExists.ErrorBehavior errorBehavior;
        JsonPathInvocation jsonPathInvocation = (JsonPathInvocation)this.visit((ParseTree)context.jsonPathInvocation());
        SqlBaseParser.JsonExistsErrorBehaviorContext errorBehaviorContext = context.jsonExistsErrorBehavior();
        if (errorBehaviorContext == null || errorBehaviorContext.FALSE() != null) {
            errorBehavior = JsonExists.ErrorBehavior.FALSE;
        } else if (errorBehaviorContext.TRUE() != null) {
            errorBehavior = JsonExists.ErrorBehavior.TRUE;
        } else if (errorBehaviorContext.UNKNOWN() != null) {
            errorBehavior = JsonExists.ErrorBehavior.UNKNOWN;
        } else if (errorBehaviorContext.ERROR() != null) {
            errorBehavior = JsonExists.ErrorBehavior.ERROR;
        } else {
            throw AstBuilder.parseError("Unexpected error behavior: " + errorBehaviorContext.getText(), (ParserRuleContext)errorBehaviorContext);
        }
        return new JsonExists(Optional.of(this.getLocation((ParserRuleContext)context)), jsonPathInvocation, errorBehavior);
    }

    public Node visitJsonValue(SqlBaseParser.JsonValueContext context) {
        JsonValue.EmptyOrErrorBehavior errorBehavior;
        JsonValue.EmptyOrErrorBehavior emptyBehavior;
        JsonPathInvocation jsonPathInvocation = (JsonPathInvocation)this.visit((ParseTree)context.jsonPathInvocation());
        Optional<DataType> returnedType = this.visitIfPresent((ParserRuleContext)context.type(), DataType.class);
        SqlBaseParser.JsonValueBehaviorContext emptyBehaviorContext = context.emptyBehavior;
        Optional<Expression> emptyDefault = Optional.empty();
        if (emptyBehaviorContext == null || emptyBehaviorContext.NULL() != null) {
            emptyBehavior = JsonValue.EmptyOrErrorBehavior.NULL;
        } else if (emptyBehaviorContext.ERROR() != null) {
            emptyBehavior = JsonValue.EmptyOrErrorBehavior.ERROR;
        } else if (emptyBehaviorContext.DEFAULT() != null) {
            emptyBehavior = JsonValue.EmptyOrErrorBehavior.DEFAULT;
            emptyDefault = this.visitIfPresent((ParserRuleContext)emptyBehaviorContext.expression(), Expression.class);
        } else {
            throw AstBuilder.parseError("Unexpected empty behavior: " + emptyBehaviorContext.getText(), (ParserRuleContext)emptyBehaviorContext);
        }
        SqlBaseParser.JsonValueBehaviorContext errorBehaviorContext = context.errorBehavior;
        Optional<Expression> errorDefault = Optional.empty();
        if (errorBehaviorContext == null || errorBehaviorContext.NULL() != null) {
            errorBehavior = JsonValue.EmptyOrErrorBehavior.NULL;
        } else if (errorBehaviorContext.ERROR() != null) {
            errorBehavior = JsonValue.EmptyOrErrorBehavior.ERROR;
        } else if (errorBehaviorContext.DEFAULT() != null) {
            errorBehavior = JsonValue.EmptyOrErrorBehavior.DEFAULT;
            errorDefault = this.visitIfPresent((ParserRuleContext)errorBehaviorContext.expression(), Expression.class);
        } else {
            throw AstBuilder.parseError("Unexpected error behavior: " + errorBehaviorContext.getText(), (ParserRuleContext)errorBehaviorContext);
        }
        return new JsonValue(Optional.of(this.getLocation((ParserRuleContext)context)), jsonPathInvocation, returnedType, emptyBehavior, emptyDefault, errorBehavior, errorDefault);
    }

    public Node visitJsonQuery(SqlBaseParser.JsonQueryContext context) {
        JsonQuery.EmptyOrErrorBehavior errorBehavior;
        JsonQuery.EmptyOrErrorBehavior emptyBehavior;
        SqlBaseParser.JsonQueryWrapperBehaviorContext wrapperBehaviorContext;
        JsonPathInvocation jsonPathInvocation = (JsonPathInvocation)this.visit((ParseTree)context.jsonPathInvocation());
        Optional<DataType> returnedType = this.visitIfPresent((ParserRuleContext)context.type(), DataType.class);
        Optional<JsonPathParameter.JsonFormat> jsonOutputFormat = Optional.empty();
        if (context.FORMAT() != null) {
            jsonOutputFormat = Optional.of(this.getJsonFormat(context.jsonRepresentation()));
        }
        JsonQuery.ArrayWrapperBehavior wrapperBehavior = (wrapperBehaviorContext = context.jsonQueryWrapperBehavior()) == null || wrapperBehaviorContext.WITHOUT() != null ? JsonQuery.ArrayWrapperBehavior.WITHOUT : (wrapperBehaviorContext.CONDITIONAL() != null ? JsonQuery.ArrayWrapperBehavior.CONDITIONAL : JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL);
        Optional<JsonQuery.QuotesBehavior> quotesBehavior = Optional.empty();
        if (context.KEEP() != null) {
            quotesBehavior = Optional.of(JsonQuery.QuotesBehavior.KEEP);
        } else if (context.OMIT() != null) {
            quotesBehavior = Optional.of(JsonQuery.QuotesBehavior.OMIT);
        }
        SqlBaseParser.JsonQueryBehaviorContext emptyBehaviorContext = context.emptyBehavior;
        if (emptyBehaviorContext == null || emptyBehaviorContext.NULL() != null) {
            emptyBehavior = JsonQuery.EmptyOrErrorBehavior.NULL;
        } else if (emptyBehaviorContext.ERROR() != null) {
            emptyBehavior = JsonQuery.EmptyOrErrorBehavior.ERROR;
        } else if (emptyBehaviorContext.ARRAY() != null) {
            emptyBehavior = JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY;
        } else if (emptyBehaviorContext.OBJECT() != null) {
            emptyBehavior = JsonQuery.EmptyOrErrorBehavior.EMPTY_OBJECT;
        } else {
            throw AstBuilder.parseError("Unexpected empty behavior: " + emptyBehaviorContext.getText(), (ParserRuleContext)emptyBehaviorContext);
        }
        SqlBaseParser.JsonQueryBehaviorContext errorBehaviorContext = context.errorBehavior;
        if (errorBehaviorContext == null || errorBehaviorContext.NULL() != null) {
            errorBehavior = JsonQuery.EmptyOrErrorBehavior.NULL;
        } else if (errorBehaviorContext.ERROR() != null) {
            errorBehavior = JsonQuery.EmptyOrErrorBehavior.ERROR;
        } else if (errorBehaviorContext.ARRAY() != null) {
            errorBehavior = JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY;
        } else if (errorBehaviorContext.OBJECT() != null) {
            errorBehavior = JsonQuery.EmptyOrErrorBehavior.EMPTY_OBJECT;
        } else {
            throw AstBuilder.parseError("Unexpected error behavior: " + errorBehaviorContext.getText(), (ParserRuleContext)errorBehaviorContext);
        }
        return new JsonQuery(Optional.of(this.getLocation((ParserRuleContext)context)), jsonPathInvocation, returnedType, jsonOutputFormat, wrapperBehavior, quotesBehavior, emptyBehavior, errorBehavior);
    }

    public Node visitJsonPathInvocation(SqlBaseParser.JsonPathInvocationContext context) {
        Expression jsonInput = (Expression)this.visit((ParseTree)context.jsonValueExpression().expression());
        JsonPathParameter.JsonFormat inputFormat = context.jsonValueExpression().FORMAT() == null ? JsonPathParameter.JsonFormat.JSON : this.getJsonFormat(context.jsonValueExpression().jsonRepresentation());
        StringLiteral jsonPath = (StringLiteral)this.visit((ParseTree)context.path);
        Optional<Identifier> pathName = this.visitIfPresent((ParserRuleContext)context.pathName, Identifier.class);
        List<JsonPathParameter> pathParameters = this.visit(context.jsonArgument(), JsonPathParameter.class);
        return new JsonPathInvocation(Optional.of(this.getLocation((ParserRuleContext)context)), jsonInput, inputFormat, jsonPath, pathName, pathParameters);
    }

    private JsonPathParameter.JsonFormat getJsonFormat(SqlBaseParser.JsonRepresentationContext context) {
        if (context.UTF8() != null) {
            return JsonPathParameter.JsonFormat.UTF8;
        }
        if (context.UTF16() != null) {
            return JsonPathParameter.JsonFormat.UTF16;
        }
        if (context.UTF32() != null) {
            return JsonPathParameter.JsonFormat.UTF32;
        }
        return JsonPathParameter.JsonFormat.JSON;
    }

    public Node visitJsonArgument(SqlBaseParser.JsonArgumentContext context) {
        return new JsonPathParameter(Optional.of(this.getLocation((ParserRuleContext)context)), (Identifier)this.visit((ParseTree)context.identifier()), (Expression)this.visit((ParseTree)context.jsonValueExpression().expression()), Optional.ofNullable(context.jsonValueExpression().jsonRepresentation()).map(this::getJsonFormat));
    }

    public Node visitJsonObject(SqlBaseParser.JsonObjectContext context) {
        List<JsonObjectMember> members = this.visit(context.jsonObjectMember(), JsonObjectMember.class);
        boolean nullOnNull = true;
        if (context.ABSENT() != null) {
            nullOnNull = false;
        }
        boolean uniqueKeys = false;
        if (context.WITH() != null) {
            uniqueKeys = true;
        }
        Optional<DataType> returnedType = this.visitIfPresent((ParserRuleContext)context.type(), DataType.class);
        Optional<JsonPathParameter.JsonFormat> jsonOutputFormat = Optional.empty();
        if (context.FORMAT() != null) {
            jsonOutputFormat = Optional.of(this.getJsonFormat(context.jsonRepresentation()));
        }
        return new JsonObject(Optional.of(this.getLocation((ParserRuleContext)context)), members, nullOnNull, uniqueKeys, returnedType, jsonOutputFormat);
    }

    public Node visitJsonObjectMember(SqlBaseParser.JsonObjectMemberContext context) {
        return new JsonObjectMember(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), (Expression)this.visit((ParseTree)context.jsonValueExpression().expression()), Optional.ofNullable(context.jsonValueExpression().jsonRepresentation()).map(this::getJsonFormat));
    }

    public Node visitJsonArray(SqlBaseParser.JsonArrayContext context) {
        List<JsonArrayElement> elements = this.visit(context.jsonValueExpression(), JsonArrayElement.class);
        boolean nullOnNull = false;
        if (context.NULL(0) != null && context.NULL(1) != null) {
            nullOnNull = true;
        }
        Optional<DataType> returnedType = this.visitIfPresent((ParserRuleContext)context.type(), DataType.class);
        Optional<JsonPathParameter.JsonFormat> jsonOutputFormat = Optional.empty();
        if (context.FORMAT() != null) {
            jsonOutputFormat = Optional.of(this.getJsonFormat(context.jsonRepresentation()));
        }
        return new JsonArray(Optional.of(this.getLocation((ParserRuleContext)context)), elements, nullOnNull, returnedType, jsonOutputFormat);
    }

    public Node visitJsonValueExpression(SqlBaseParser.JsonValueExpressionContext context) {
        return new JsonArrayElement(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), Optional.ofNullable(context.jsonRepresentation()).map(this::getJsonFormat));
    }

    public Node visitSubstring(SqlBaseParser.SubstringContext context) {
        return new FunctionCall(this.getLocation((ParserRuleContext)context), QualifiedName.of("substr"), this.visit(context.valueExpression(), Expression.class));
    }

    public Node visitPosition(SqlBaseParser.PositionContext context) {
        List arguments = Lists.reverse(this.visit(context.valueExpression(), Expression.class));
        return new FunctionCall(this.getLocation((ParserRuleContext)context), QualifiedName.of("strpos"), arguments);
    }

    public Node visitNormalize(SqlBaseParser.NormalizeContext context) {
        Expression str = (Expression)this.visit((ParseTree)context.valueExpression());
        String normalForm = Optional.ofNullable(context.normalForm()).map(RuleContext::getText).orElse("NFC");
        return new FunctionCall(this.getLocation((ParserRuleContext)context), QualifiedName.of((Iterable<Identifier>)ImmutableList.of((Object)new Identifier("normalize", true))), (List<Expression>)ImmutableList.of((Object)str, (Object)new StringLiteral(this.getLocation((ParserRuleContext)context), normalForm)));
    }

    public Node visitSubscript(SqlBaseParser.SubscriptContext context) {
        return new SubscriptExpression(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.value), (Expression)this.visit((ParseTree)context.index));
    }

    public Node visitSubqueryExpression(SqlBaseParser.SubqueryExpressionContext context) {
        return new SubqueryExpression(this.getLocation((ParserRuleContext)context), (Query)this.visit((ParseTree)context.query()));
    }

    public Node visitDereference(SqlBaseParser.DereferenceContext context) {
        return new DereferenceExpression(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.base), (Identifier)this.visit((ParseTree)context.fieldName));
    }

    public Node visitColumnReference(SqlBaseParser.ColumnReferenceContext context) {
        return (Node)this.visit((ParseTree)context.identifier());
    }

    public Node visitSimpleCase(SqlBaseParser.SimpleCaseContext context) {
        return new SimpleCaseExpression(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.operand), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent((ParserRuleContext)context.elseExpression, Expression.class));
    }

    public Node visitSearchedCase(SqlBaseParser.SearchedCaseContext context) {
        return new SearchedCaseExpression(this.getLocation((ParserRuleContext)context), this.visit(context.whenClause(), WhenClause.class), this.visitIfPresent((ParserRuleContext)context.elseExpression, Expression.class));
    }

    public Node visitWhenClause(SqlBaseParser.WhenClauseContext context) {
        return new WhenClause(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.condition), (Expression)this.visit((ParseTree)context.result));
    }

    public Node visitFunctionCall(SqlBaseParser.FunctionCallContext context) {
        Optional<Expression> filter = this.visitIfPresent((ParserRuleContext)context.filter(), Expression.class);
        Optional<Window> window = this.visitIfPresent((ParserRuleContext)context.over(), Window.class);
        Optional<OrderBy> orderBy = Optional.empty();
        if (context.ORDER() != null) {
            orderBy = Optional.of(new OrderBy(this.visit(context.sortItem(), SortItem.class)));
        }
        QualifiedName name = this.getQualifiedName(context.qualifiedName());
        boolean distinct = AstBuilder.isDistinct(context.setQuantifier());
        SqlBaseParser.NullTreatmentContext nullTreatment = context.nullTreatment();
        SqlBaseParser.ProcessingModeContext processingMode = context.processingMode();
        if (name.toString().equalsIgnoreCase("if")) {
            AstBuilder.check(context.expression().size() == 2 || context.expression().size() == 3, "Invalid number of arguments for 'if' function", (ParserRuleContext)context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'if' function", (ParserRuleContext)context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'if' function", (ParserRuleContext)context);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for 'if' function", (ParserRuleContext)context);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for 'if' function", (ParserRuleContext)context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'if' function", (ParserRuleContext)context);
            Expression elseExpression = null;
            if (context.expression().size() == 3) {
                elseExpression = (Expression)this.visit((ParseTree)context.expression(2));
            }
            return new IfExpression(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)), elseExpression);
        }
        if (name.toString().equalsIgnoreCase("nullif")) {
            AstBuilder.check(context.expression().size() == 2, "Invalid number of arguments for 'nullif' function", (ParserRuleContext)context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'nullif' function", (ParserRuleContext)context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'nullif' function", (ParserRuleContext)context);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for 'nullif' function", (ParserRuleContext)context);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for 'nullif' function", (ParserRuleContext)context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'nullif' function", (ParserRuleContext)context);
            return new NullIfExpression(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression(0)), (Expression)this.visit((ParseTree)context.expression(1)));
        }
        if (name.toString().equalsIgnoreCase("coalesce")) {
            AstBuilder.check(context.expression().size() >= 2, "The 'coalesce' function must have at least two arguments", (ParserRuleContext)context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'coalesce' function", (ParserRuleContext)context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'coalesce' function", (ParserRuleContext)context);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for 'coalesce' function", (ParserRuleContext)context);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for 'coalesce' function", (ParserRuleContext)context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'coalesce' function", (ParserRuleContext)context);
            return new CoalesceExpression(this.getLocation((ParserRuleContext)context), this.visit(context.expression(), Expression.class));
        }
        if (name.toString().equalsIgnoreCase("try")) {
            AstBuilder.check(context.expression().size() == 1, "The 'try' function must have exactly one argument", (ParserRuleContext)context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'try' function", (ParserRuleContext)context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'try' function", (ParserRuleContext)context);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for 'try' function", (ParserRuleContext)context);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for 'try' function", (ParserRuleContext)context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'try' function", (ParserRuleContext)context);
            return new TryExpression(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)Iterables.getOnlyElement((Iterable)context.expression())));
        }
        if (name.toString().equalsIgnoreCase("format")) {
            AstBuilder.check(context.expression().size() >= 2, "The 'format' function must have at least two arguments", (ParserRuleContext)context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for 'format' function", (ParserRuleContext)context);
            AstBuilder.check(!distinct, "DISTINCT not valid for 'format' function", (ParserRuleContext)context);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for 'format' function", (ParserRuleContext)context);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for 'format' function", (ParserRuleContext)context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for 'format' function", (ParserRuleContext)context);
            return new Format(this.getLocation((ParserRuleContext)context), this.visit(context.expression(), Expression.class));
        }
        if (name.toString().equalsIgnoreCase("$internal$bind")) {
            AstBuilder.check(context.expression().size() >= 1, "The '$internal$bind' function must have at least one argument", (ParserRuleContext)context);
            AstBuilder.check(!window.isPresent(), "OVER clause not valid for '$internal$bind' function", (ParserRuleContext)context);
            AstBuilder.check(!distinct, "DISTINCT not valid for '$internal$bind' function", (ParserRuleContext)context);
            AstBuilder.check(nullTreatment == null, "Null treatment clause not valid for '$internal$bind' function", (ParserRuleContext)context);
            AstBuilder.check(processingMode == null, "Running or final semantics not valid for '$internal$bind' function", (ParserRuleContext)context);
            AstBuilder.check(!filter.isPresent(), "FILTER not valid for '$internal$bind' function", (ParserRuleContext)context);
            int numValues = context.expression().size() - 1;
            List arguments = (List)context.expression().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(Expression.class::cast).collect(ImmutableList.toImmutableList());
            return new BindExpression(this.getLocation((ParserRuleContext)context), arguments.subList(0, numValues), (Expression)arguments.get(numValues));
        }
        Optional<FunctionCall.NullTreatment> nulls = Optional.empty();
        if (nullTreatment != null) {
            if (nullTreatment.IGNORE() != null) {
                nulls = Optional.of(FunctionCall.NullTreatment.IGNORE);
            } else if (nullTreatment.RESPECT() != null) {
                nulls = Optional.of(FunctionCall.NullTreatment.RESPECT);
            }
        }
        Optional<ProcessingMode> mode = Optional.empty();
        if (processingMode != null) {
            if (processingMode.RUNNING() != null) {
                mode = Optional.of(new ProcessingMode(this.getLocation((ParserRuleContext)processingMode), ProcessingMode.Mode.RUNNING));
            } else if (processingMode.FINAL() != null) {
                mode = Optional.of(new ProcessingMode(this.getLocation((ParserRuleContext)processingMode), ProcessingMode.Mode.FINAL));
            }
        }
        ImmutableList arguments = this.visit(context.expression(), Expression.class);
        if (context.label != null) {
            arguments = ImmutableList.of((Object)new DereferenceExpression(this.getLocation((ParserRuleContext)context.label), (Identifier)this.visit((ParseTree)context.label)));
        }
        return new FunctionCall(Optional.of(this.getLocation((ParserRuleContext)context)), name, window, filter, orderBy, distinct, nulls, mode, (List<Expression>)arguments);
    }

    public Node visitMeasure(SqlBaseParser.MeasureContext context) {
        return new WindowOperation(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (Window)this.visit((ParseTree)context.over()));
    }

    public Node visitLambda(SqlBaseParser.LambdaContext context) {
        List<LambdaArgumentDeclaration> arguments = this.visit(context.identifier(), Identifier.class).stream().map(LambdaArgumentDeclaration::new).collect(Collectors.toList());
        Expression body = (Expression)this.visit((ParseTree)context.expression());
        return new LambdaExpression(this.getLocation((ParserRuleContext)context), arguments, body);
    }

    public Node visitFilter(SqlBaseParser.FilterContext context) {
        return (Node)this.visit((ParseTree)context.booleanExpression());
    }

    public Node visitOver(SqlBaseParser.OverContext context) {
        if (context.windowName != null) {
            return new WindowReference(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.windowName));
        }
        return (Node)this.visit((ParseTree)context.windowSpecification());
    }

    public Node visitColumnDefinition(SqlBaseParser.ColumnDefinitionContext context) {
        Optional<String> comment = Optional.empty();
        if (context.COMMENT() != null) {
            comment = Optional.of(((StringLiteral)this.visit((ParseTree)context.string())).getValue());
        }
        Object properties = ImmutableList.of();
        if (context.properties() != null) {
            properties = this.visit(context.properties().propertyAssignments().property(), Property.class);
        }
        boolean nullable = context.NOT() == null;
        return new ColumnDefinition(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), (DataType)this.visit((ParseTree)context.type()), nullable, (List<Property>)properties, comment);
    }

    public Node visitLikeClause(SqlBaseParser.LikeClauseContext context) {
        return new LikeClause(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.qualifiedName()), Optional.ofNullable(context.optionType).map(AstBuilder::getPropertiesOption));
    }

    public Node visitSortItem(SqlBaseParser.SortItemContext context) {
        return new SortItem(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), Optional.ofNullable(context.ordering).map(AstBuilder::getOrderingType).orElse(SortItem.Ordering.ASCENDING), Optional.ofNullable(context.nullOrdering).map(AstBuilder::getNullOrderingType).orElse(SortItem.NullOrdering.UNDEFINED));
    }

    public Node visitWindowFrame(SqlBaseParser.WindowFrameContext context) {
        Optional<PatternSearchMode> searchMode = Optional.empty();
        if (context.INITIAL() != null) {
            searchMode = Optional.of(new PatternSearchMode(this.getLocation(context.INITIAL()), PatternSearchMode.Mode.INITIAL));
        } else if (context.SEEK() != null) {
            searchMode = Optional.of(new PatternSearchMode(this.getLocation(context.SEEK()), PatternSearchMode.Mode.SEEK));
        }
        return new WindowFrame(this.getLocation((ParserRuleContext)context), AstBuilder.getFrameType(context.frameExtent().frameType), (FrameBound)this.visit((ParseTree)context.frameExtent().start), this.visitIfPresent((ParserRuleContext)context.frameExtent().end, FrameBound.class), this.visit(context.measureDefinition(), MeasureDefinition.class), this.visitIfPresent((ParserRuleContext)context.skipTo(), SkipTo.class), searchMode, this.visitIfPresent((ParserRuleContext)context.rowPattern(), RowPattern.class), this.visit(context.subsetDefinition(), SubsetDefinition.class), this.visit(context.variableDefinition(), VariableDefinition.class));
    }

    public Node visitUnboundedFrame(SqlBaseParser.UnboundedFrameContext context) {
        return new FrameBound(this.getLocation((ParserRuleContext)context), AstBuilder.getUnboundedFrameBoundType(context.boundType));
    }

    public Node visitBoundedFrame(SqlBaseParser.BoundedFrameContext context) {
        return new FrameBound(this.getLocation((ParserRuleContext)context), AstBuilder.getBoundedFrameBoundType(context.boundType), (Expression)this.visit((ParseTree)context.expression()));
    }

    public Node visitCurrentRowBound(SqlBaseParser.CurrentRowBoundContext context) {
        return new FrameBound(this.getLocation((ParserRuleContext)context), FrameBound.Type.CURRENT_ROW);
    }

    public Node visitGroupingOperation(SqlBaseParser.GroupingOperationContext context) {
        List<QualifiedName> arguments = context.qualifiedName().stream().map(this::getQualifiedName).collect(Collectors.toList());
        return new GroupingOperation(Optional.of(this.getLocation((ParserRuleContext)context)), arguments);
    }

    public Node visitUnquotedIdentifier(SqlBaseParser.UnquotedIdentifierContext context) {
        return new Identifier(this.getLocation((ParserRuleContext)context), context.getText(), false);
    }

    public Node visitQuotedIdentifier(SqlBaseParser.QuotedIdentifierContext context) {
        String token = context.getText();
        String identifier = token.substring(1, token.length() - 1).replace("\"\"", "\"");
        return new Identifier(this.getLocation((ParserRuleContext)context), identifier, true);
    }

    public Node visitPatternAlternation(SqlBaseParser.PatternAlternationContext context) {
        List<RowPattern> parts = this.visit(context.rowPattern(), RowPattern.class);
        return new PatternAlternation(this.getLocation((ParserRuleContext)context), parts);
    }

    public Node visitPatternConcatenation(SqlBaseParser.PatternConcatenationContext context) {
        List<RowPattern> parts = this.visit(context.rowPattern(), RowPattern.class);
        return new PatternConcatenation(this.getLocation((ParserRuleContext)context), parts);
    }

    public Node visitQuantifiedPrimary(SqlBaseParser.QuantifiedPrimaryContext context) {
        RowPattern primary = (RowPattern)this.visit((ParseTree)context.patternPrimary());
        if (context.patternQuantifier() != null) {
            return new QuantifiedPattern(this.getLocation((ParserRuleContext)context), primary, (PatternQuantifier)this.visit((ParseTree)context.patternQuantifier()));
        }
        return primary;
    }

    public Node visitPatternVariable(SqlBaseParser.PatternVariableContext context) {
        return new PatternVariable(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitEmptyPattern(SqlBaseParser.EmptyPatternContext context) {
        return new EmptyPattern(this.getLocation((ParserRuleContext)context));
    }

    public Node visitPatternPermutation(SqlBaseParser.PatternPermutationContext context) {
        return new PatternPermutation(this.getLocation((ParserRuleContext)context), this.visit(context.rowPattern(), RowPattern.class));
    }

    public Node visitGroupedPattern(SqlBaseParser.GroupedPatternContext context) {
        return (Node)this.visit((ParseTree)context.rowPattern());
    }

    public Node visitPartitionStartAnchor(SqlBaseParser.PartitionStartAnchorContext context) {
        return new AnchorPattern(this.getLocation((ParserRuleContext)context), AnchorPattern.Type.PARTITION_START);
    }

    public Node visitPartitionEndAnchor(SqlBaseParser.PartitionEndAnchorContext context) {
        return new AnchorPattern(this.getLocation((ParserRuleContext)context), AnchorPattern.Type.PARTITION_END);
    }

    public Node visitExcludedPattern(SqlBaseParser.ExcludedPatternContext context) {
        return new ExcludedPattern(this.getLocation((ParserRuleContext)context), (RowPattern)this.visit((ParseTree)context.rowPattern()));
    }

    public Node visitZeroOrMoreQuantifier(SqlBaseParser.ZeroOrMoreQuantifierContext context) {
        boolean greedy = context.reluctant == null;
        return new ZeroOrMoreQuantifier(this.getLocation((ParserRuleContext)context), greedy);
    }

    public Node visitOneOrMoreQuantifier(SqlBaseParser.OneOrMoreQuantifierContext context) {
        boolean greedy = context.reluctant == null;
        return new OneOrMoreQuantifier(this.getLocation((ParserRuleContext)context), greedy);
    }

    public Node visitZeroOrOneQuantifier(SqlBaseParser.ZeroOrOneQuantifierContext context) {
        boolean greedy = context.reluctant == null;
        return new ZeroOrOneQuantifier(this.getLocation((ParserRuleContext)context), greedy);
    }

    public Node visitRangeQuantifier(SqlBaseParser.RangeQuantifierContext context) {
        boolean greedy = context.reluctant == null;
        Optional<Object> atLeast = Optional.empty();
        Optional<LongLiteral> atMost = Optional.empty();
        if (context.exactly != null) {
            atLeast = Optional.of(new LongLiteral(this.getLocation(context.exactly), context.exactly.getText()));
            atMost = Optional.of(new LongLiteral(this.getLocation(context.exactly), context.exactly.getText()));
        }
        if (context.atLeast != null) {
            atLeast = Optional.of(new LongLiteral(this.getLocation(context.atLeast), context.atLeast.getText()));
        }
        if (context.atMost != null) {
            atMost = Optional.of(new LongLiteral(this.getLocation(context.atMost), context.atMost.getText()));
        }
        return new RangeQuantifier(this.getLocation((ParserRuleContext)context), greedy, atLeast, atMost);
    }

    public Node visitNullLiteral(SqlBaseParser.NullLiteralContext context) {
        return new NullLiteral(this.getLocation((ParserRuleContext)context));
    }

    public Node visitBasicStringLiteral(SqlBaseParser.BasicStringLiteralContext context) {
        return new StringLiteral(this.getLocation((ParserRuleContext)context), AstBuilder.unquote(context.STRING().getText()));
    }

    public Node visitUnicodeStringLiteral(SqlBaseParser.UnicodeStringLiteralContext context) {
        return new StringLiteral(this.getLocation((ParserRuleContext)context), AstBuilder.decodeUnicodeLiteral(context));
    }

    public Node visitBinaryLiteral(SqlBaseParser.BinaryLiteralContext context) {
        String raw = context.BINARY_LITERAL().getText();
        return new BinaryLiteral(this.getLocation((ParserRuleContext)context), AstBuilder.unquote(raw.substring(1)));
    }

    public Node visitTypeConstructor(SqlBaseParser.TypeConstructorContext context) {
        String value = ((StringLiteral)this.visit((ParseTree)context.string())).getValue();
        if (context.DOUBLE() != null) {
            return new GenericLiteral(this.getLocation((ParserRuleContext)context), "DOUBLE", value);
        }
        String type = context.identifier().getText();
        if (type.equalsIgnoreCase("time")) {
            return new TimeLiteral(this.getLocation((ParserRuleContext)context), value);
        }
        if (type.equalsIgnoreCase("timestamp")) {
            return new TimestampLiteral(this.getLocation((ParserRuleContext)context), value);
        }
        if (type.equalsIgnoreCase("decimal")) {
            return new DecimalLiteral(this.getLocation((ParserRuleContext)context), value);
        }
        if (type.equalsIgnoreCase("char")) {
            return new CharLiteral(this.getLocation((ParserRuleContext)context), value);
        }
        return new GenericLiteral(this.getLocation((ParserRuleContext)context), type, value);
    }

    public Node visitIntegerLiteral(SqlBaseParser.IntegerLiteralContext context) {
        return new LongLiteral(this.getLocation((ParserRuleContext)context), context.getText());
    }

    public Node visitDecimalLiteral(SqlBaseParser.DecimalLiteralContext context) {
        return new DecimalLiteral(this.getLocation((ParserRuleContext)context), context.getText());
    }

    public Node visitDoubleLiteral(SqlBaseParser.DoubleLiteralContext context) {
        return new DoubleLiteral(this.getLocation((ParserRuleContext)context), context.getText());
    }

    public Node visitBooleanValue(SqlBaseParser.BooleanValueContext context) {
        return new BooleanLiteral(this.getLocation((ParserRuleContext)context), context.getText());
    }

    public Node visitInterval(SqlBaseParser.IntervalContext context) {
        return new IntervalLiteral(this.getLocation((ParserRuleContext)context), ((StringLiteral)this.visit((ParseTree)context.string())).getValue(), Optional.ofNullable(context.sign).map(AstBuilder::getIntervalSign).orElse(IntervalLiteral.Sign.POSITIVE), AstBuilder.getIntervalFieldType((Token)context.from.getChild(0).getPayload()), Optional.ofNullable(context.to).map(x -> x.getChild(0).getPayload()).map(Token.class::cast).map(AstBuilder::getIntervalFieldType));
    }

    public Node visitParameter(SqlBaseParser.ParameterContext context) {
        Parameter parameter = new Parameter(this.getLocation((ParserRuleContext)context), this.parameterPosition);
        ++this.parameterPosition;
        return parameter;
    }

    public Node visitPositionalArgument(SqlBaseParser.PositionalArgumentContext context) {
        return new CallArgument(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()));
    }

    public Node visitNamedArgument(SqlBaseParser.NamedArgumentContext context) {
        return new CallArgument(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (Expression)this.visit((ParseTree)context.expression()));
    }

    public Node visitQualifiedArgument(SqlBaseParser.QualifiedArgumentContext context) {
        return new PathElement(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier(0)), (Identifier)this.visit((ParseTree)context.identifier(1)));
    }

    public Node visitUnqualifiedArgument(SqlBaseParser.UnqualifiedArgumentContext context) {
        return new PathElement(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitPathSpecification(SqlBaseParser.PathSpecificationContext context) {
        return new PathSpecification(this.getLocation((ParserRuleContext)context), this.visit(context.pathElement(), PathElement.class));
    }

    public Node visitRowType(SqlBaseParser.RowTypeContext context) {
        List fields = (List)context.rowField().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(RowDataType.Field.class::cast).collect(ImmutableList.toImmutableList());
        return new RowDataType(this.getLocation((ParserRuleContext)context), (List<RowDataType.Field>)fields);
    }

    public Node visitRowField(SqlBaseParser.RowFieldContext context) {
        return new RowDataType.Field(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.identifier(), Identifier.class), (DataType)this.visit((ParseTree)context.type()));
    }

    public Node visitGenericType(SqlBaseParser.GenericTypeContext context) {
        List parameters = (List)context.typeParameter().stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(DataTypeParameter.class::cast).collect(ImmutableList.toImmutableList());
        return new GenericDataType(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (List<DataTypeParameter>)parameters);
    }

    public Node visitTypeParameter(SqlBaseParser.TypeParameterContext context) {
        if (context.INTEGER_VALUE() != null) {
            return new NumericParameter(this.getLocation((ParserRuleContext)context), context.getText());
        }
        return new TypeParameter((DataType)this.visit((ParseTree)context.type()));
    }

    public Node visitIntervalType(SqlBaseParser.IntervalTypeContext context) {
        String from = context.from.getText();
        String to = AstBuilder.getTextIfPresent((ParserRuleContext)context.to).orElse(from);
        return new IntervalDayTimeDataType(this.getLocation((ParserRuleContext)context), IntervalDayTimeDataType.Field.valueOf(from.toUpperCase(Locale.ENGLISH)), IntervalDayTimeDataType.Field.valueOf(to.toUpperCase(Locale.ENGLISH)));
    }

    public Node visitDateTimeType(SqlBaseParser.DateTimeTypeContext context) {
        DateTimeDataType.Type type;
        if (context.base.getType() == 267) {
            type = DateTimeDataType.Type.TIME;
        } else if (context.base.getType() == 268) {
            type = DateTimeDataType.Type.TIMESTAMP;
        } else {
            throw new ParsingException("Unexpected datetime type: " + context.getText());
        }
        return new DateTimeDataType(this.getLocation((ParserRuleContext)context), type, context.WITH() != null, this.visitIfPresent((ParserRuleContext)context.precision, DataTypeParameter.class));
    }

    public Node visitDoublePrecisionType(SqlBaseParser.DoublePrecisionTypeContext context) {
        return new GenericDataType(this.getLocation((ParserRuleContext)context), new Identifier(this.getLocation(context.DOUBLE()), context.DOUBLE().getText(), false), (List<DataTypeParameter>)ImmutableList.of());
    }

    public Node visitLegacyArrayType(SqlBaseParser.LegacyArrayTypeContext context) {
        return new GenericDataType(this.getLocation((ParserRuleContext)context), new Identifier(this.getLocation(context.ARRAY()), context.ARRAY().getText(), false), (List<DataTypeParameter>)ImmutableList.of((Object)new TypeParameter((DataType)this.visit((ParseTree)context.type()))));
    }

    public Node visitLegacyMapType(SqlBaseParser.LegacyMapTypeContext context) {
        return new GenericDataType(this.getLocation((ParserRuleContext)context), new Identifier(this.getLocation(context.MAP()), context.MAP().getText(), false), (List<DataTypeParameter>)ImmutableList.of((Object)new TypeParameter((DataType)this.visit((ParseTree)context.keyType)), (Object)new TypeParameter((DataType)this.visit((ParseTree)context.valueType))));
    }

    public Node visitArrayType(SqlBaseParser.ArrayTypeContext context) {
        if (context.INTEGER_VALUE() != null) {
            throw new UnsupportedOperationException("Explicit array size not supported");
        }
        return new GenericDataType(this.getLocation((ParserRuleContext)context), new Identifier(this.getLocation(context.ARRAY()), context.ARRAY().getText(), false), (List<DataTypeParameter>)ImmutableList.of((Object)new TypeParameter((DataType)this.visit((ParseTree)context.type()))));
    }

    public Node visitQueryPeriod(SqlBaseParser.QueryPeriodContext context) {
        QueryPeriod.RangeType type = AstBuilder.getRangeType((Token)context.rangeType().getChild(0).getPayload());
        Expression marker = (Expression)this.visit((ParseTree)context.valueExpression());
        return new QueryPeriod(this.getLocation((ParserRuleContext)context), type, marker);
    }

    public Node visitJsonTable(SqlBaseParser.JsonTableContext context) {
        JsonPathInvocation jsonPathInvocation = (JsonPathInvocation)this.visit((ParseTree)context.jsonPathInvocation());
        List<JsonTableColumnDefinition> columns = this.visit(context.jsonTableColumn(), JsonTableColumnDefinition.class);
        Optional<JsonTablePlan> plan = this.visitIfPresent((ParserRuleContext)context.jsonTableSpecificPlan(), JsonTablePlan.class);
        if (!plan.isPresent()) {
            plan = this.visitIfPresent((ParserRuleContext)context.jsonTableDefaultPlan(), JsonTablePlan.class);
        }
        Optional<JsonTable.ErrorBehavior> errorBehavior = Optional.empty();
        if (context.EMPTY() != null) {
            errorBehavior = Optional.of(JsonTable.ErrorBehavior.EMPTY);
        } else if (context.ERROR(0) != null) {
            errorBehavior = Optional.of(JsonTable.ErrorBehavior.ERROR);
        }
        return new JsonTable(this.getLocation((ParserRuleContext)context), jsonPathInvocation, columns, plan, errorBehavior);
    }

    public Node visitOrdinalityColumn(SqlBaseParser.OrdinalityColumnContext context) {
        return new OrdinalityColumn(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitValueColumn(SqlBaseParser.ValueColumnContext context) {
        JsonValue.EmptyOrErrorBehavior emptyBehavior;
        Optional<Expression> emptyDefault = Optional.empty();
        SqlBaseParser.JsonValueBehaviorContext emptyBehaviorContext = context.emptyBehavior;
        if (emptyBehaviorContext == null || emptyBehaviorContext.NULL() != null) {
            emptyBehavior = JsonValue.EmptyOrErrorBehavior.NULL;
        } else if (emptyBehaviorContext.ERROR() != null) {
            emptyBehavior = JsonValue.EmptyOrErrorBehavior.ERROR;
        } else if (emptyBehaviorContext.DEFAULT() != null) {
            emptyBehavior = JsonValue.EmptyOrErrorBehavior.DEFAULT;
            emptyDefault = this.visitIfPresent((ParserRuleContext)emptyBehaviorContext.expression(), Expression.class);
        } else {
            throw new IllegalArgumentException("Unexpected empty behavior: " + emptyBehaviorContext.getText());
        }
        Optional<JsonValue.EmptyOrErrorBehavior> errorBehavior = Optional.empty();
        Optional<Expression> errorDefault = Optional.empty();
        SqlBaseParser.JsonValueBehaviorContext errorBehaviorContext = context.errorBehavior;
        if (errorBehaviorContext != null) {
            if (errorBehaviorContext.NULL() != null) {
                errorBehavior = Optional.of(JsonValue.EmptyOrErrorBehavior.NULL);
            } else if (errorBehaviorContext.ERROR() != null) {
                errorBehavior = Optional.of(JsonValue.EmptyOrErrorBehavior.ERROR);
            } else if (errorBehaviorContext.DEFAULT() != null) {
                errorBehavior = Optional.of(JsonValue.EmptyOrErrorBehavior.DEFAULT);
                errorDefault = this.visitIfPresent((ParserRuleContext)errorBehaviorContext.expression(), Expression.class);
            } else {
                throw new IllegalArgumentException("Unexpected error behavior: " + errorBehaviorContext.getText());
            }
        }
        return new ValueColumn(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (DataType)this.visit((ParseTree)context.type()), this.visitIfPresent((ParserRuleContext)context.string(), StringLiteral.class), emptyBehavior, emptyDefault, errorBehavior, errorDefault);
    }

    public Node visitQueryColumn(SqlBaseParser.QueryColumnContext context) {
        JsonQuery.EmptyOrErrorBehavior emptyBehavior;
        SqlBaseParser.JsonQueryWrapperBehaviorContext wrapperBehaviorContext = context.jsonQueryWrapperBehavior();
        JsonQuery.ArrayWrapperBehavior wrapperBehavior = wrapperBehaviorContext == null || wrapperBehaviorContext.WITHOUT() != null ? JsonQuery.ArrayWrapperBehavior.WITHOUT : (wrapperBehaviorContext.CONDITIONAL() != null ? JsonQuery.ArrayWrapperBehavior.CONDITIONAL : JsonQuery.ArrayWrapperBehavior.UNCONDITIONAL);
        Optional<JsonQuery.QuotesBehavior> quotesBehavior = Optional.empty();
        if (context.KEEP() != null) {
            quotesBehavior = Optional.of(JsonQuery.QuotesBehavior.KEEP);
        } else if (context.OMIT() != null) {
            quotesBehavior = Optional.of(JsonQuery.QuotesBehavior.OMIT);
        }
        SqlBaseParser.JsonQueryBehaviorContext emptyBehaviorContext = context.emptyBehavior;
        if (emptyBehaviorContext == null || emptyBehaviorContext.NULL() != null) {
            emptyBehavior = JsonQuery.EmptyOrErrorBehavior.NULL;
        } else if (emptyBehaviorContext.ERROR() != null) {
            emptyBehavior = JsonQuery.EmptyOrErrorBehavior.ERROR;
        } else if (emptyBehaviorContext.ARRAY() != null) {
            emptyBehavior = JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY;
        } else if (emptyBehaviorContext.OBJECT() != null) {
            emptyBehavior = JsonQuery.EmptyOrErrorBehavior.EMPTY_OBJECT;
        } else {
            throw new IllegalArgumentException("Unexpected empty behavior: " + emptyBehaviorContext.getText());
        }
        Optional<JsonQuery.EmptyOrErrorBehavior> errorBehavior = Optional.empty();
        SqlBaseParser.JsonQueryBehaviorContext errorBehaviorContext = context.errorBehavior;
        if (errorBehaviorContext != null) {
            if (errorBehaviorContext.NULL() != null) {
                errorBehavior = Optional.of(JsonQuery.EmptyOrErrorBehavior.NULL);
            } else if (errorBehaviorContext.ERROR() != null) {
                errorBehavior = Optional.of(JsonQuery.EmptyOrErrorBehavior.ERROR);
            } else if (errorBehaviorContext.ARRAY() != null) {
                errorBehavior = Optional.of(JsonQuery.EmptyOrErrorBehavior.EMPTY_ARRAY);
            } else if (errorBehaviorContext.OBJECT() != null) {
                errorBehavior = Optional.of(JsonQuery.EmptyOrErrorBehavior.EMPTY_OBJECT);
            } else {
                throw new IllegalArgumentException("Unexpected error behavior: " + errorBehaviorContext.getText());
            }
        }
        return new QueryColumn(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (DataType)this.visit((ParseTree)context.type()), this.getJsonFormat(context.jsonRepresentation()), this.visitIfPresent((ParserRuleContext)context.string(), StringLiteral.class), wrapperBehavior, quotesBehavior, emptyBehavior, errorBehavior);
    }

    public Node visitNestedColumns(SqlBaseParser.NestedColumnsContext context) {
        return new NestedColumns(this.getLocation((ParserRuleContext)context), (StringLiteral)this.visit((ParseTree)context.string()), this.visitIfPresent((ParserRuleContext)context.identifier(), Identifier.class), this.visit(context.jsonTableColumn(), JsonTableColumnDefinition.class));
    }

    public Node visitJoinPlan(SqlBaseParser.JoinPlanContext context) {
        JsonTablePlan.ParentChildPlanType type;
        if (context.OUTER() != null) {
            type = JsonTablePlan.ParentChildPlanType.OUTER;
        } else if (context.INNER() != null) {
            type = JsonTablePlan.ParentChildPlanType.INNER;
        } else {
            throw new IllegalArgumentException("Unexpected parent-child type: " + context.getText());
        }
        return new PlanParentChild(this.getLocation((ParserRuleContext)context), type, (PlanLeaf)this.visit((ParseTree)context.jsonTablePathName()), (JsonTableSpecificPlan)this.visit((ParseTree)context.planPrimary()));
    }

    public Node visitUnionPlan(SqlBaseParser.UnionPlanContext context) {
        return new PlanSiblings(this.getLocation((ParserRuleContext)context), JsonTablePlan.SiblingsPlanType.UNION, this.visit(context.planPrimary(), JsonTableSpecificPlan.class));
    }

    public Node visitCrossPlan(SqlBaseParser.CrossPlanContext context) {
        return new PlanSiblings(this.getLocation((ParserRuleContext)context), JsonTablePlan.SiblingsPlanType.CROSS, this.visit(context.planPrimary(), JsonTableSpecificPlan.class));
    }

    public Node visitJsonTablePathName(SqlBaseParser.JsonTablePathNameContext context) {
        return new PlanLeaf(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitPlanPrimary(SqlBaseParser.PlanPrimaryContext context) {
        if (context.jsonTablePathName() != null) {
            return (Node)this.visit((ParseTree)context.jsonTablePathName());
        }
        return (Node)this.visit((ParseTree)context.jsonTableSpecificPlan());
    }

    public Node visitJsonTableDefaultPlan(SqlBaseParser.JsonTableDefaultPlanContext context) {
        JsonTablePlan.ParentChildPlanType parentChildPlanType = JsonTablePlan.ParentChildPlanType.OUTER;
        if (context.INNER() != null) {
            parentChildPlanType = JsonTablePlan.ParentChildPlanType.INNER;
        }
        JsonTablePlan.SiblingsPlanType siblingsPlanType = JsonTablePlan.SiblingsPlanType.UNION;
        if (context.CROSS() != null) {
            siblingsPlanType = JsonTablePlan.SiblingsPlanType.CROSS;
        }
        return new JsonTableDefaultPlan(this.getLocation((ParserRuleContext)context), parentChildPlanType, siblingsPlanType);
    }

    public Node visitFunctionSpecification(SqlBaseParser.FunctionSpecificationContext context) {
        ControlStatement statement = (ControlStatement)this.visit((ParseTree)context.controlStatement());
        if (!(statement instanceof ReturnStatement) && !(statement instanceof CompoundStatement)) {
            throw AstBuilder.parseError("Function body must start with RETURN or BEGIN", (ParserRuleContext)context.controlStatement());
        }
        return new FunctionSpecification(this.getLocation((ParserRuleContext)context), this.getQualifiedName(context.functionDeclaration().qualifiedName()), this.visit(context.functionDeclaration().parameterDeclaration(), ParameterDeclaration.class), (ReturnsClause)this.visit((ParseTree)context.returnsClause()), this.visit(context.routineCharacteristic(), RoutineCharacteristic.class), statement);
    }

    public Node visitParameterDeclaration(SqlBaseParser.ParameterDeclarationContext context) {
        return new ParameterDeclaration(this.getLocation((ParserRuleContext)context), this.getIdentifierIfPresent((ParserRuleContext)context.identifier()), (DataType)this.visit((ParseTree)context.type()));
    }

    public Node visitReturnsClause(SqlBaseParser.ReturnsClauseContext context) {
        return new ReturnsClause(this.getLocation((ParserRuleContext)context), (DataType)this.visit((ParseTree)context.type()));
    }

    public Node visitLanguageCharacteristic(SqlBaseParser.LanguageCharacteristicContext context) {
        return new LanguageCharacteristic(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitDeterministicCharacteristic(SqlBaseParser.DeterministicCharacteristicContext context) {
        return new DeterministicCharacteristic(this.getLocation((ParserRuleContext)context), context.NOT() == null);
    }

    public Node visitReturnsNullOnNullInputCharacteristic(SqlBaseParser.ReturnsNullOnNullInputCharacteristicContext context) {
        return NullInputCharacteristic.returnsNullOnNullInput(this.getLocation((ParserRuleContext)context));
    }

    public Node visitCalledOnNullInputCharacteristic(SqlBaseParser.CalledOnNullInputCharacteristicContext context) {
        return NullInputCharacteristic.calledOnNullInput(this.getLocation((ParserRuleContext)context));
    }

    public Node visitSecurityCharacteristic(SqlBaseParser.SecurityCharacteristicContext context) {
        return new SecurityCharacteristic(this.getLocation((ParserRuleContext)context), context.INVOKER() != null ? SecurityCharacteristic.Security.INVOKER : SecurityCharacteristic.Security.DEFINER);
    }

    public Node visitCommentCharacteristic(SqlBaseParser.CommentCharacteristicContext context) {
        return new CommentCharacteristic(this.getLocation((ParserRuleContext)context), ((StringLiteral)this.visit((ParseTree)context.string())).getValue());
    }

    public Node visitReturnStatement(SqlBaseParser.ReturnStatementContext context) {
        return new ReturnStatement(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.valueExpression()));
    }

    public Node visitAssignmentStatement(SqlBaseParser.AssignmentStatementContext context) {
        return new AssignmentStatement(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()), (Expression)this.visit((ParseTree)context.expression()));
    }

    public Node visitSimpleCaseStatement(SqlBaseParser.SimpleCaseStatementContext context) {
        return new CaseStatement(this.getLocation((ParserRuleContext)context), this.visitIfPresent((ParserRuleContext)context.expression(), Expression.class), this.visit(context.caseStatementWhenClause(), CaseStatementWhenClause.class), this.visitIfPresent((ParserRuleContext)context.elseClause(), ElseClause.class));
    }

    public Node visitSearchedCaseStatement(SqlBaseParser.SearchedCaseStatementContext context) {
        return new CaseStatement(this.getLocation((ParserRuleContext)context), Optional.empty(), this.visit(context.caseStatementWhenClause(), CaseStatementWhenClause.class), this.visitIfPresent((ParserRuleContext)context.elseClause(), ElseClause.class));
    }

    public Node visitCaseStatementWhenClause(SqlBaseParser.CaseStatementWhenClauseContext context) {
        return new CaseStatementWhenClause(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), this.visit(context.sqlStatementList().controlStatement(), ControlStatement.class));
    }

    public Node visitIfStatement(SqlBaseParser.IfStatementContext context) {
        return new IfStatement(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), this.visit(context.sqlStatementList().controlStatement(), ControlStatement.class), this.visit(context.elseIfClause(), ElseIfClause.class), this.visitIfPresent((ParserRuleContext)context.elseClause(), ElseClause.class));
    }

    public Node visitElseIfClause(SqlBaseParser.ElseIfClauseContext context) {
        return new ElseIfClause(this.getLocation((ParserRuleContext)context), (Expression)this.visit((ParseTree)context.expression()), this.visit(context.sqlStatementList().controlStatement(), ControlStatement.class));
    }

    public Node visitElseClause(SqlBaseParser.ElseClauseContext context) {
        return new ElseClause(this.getLocation((ParserRuleContext)context), this.visit(context.sqlStatementList().controlStatement(), ControlStatement.class));
    }

    public Node visitIterateStatement(SqlBaseParser.IterateStatementContext context) {
        return new IterateStatement(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitLeaveStatement(SqlBaseParser.LeaveStatementContext context) {
        return new LeaveStatement(this.getLocation((ParserRuleContext)context), (Identifier)this.visit((ParseTree)context.identifier()));
    }

    public Node visitVariableDeclaration(SqlBaseParser.VariableDeclarationContext context) {
        return new VariableDeclaration(this.getLocation((ParserRuleContext)context), this.visit(context.identifier(), Identifier.class), (DataType)this.visit((ParseTree)context.type()), this.visitIfPresent((ParserRuleContext)context.valueExpression(), Expression.class));
    }

    public Node visitCompoundStatement(SqlBaseParser.CompoundStatementContext context) {
        return new CompoundStatement(this.getLocation((ParserRuleContext)context), this.visit(context.variableDeclaration(), VariableDeclaration.class), this.visit(Optional.ofNullable(context.sqlStatementList()).map(SqlBaseParser.SqlStatementListContext::controlStatement).orElse((List)ImmutableList.of()), ControlStatement.class));
    }

    public Node visitLoopStatement(SqlBaseParser.LoopStatementContext context) {
        return new LoopStatement(this.getLocation((ParserRuleContext)context), this.getIdentifierIfPresent((ParserRuleContext)context.label), this.visit(context.sqlStatementList().controlStatement(), ControlStatement.class));
    }

    public Node visitWhileStatement(SqlBaseParser.WhileStatementContext context) {
        return new WhileStatement(this.getLocation((ParserRuleContext)context), this.getIdentifierIfPresent((ParserRuleContext)context.label), (Expression)this.visit((ParseTree)context.expression()), this.visit(context.sqlStatementList().controlStatement(), ControlStatement.class));
    }

    public Node visitRepeatStatement(SqlBaseParser.RepeatStatementContext context) {
        return new RepeatStatement(this.getLocation((ParserRuleContext)context), this.getIdentifierIfPresent((ParserRuleContext)context.label), this.visit(context.sqlStatementList().controlStatement(), ControlStatement.class), (Expression)this.visit((ParseTree)context.expression()));
    }

    protected Node defaultResult() {
        return null;
    }

    protected Node aggregateResult(Node aggregate, Node nextResult) {
        if (nextResult == null) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if (aggregate == null) {
            return nextResult;
        }
        throw new UnsupportedOperationException("not yet implemented");
    }

    private static String decodeUnicodeLiteral(SqlBaseParser.UnicodeStringLiteralContext context) {
        char escape;
        if (context.UESCAPE() != null) {
            String escapeString = AstBuilder.unquote(context.STRING().getText());
            AstBuilder.check(!escapeString.isEmpty(), "Empty Unicode escape character", (ParserRuleContext)context);
            AstBuilder.check(escapeString.length() == 1, "Invalid Unicode escape character: " + escapeString, (ParserRuleContext)context);
            escape = escapeString.charAt(0);
            AstBuilder.check(AstBuilder.isValidUnicodeEscape(escape), "Invalid Unicode escape character: " + escapeString, (ParserRuleContext)context);
        } else {
            escape = '\\';
        }
        String rawContent = AstBuilder.unquote(context.UNICODE_STRING().getText().substring(2));
        StringBuilder unicodeStringBuilder = new StringBuilder();
        StringBuilder escapedCharacterBuilder = new StringBuilder();
        int charactersNeeded = 0;
        UnicodeDecodeState state = UnicodeDecodeState.EMPTY;
        block5: for (int i = 0; i < rawContent.length(); ++i) {
            char ch = rawContent.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    if (ch == escape) {
                        state = UnicodeDecodeState.ESCAPED;
                        continue block5;
                    }
                    unicodeStringBuilder.append(ch);
                    continue block5;
                }
                case 1: {
                    if (ch == escape) {
                        unicodeStringBuilder.append(escape);
                        state = UnicodeDecodeState.EMPTY;
                        continue block5;
                    }
                    if (ch == '+') {
                        state = UnicodeDecodeState.UNICODE_SEQUENCE;
                        charactersNeeded = 6;
                        continue block5;
                    }
                    if (AstBuilder.isHexDigit(ch)) {
                        state = UnicodeDecodeState.UNICODE_SEQUENCE;
                        charactersNeeded = 4;
                        escapedCharacterBuilder.append(ch);
                        continue block5;
                    }
                    throw AstBuilder.parseError("Invalid hexadecimal digit: " + ch, (ParserRuleContext)context);
                }
                case 2: {
                    AstBuilder.check(AstBuilder.isHexDigit(ch), "Incomplete escape sequence: " + escapedCharacterBuilder.toString(), (ParserRuleContext)context);
                    escapedCharacterBuilder.append(ch);
                    if (charactersNeeded == escapedCharacterBuilder.length()) {
                        String currentEscapedCode = escapedCharacterBuilder.toString();
                        escapedCharacterBuilder.setLength(0);
                        int codePoint = Integer.parseInt(currentEscapedCode, 16);
                        AstBuilder.check(Character.isValidCodePoint(codePoint), "Invalid escaped character: " + currentEscapedCode, (ParserRuleContext)context);
                        if (Character.isSupplementaryCodePoint(codePoint)) {
                            unicodeStringBuilder.appendCodePoint(codePoint);
                        } else {
                            char currentCodePoint = (char)codePoint;
                            if (Character.isSurrogate(currentCodePoint)) {
                                throw AstBuilder.parseError("Invalid escaped character: %s. Escaped character is a surrogate. Use '\\+123456' instead.".formatted(currentEscapedCode), (ParserRuleContext)context);
                            }
                            unicodeStringBuilder.append(currentCodePoint);
                        }
                        state = UnicodeDecodeState.EMPTY;
                        charactersNeeded = -1;
                        continue block5;
                    }
                    AstBuilder.check(charactersNeeded > escapedCharacterBuilder.length(), "Unexpected escape sequence length: " + escapedCharacterBuilder.length(), (ParserRuleContext)context);
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        AstBuilder.check(state == UnicodeDecodeState.EMPTY, "Incomplete escape sequence: " + escapedCharacterBuilder.toString(), (ParserRuleContext)context);
        return unicodeStringBuilder.toString();
    }

    private <T> Optional<T> visitIfPresent(ParserRuleContext context, Class<T> clazz) {
        return Optional.ofNullable(context).map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast);
    }

    private <T> List<T> visit(List<? extends ParserRuleContext> contexts, Class<T> clazz) {
        return contexts.stream().map(arg_0 -> ((AstBuilder)this).visit(arg_0)).map(clazz::cast).collect(Collectors.toList());
    }

    private static String unquote(String value) {
        return value.substring(1, value.length() - 1).replace("''", "'");
    }

    private static LikeClause.PropertiesOption getPropertiesOption(Token token) {
        return switch (token.getType()) {
            case 123 -> LikeClause.PropertiesOption.INCLUDING;
            case 92 -> LikeClause.PropertiesOption.EXCLUDING;
            default -> throw new IllegalArgumentException("Unsupported LIKE option type: " + token.getText());
        };
    }

    private QualifiedName getQualifiedName(SqlBaseParser.QualifiedNameContext context) {
        return QualifiedName.of(this.visit(context.identifier(), Identifier.class));
    }

    private static boolean isDistinct(SqlBaseParser.SetQuantifierContext setQuantifier) {
        return setQuantifier != null && setQuantifier.DISTINCT() != null;
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static boolean isValidUnicodeEscape(char c) {
        return c < '\u007f' && c > ' ' && !AstBuilder.isHexDigit(c) && c != '\"' && c != '+' && c != '\'';
    }

    private static Optional<String> getTextIfPresent(ParserRuleContext context) {
        return Optional.ofNullable(context).map(ParseTree::getText);
    }

    private Optional<Identifier> getIdentifierIfPresent(ParserRuleContext context) {
        return Optional.ofNullable(context).map(c -> (Identifier)this.visit((ParseTree)c));
    }

    private static ArithmeticBinaryExpression.Operator getArithmeticBinaryOperator(Token operator) {
        return switch (operator.getType()) {
            case 318 -> ArithmeticBinaryExpression.Operator.ADD;
            case 319 -> ArithmeticBinaryExpression.Operator.SUBTRACT;
            case 320 -> ArithmeticBinaryExpression.Operator.MULTIPLY;
            case 321 -> ArithmeticBinaryExpression.Operator.DIVIDE;
            case 322 -> ArithmeticBinaryExpression.Operator.MODULUS;
            default -> throw new UnsupportedOperationException("Unsupported operator: " + operator.getText());
        };
    }

    private static ComparisonExpression.Operator getComparisonOperator(Token symbol) {
        return switch (symbol.getType()) {
            case 312 -> ComparisonExpression.Operator.EQUAL;
            case 313 -> ComparisonExpression.Operator.NOT_EQUAL;
            case 314 -> ComparisonExpression.Operator.LESS_THAN;
            case 315 -> ComparisonExpression.Operator.LESS_THAN_OR_EQUAL;
            case 316 -> ComparisonExpression.Operator.GREATER_THAN;
            case 317 -> ComparisonExpression.Operator.GREATER_THAN_OR_EQUAL;
            default -> throw new IllegalArgumentException("Unsupported operator: " + symbol.getText());
        };
    }

    private static CurrentTime.Function getDateTimeFunctionType(Token token) {
        return switch (token.getType()) {
            case 58 -> CurrentTime.Function.DATE;
            case 62 -> CurrentTime.Function.TIME;
            case 63 -> CurrentTime.Function.TIMESTAMP;
            case 158 -> CurrentTime.Function.LOCALTIME;
            case 159 -> CurrentTime.Function.LOCALTIMESTAMP;
            default -> throw new IllegalArgumentException("Unsupported special function: " + token.getText());
        };
    }

    private static IntervalLiteral.IntervalField getIntervalFieldType(Token token) {
        return switch (token.getType()) {
            case 310 -> IntervalLiteral.IntervalField.YEAR;
            case 171 -> IntervalLiteral.IntervalField.MONTH;
            case 67 -> IntervalLiteral.IntervalField.DAY;
            case 118 -> IntervalLiteral.IntervalField.HOUR;
            case 170 -> IntervalLiteral.IntervalField.MINUTE;
            case 245 -> IntervalLiteral.IntervalField.SECOND;
            default -> throw new IllegalArgumentException("Unsupported interval field: " + token.getText());
        };
    }

    private static IntervalLiteral.Sign getIntervalSign(Token token) {
        return switch (token.getType()) {
            case 319 -> IntervalLiteral.Sign.NEGATIVE;
            case 318 -> IntervalLiteral.Sign.POSITIVE;
            default -> throw new IllegalArgumentException("Unsupported sign: " + token.getText());
        };
    }

    private static WindowFrame.Type getFrameType(Token type) {
        return switch (type.getType()) {
            case 219 -> WindowFrame.Type.RANGE;
            case 240 -> WindowFrame.Type.ROWS;
            case 116 -> WindowFrame.Type.GROUPS;
            default -> throw new IllegalArgumentException("Unsupported frame type: " + type.getText());
        };
    }

    private static FrameBound.Type getBoundedFrameBoundType(Token token) {
        return switch (token.getType()) {
            case 212 -> FrameBound.Type.PRECEDING;
            case 102 -> FrameBound.Type.FOLLOWING;
            default -> throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
        };
    }

    private static FrameBound.Type getUnboundedFrameBoundType(Token token) {
        return switch (token.getType()) {
            case 212 -> FrameBound.Type.UNBOUNDED_PRECEDING;
            case 102 -> FrameBound.Type.UNBOUNDED_FOLLOWING;
            default -> throw new IllegalArgumentException("Unsupported bound type: " + token.getText());
        };
    }

    private static SampledRelation.Type getSamplingMethod(Token token) {
        return switch (token.getType()) {
            case 33 -> SampledRelation.Type.BERNOULLI;
            case 259 -> SampledRelation.Type.SYSTEM;
            default -> throw new IllegalArgumentException("Unsupported sampling method: " + token.getText());
        };
    }

    private static SortItem.NullOrdering getNullOrderingType(Token token) {
        return switch (token.getType()) {
            case 101 -> SortItem.NullOrdering.FIRST;
            case 148 -> SortItem.NullOrdering.LAST;
            default -> throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
        };
    }

    private static SortItem.Ordering getOrderingType(Token token) {
        return switch (token.getType()) {
            case 29 -> SortItem.Ordering.ASCENDING;
            case 75 -> SortItem.Ordering.DESCENDING;
            default -> throw new IllegalArgumentException("Unsupported ordering: " + token.getText());
        };
    }

    private static QuantifiedComparisonExpression.Quantifier getComparisonQuantifier(Token symbol) {
        return switch (symbol.getType()) {
            case 22 -> QuantifiedComparisonExpression.Quantifier.ALL;
            case 26 -> QuantifiedComparisonExpression.Quantifier.ANY;
            case 254 -> QuantifiedComparisonExpression.Quantifier.SOME;
            default -> throw new IllegalArgumentException("Unsupported quantifier: " + symbol.getText());
        };
    }

    private List<Identifier> getIdentifiers(List<SqlBaseParser.IdentifierContext> identifiers) {
        return identifiers.stream().map(context -> (Identifier)this.visit((ParseTree)context)).collect(Collectors.toList());
    }

    private List<PrincipalSpecification> getPrincipalSpecifications(List<SqlBaseParser.PrincipalContext> principals) {
        return principals.stream().map(this::getPrincipalSpecification).collect(Collectors.toList());
    }

    private Optional<GrantorSpecification> getGrantorSpecificationIfPresent(SqlBaseParser.GrantorContext context) {
        return Optional.ofNullable(context).map(this::getGrantorSpecification);
    }

    private GrantorSpecification getGrantorSpecification(SqlBaseParser.GrantorContext context) {
        if (context instanceof SqlBaseParser.SpecifiedPrincipalContext) {
            return new GrantorSpecification(GrantorSpecification.Type.PRINCIPAL, Optional.of(this.getPrincipalSpecification(((SqlBaseParser.SpecifiedPrincipalContext)context).principal())));
        }
        if (context instanceof SqlBaseParser.CurrentUserGrantorContext) {
            return new GrantorSpecification(GrantorSpecification.Type.CURRENT_USER, Optional.empty());
        }
        if (context instanceof SqlBaseParser.CurrentRoleGrantorContext) {
            return new GrantorSpecification(GrantorSpecification.Type.CURRENT_ROLE, Optional.empty());
        }
        throw new IllegalArgumentException("Unsupported grantor: " + String.valueOf(context));
    }

    private PrincipalSpecification getPrincipalSpecification(SqlBaseParser.PrincipalContext context) {
        if (context instanceof SqlBaseParser.UnspecifiedPrincipalContext) {
            return new PrincipalSpecification(PrincipalSpecification.Type.UNSPECIFIED, (Identifier)this.visit((ParseTree)((SqlBaseParser.UnspecifiedPrincipalContext)context).identifier()));
        }
        if (context instanceof SqlBaseParser.UserPrincipalContext) {
            return new PrincipalSpecification(PrincipalSpecification.Type.USER, (Identifier)this.visit((ParseTree)((SqlBaseParser.UserPrincipalContext)context).identifier()));
        }
        if (context instanceof SqlBaseParser.RolePrincipalContext) {
            return new PrincipalSpecification(PrincipalSpecification.Type.ROLE, (Identifier)this.visit((ParseTree)((SqlBaseParser.RolePrincipalContext)context).identifier()));
        }
        throw new IllegalArgumentException("Unsupported principal: " + String.valueOf(context));
    }

    private static void check(boolean condition, String message, ParserRuleContext context) {
        if (!condition) {
            throw AstBuilder.parseError(message, context);
        }
    }

    private NodeLocation getLocation(TerminalNode terminalNode) {
        Objects.requireNonNull(terminalNode, "terminalNode is null");
        return this.getLocation(terminalNode.getSymbol());
    }

    private NodeLocation getLocation(ParserRuleContext parserRuleContext) {
        Objects.requireNonNull(parserRuleContext, "parserRuleContext is null");
        return this.getLocation(parserRuleContext.getStart());
    }

    private NodeLocation getLocation(Token token) {
        Objects.requireNonNull(token, "token is null");
        return this.baseLocation.map(location -> new NodeLocation(token.getLine() + location.getLineNumber() - 1, token.getCharPositionInLine() + 1 + (token.getLine() == 1 ? location.getColumnNumber() : 0))).orElse(new NodeLocation(token.getLine(), token.getCharPositionInLine() + 1));
    }

    private static ParsingException parseError(String message, ParserRuleContext context) {
        return new ParsingException(message, null, context.getStart().getLine(), context.getStart().getCharPositionInLine() + 1);
    }

    private static QueryPeriod.RangeType getRangeType(Token token) {
        return switch (token.getType()) {
            case 268 -> QueryPeriod.RangeType.TIMESTAMP;
            case 298 -> QueryPeriod.RangeType.VERSION;
            default -> throw new IllegalArgumentException("Unsupported query period range type: " + token.getText());
        };
    }

    private static void validateArgumentAlias(Identifier alias, ParserRuleContext context) {
        AstBuilder.check(alias.isDelimited() || !alias.getValue().equalsIgnoreCase("COPARTITION"), "The word \"COPARTITION\" is ambiguous in this context. To alias an argument, precede the alias with \"AS\". To specify co-partitioning, change the argument order so that the last argument cannot be aliased.", context);
    }

    private static enum UnicodeDecodeState {
        EMPTY,
        ESCAPED,
        UNICODE_SEQUENCE;

    }
}

