/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.jsonpath.tree;

import io.trino.sql.jsonpath.tree.JsonPathTreeVisitor;
import io.trino.sql.jsonpath.tree.PathNode;
import java.util.Objects;

public class ArithmeticBinary
extends PathNode {
    private final Operator operator;
    private final PathNode left;
    private final PathNode right;

    public ArithmeticBinary(Operator operator, PathNode left, PathNode right) {
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.left = Objects.requireNonNull(left, "left is null");
        this.right = Objects.requireNonNull(right, "right is null");
    }

    @Override
    public <R, C> R accept(JsonPathTreeVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticBinary(this, context);
    }

    public Operator getOperator() {
        return this.operator;
    }

    public PathNode getLeft() {
        return this.left;
    }

    public PathNode getRight() {
        return this.right;
    }

    public static enum Operator {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        MODULUS;

    }
}

