/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.DataType;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SetColumnType
extends Statement {
    private final QualifiedName tableName;
    private final Identifier columnName;
    private final DataType type;
    private final boolean tableExists;

    public SetColumnType(NodeLocation location, QualifiedName tableName, Identifier columnName, DataType type, boolean tableExists) {
        super(Optional.of(location));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.tableExists = tableExists;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public Identifier getColumnName() {
        return this.columnName;
    }

    public DataType getType() {
        return this.type;
    }

    public boolean isTableExists() {
        return this.tableExists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSetColumnType(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.columnName, (Object)this.type);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.columnName, this.type, this.tableExists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SetColumnType o = (SetColumnType)obj;
        return Objects.equals(this.tableName, o.tableName) && Objects.equals(this.columnName, o.columnName) && Objects.equals(this.type, o.type) && Objects.equals(this.tableExists, o.tableExists);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.tableName).add("column", (Object)this.columnName).add("type", (Object)this.type).add("tableExists", this.tableExists).toString();
    }
}

