/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.jsonpath.tree;

import io.trino.sql.jsonpath.tree.AbsMethod;
import io.trino.sql.jsonpath.tree.Accessor;
import io.trino.sql.jsonpath.tree.ArithmeticBinary;
import io.trino.sql.jsonpath.tree.ArithmeticUnary;
import io.trino.sql.jsonpath.tree.ArrayAccessor;
import io.trino.sql.jsonpath.tree.CeilingMethod;
import io.trino.sql.jsonpath.tree.ComparisonPredicate;
import io.trino.sql.jsonpath.tree.ConjunctionPredicate;
import io.trino.sql.jsonpath.tree.ContextVariable;
import io.trino.sql.jsonpath.tree.DatetimeMethod;
import io.trino.sql.jsonpath.tree.DescendantMemberAccessor;
import io.trino.sql.jsonpath.tree.DisjunctionPredicate;
import io.trino.sql.jsonpath.tree.DoubleMethod;
import io.trino.sql.jsonpath.tree.ExistsPredicate;
import io.trino.sql.jsonpath.tree.Filter;
import io.trino.sql.jsonpath.tree.FloorMethod;
import io.trino.sql.jsonpath.tree.IsUnknownPredicate;
import io.trino.sql.jsonpath.tree.JsonNullLiteral;
import io.trino.sql.jsonpath.tree.JsonPath;
import io.trino.sql.jsonpath.tree.KeyValueMethod;
import io.trino.sql.jsonpath.tree.LastIndexVariable;
import io.trino.sql.jsonpath.tree.LikeRegexPredicate;
import io.trino.sql.jsonpath.tree.Literal;
import io.trino.sql.jsonpath.tree.MemberAccessor;
import io.trino.sql.jsonpath.tree.Method;
import io.trino.sql.jsonpath.tree.NamedVariable;
import io.trino.sql.jsonpath.tree.NegationPredicate;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.jsonpath.tree.Predicate;
import io.trino.sql.jsonpath.tree.PredicateCurrentItemVariable;
import io.trino.sql.jsonpath.tree.SizeMethod;
import io.trino.sql.jsonpath.tree.SqlValueLiteral;
import io.trino.sql.jsonpath.tree.StartsWithPredicate;
import io.trino.sql.jsonpath.tree.TypeMethod;
import javax.annotation.Nullable;

public abstract class JsonPathTreeVisitor<R, C> {
    public R process(PathNode node) {
        return this.process(node, null);
    }

    public R process(PathNode node, @Nullable C context) {
        return node.accept(this, context);
    }

    protected R visitPathNode(PathNode node, C context) {
        return null;
    }

    protected R visitAbsMethod(AbsMethod node, C context) {
        return this.visitMethod(node, context);
    }

    protected R visitAccessor(Accessor node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitArithmeticBinary(ArithmeticBinary node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitArithmeticUnary(ArithmeticUnary node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitArrayAccessor(ArrayAccessor node, C context) {
        return this.visitAccessor(node, context);
    }

    protected R visitCeilingMethod(CeilingMethod node, C context) {
        return this.visitMethod(node, context);
    }

    protected R visitComparisonPredicate(ComparisonPredicate node, C context) {
        return this.visitPredicate(node, context);
    }

    protected R visitConjunctionPredicate(ConjunctionPredicate node, C context) {
        return this.visitPredicate(node, context);
    }

    protected R visitContextVariable(ContextVariable node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitDatetimeMethod(DatetimeMethod node, C context) {
        return this.visitMethod(node, context);
    }

    protected R visitDescendantMemberAccessor(DescendantMemberAccessor node, C context) {
        return this.visitAccessor(node, context);
    }

    protected R visitDisjunctionPredicate(DisjunctionPredicate node, C context) {
        return this.visitPredicate(node, context);
    }

    protected R visitDoubleMethod(DoubleMethod node, C context) {
        return this.visitMethod(node, context);
    }

    protected R visitExistsPredicate(ExistsPredicate node, C context) {
        return this.visitPredicate(node, context);
    }

    protected R visitFilter(Filter node, C context) {
        return this.visitAccessor(node, context);
    }

    protected R visitFloorMethod(FloorMethod node, C context) {
        return this.visitMethod(node, context);
    }

    protected R visitIsUnknownPredicate(IsUnknownPredicate node, C context) {
        return this.visitPredicate(node, context);
    }

    protected R visitJsonNullLiteral(JsonNullLiteral node, C context) {
        return this.visitLiteral(node, context);
    }

    protected R visitJsonPath(JsonPath node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitKeyValueMethod(KeyValueMethod node, C context) {
        return this.visitMethod(node, context);
    }

    protected R visitLastIndexVariable(LastIndexVariable node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitLikeRegexPredicate(LikeRegexPredicate node, C context) {
        return this.visitPredicate(node, context);
    }

    protected R visitLiteral(Literal node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitMemberAccessor(MemberAccessor node, C context) {
        return this.visitAccessor(node, context);
    }

    protected R visitMethod(Method node, C context) {
        return this.visitAccessor(node, context);
    }

    protected R visitNamedVariable(NamedVariable node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitNegationPredicate(NegationPredicate node, C context) {
        return this.visitPredicate(node, context);
    }

    protected R visitPredicate(Predicate node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitPredicateCurrentItemVariable(PredicateCurrentItemVariable node, C context) {
        return this.visitPathNode(node, context);
    }

    protected R visitSizeMethod(SizeMethod node, C context) {
        return this.visitMethod(node, context);
    }

    protected R visitSqlValueLiteral(SqlValueLiteral node, C context) {
        return this.visitLiteral(node, context);
    }

    protected R visitStartsWithPredicate(StartsWithPredicate node, C context) {
        return this.visitPredicate(node, context);
    }

    protected R visitTypeMethod(TypeMethod node, C context) {
        return this.visitMethod(node, context);
    }
}

