/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.trino.sql.tree.Identifier;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public class QualifiedName {
    private final List<Identifier> originalParts;
    private final List<String> parts;
    private final String name;
    private final Optional<QualifiedName> prefix;
    private final String suffix;

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first, "first is null");
        return QualifiedName.of((Iterable)Lists.asList((Object)first, (Object[])rest).stream().map(Identifier::new).collect(ImmutableList.toImmutableList()));
    }

    public static QualifiedName of(String name) {
        Objects.requireNonNull(name, "name is null");
        return QualifiedName.of((Iterable<Identifier>)ImmutableList.of((Object)new Identifier(name)));
    }

    public static QualifiedName of(Iterable<Identifier> originalParts) {
        Objects.requireNonNull(originalParts, "originalParts is null");
        Preconditions.checkArgument((!Iterables.isEmpty(originalParts) ? 1 : 0) != 0, (Object)"originalParts is empty");
        return new QualifiedName((List<Identifier>)ImmutableList.copyOf(originalParts));
    }

    private QualifiedName(List<Identifier> originalParts) {
        this.originalParts = originalParts;
        this.parts = (List)originalParts.stream().map(QualifiedName::mapIdentifier).collect(ImmutableList.toImmutableList());
        this.name = Joiner.on((String)".").join(this.parts);
        if (originalParts.size() == 1) {
            this.prefix = Optional.empty();
            this.suffix = QualifiedName.mapIdentifier(originalParts.get(0));
        } else {
            List<Identifier> subList = originalParts.subList(0, originalParts.size() - 1);
            this.prefix = Optional.of(new QualifiedName(subList));
            this.suffix = QualifiedName.mapIdentifier(originalParts.get(originalParts.size() - 1));
        }
    }

    private static String mapIdentifier(Identifier identifier) {
        return identifier.getValue().toLowerCase(Locale.ENGLISH);
    }

    public List<String> getParts() {
        return this.parts;
    }

    public List<Identifier> getOriginalParts() {
        return this.originalParts;
    }

    public Optional<QualifiedName> getPrefix() {
        return this.prefix;
    }

    public boolean hasSuffix(QualifiedName suffix) {
        if (this.parts.size() < suffix.getParts().size()) {
            return false;
        }
        int start = this.parts.size() - suffix.getParts().size();
        return this.parts.subList(start, this.parts.size()).equals(suffix.getParts());
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.parts.equals(((QualifiedName)o).parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

