/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Literal;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.Objects;
import java.util.Optional;

public class IntervalLiteral
extends Literal {
    private final String value;
    private final Sign sign;
    private final IntervalField startField;
    private final Optional<IntervalField> endField;

    public IntervalLiteral(String value, Sign sign, IntervalField startField) {
        this(Optional.empty(), value, sign, startField, Optional.empty());
    }

    public IntervalLiteral(String value, Sign sign, IntervalField startField, Optional<IntervalField> endField) {
        this(Optional.empty(), value, sign, startField, endField);
    }

    public IntervalLiteral(NodeLocation location, String value, Sign sign, IntervalField startField, Optional<IntervalField> endField) {
        this(Optional.of(location), value, sign, startField, endField);
    }

    private IntervalLiteral(Optional<NodeLocation> location, String value, Sign sign, IntervalField startField, Optional<IntervalField> endField) {
        super(location);
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(sign, "sign is null");
        Objects.requireNonNull(startField, "startField is null");
        Objects.requireNonNull(endField, "endField is null");
        this.value = value;
        this.sign = sign;
        this.startField = startField;
        this.endField = endField;
    }

    public String getValue() {
        return this.value;
    }

    public Sign getSign() {
        return this.sign;
    }

    public IntervalField getStartField() {
        return this.startField;
    }

    public Optional<IntervalField> getEndField() {
        return this.endField;
    }

    public boolean isYearToMonth() {
        return this.startField == IntervalField.YEAR || this.startField == IntervalField.MONTH;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIntervalLiteral(this, context);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.sign, this.startField, this.endField});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IntervalLiteral other = (IntervalLiteral)obj;
        return Objects.equals(this.value, other.value) && this.sign == other.sign && this.startField == other.startField && Objects.equals(this.endField, other.endField);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!IntervalLiteral.sameClass(this, other)) {
            return false;
        }
        IntervalLiteral otherLiteral = (IntervalLiteral)other;
        return Objects.equals(this.value, otherLiteral.value) && this.sign == otherLiteral.sign && this.startField == otherLiteral.startField && Objects.equals(this.endField, otherLiteral.endField);
    }

    public static enum IntervalField {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }

    public static enum Sign {
        POSITIVE{

            @Override
            public int multiplier() {
                return 1;
            }
        }
        ,
        NEGATIVE{

            @Override
            public int multiplier() {
                return -1;
            }
        };


        public abstract int multiplier();
    }
}

