/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.parser;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import io.trino.sql.parser.ParsingException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.NoViableAltException;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.Vocabulary;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNState;
import org.antlr.v4.runtime.atn.NotSetTransition;
import org.antlr.v4.runtime.atn.PrecedencePredicateTransition;
import org.antlr.v4.runtime.atn.RuleStartState;
import org.antlr.v4.runtime.atn.RuleStopState;
import org.antlr.v4.runtime.atn.RuleTransition;
import org.antlr.v4.runtime.atn.Transition;
import org.antlr.v4.runtime.atn.WildcardTransition;
import org.antlr.v4.runtime.misc.IntSet;
import org.antlr.v4.runtime.misc.IntervalSet;

class ErrorHandler
extends BaseErrorListener {
    private static final Logger LOG = Logger.getLogger(ErrorHandler.class.getName());
    private final Map<Integer, String> specialRules;
    private final Map<Integer, String> specialTokens;
    private final Set<Integer> ignoredRules;

    private ErrorHandler(Map<Integer, String> specialRules, Map<Integer, String> specialTokens, Set<Integer> ignoredRules) {
        this.specialRules = new HashMap<Integer, String>(specialRules);
        this.specialTokens = specialTokens;
        this.ignoredRules = new HashSet<Integer>(ignoredRules);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
        try {
            RuleContext context;
            Token currentToken;
            ATNState currentState;
            Parser parser = (Parser)recognizer;
            ATN atn = parser.getATN();
            if (e != null) {
                currentState = (ATNState)atn.states.get(e.getOffendingState());
                currentToken = e.getOffendingToken();
                context = e.getCtx();
                if (e instanceof NoViableAltException) {
                    currentToken = ((NoViableAltException)e).getStartToken();
                }
            } else {
                currentState = (ATNState)atn.states.get(parser.getState());
                currentToken = parser.getCurrentToken();
                context = parser.getContext();
            }
            Analyzer analyzer = new Analyzer(parser, this.specialRules, this.specialTokens, this.ignoredRules);
            Result result = analyzer.process(currentState, currentToken.getTokenIndex(), context);
            String expected = result.getExpected().stream().sorted().collect(Collectors.joining(", "));
            message = String.format("mismatched input '%s'. Expecting: %s", parser.getTokenStream().get(result.getErrorTokenIndex()).getText(), expected);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Unexpected failure when handling parsing error. This is likely a bug in the implementation", exception);
        }
        throw new ParsingException(message, e, line, charPositionInLine + 1);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class Result {
        private final int errorTokenIndex;
        private final Set<String> expected;

        public Result(int errorTokenIndex, Set<String> expected) {
            this.errorTokenIndex = errorTokenIndex;
            this.expected = expected;
        }

        public int getErrorTokenIndex() {
            return this.errorTokenIndex;
        }

        public Set<String> getExpected() {
            return this.expected;
        }
    }

    public static class Builder {
        private final Map<Integer, String> specialRules = new HashMap<Integer, String>();
        private final Map<Integer, String> specialTokens = new HashMap<Integer, String>();
        private final Set<Integer> ignoredRules = new HashSet<Integer>();

        public Builder specialRule(int ruleId, String name) {
            this.specialRules.put(ruleId, name);
            return this;
        }

        public Builder specialToken(int tokenId, String name) {
            this.specialTokens.put(tokenId, name);
            return this;
        }

        public Builder ignoredRule(int ruleId) {
            this.ignoredRules.add(ruleId);
            return this;
        }

        public ErrorHandler build() {
            return new ErrorHandler(this.specialRules, this.specialTokens, this.ignoredRules);
        }
    }

    private static class Analyzer {
        private final Parser parser;
        private final ATN atn;
        private final Vocabulary vocabulary;
        private final Map<Integer, String> specialRules;
        private final Map<Integer, String> specialTokens;
        private final Set<Integer> ignoredRules;
        private final TokenStream stream;
        private int furthestTokenIndex = -1;
        private final Set<String> candidates = new HashSet<String>();
        private final Map<ParsingState, Set<Integer>> memo = new HashMap<ParsingState, Set<Integer>>();

        public Analyzer(Parser parser, Map<Integer, String> specialRules, Map<Integer, String> specialTokens, Set<Integer> ignoredRules) {
            this.parser = parser;
            this.stream = parser.getTokenStream();
            this.atn = parser.getATN();
            this.vocabulary = parser.getVocabulary();
            this.specialRules = specialRules;
            this.specialTokens = specialTokens;
            this.ignoredRules = ignoredRules;
        }

        public Result process(ATNState currentState, int tokenIndex, RuleContext context) {
            RuleStartState startState = this.atn.ruleToStartState[currentState.ruleIndex];
            if (this.isReachable(currentState, startState)) {
                currentState = startState;
            }
            Set<Integer> endTokens = this.process(new ParsingState(currentState, tokenIndex, false, this.parser), 0);
            HashSet<Integer> nextTokens = new HashSet<Integer>();
            while (!endTokens.isEmpty() && context.invokingState != -1) {
                for (int endToken : endTokens) {
                    ATNState nextState = ((RuleTransition)((ATNState)this.atn.states.get((int)context.invokingState)).transition((int)0)).followState;
                    nextTokens.addAll(this.process(new ParsingState(nextState, endToken, false, this.parser), 0));
                }
                context = context.parent;
                endTokens = nextTokens;
            }
            return new Result(this.furthestTokenIndex, this.candidates);
        }

        private boolean isReachable(ATNState target, RuleStartState from) {
            ArrayDeque<Object> activeStates = new ArrayDeque<Object>();
            activeStates.add(from);
            while (!activeStates.isEmpty()) {
                ATNState current = (ATNState)activeStates.pop();
                if (current.stateNumber == target.stateNumber) {
                    return true;
                }
                for (int i = 0; i < current.getNumberOfTransitions(); ++i) {
                    Transition transition = current.transition(i);
                    if (!transition.isEpsilon()) continue;
                    activeStates.push(transition.target);
                }
            }
            return false;
        }

        private Set<Integer> process(ParsingState start, int precedence) {
            ImmutableSet result = this.memo.get(start);
            if (result != null) {
                return result;
            }
            ImmutableSet.Builder endTokens = ImmutableSet.builder();
            ArrayDeque<ParsingState> activeStates = new ArrayDeque<ParsingState>();
            activeStates.add(start);
            while (!activeStates.isEmpty()) {
                ParsingState current = (ParsingState)activeStates.pop();
                ATNState state = current.state;
                int tokenIndex = current.tokenIndex;
                boolean suppressed = current.suppressed;
                while (this.stream.get(tokenIndex).getChannel() == 1) {
                    ++tokenIndex;
                }
                int currentToken = this.stream.get(tokenIndex).getType();
                if (state.getStateType() == 2) {
                    int rule = state.ruleIndex;
                    if (this.specialRules.containsKey(rule)) {
                        if (!suppressed) {
                            this.record(tokenIndex, this.specialRules.get(rule));
                        }
                        suppressed = true;
                    } else if (this.ignoredRules.contains(rule)) continue;
                }
                if (state instanceof RuleStopState) {
                    endTokens.add((Object)tokenIndex);
                    continue;
                }
                for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
                    Transition transition = state.transition(i);
                    if (transition instanceof RuleTransition) {
                        RuleTransition ruleTransition = (RuleTransition)transition;
                        for (int endToken : this.process(new ParsingState(ruleTransition.target, tokenIndex, suppressed, this.parser), ruleTransition.precedence)) {
                            activeStates.push(new ParsingState(ruleTransition.followState, endToken, suppressed, this.parser));
                        }
                        continue;
                    }
                    if (transition instanceof PrecedencePredicateTransition) {
                        if (precedence >= ((PrecedencePredicateTransition)transition).precedence) continue;
                        activeStates.push(new ParsingState(transition.target, tokenIndex, suppressed, this.parser));
                        continue;
                    }
                    if (transition.isEpsilon()) {
                        activeStates.push(new ParsingState(transition.target, tokenIndex, suppressed, this.parser));
                        continue;
                    }
                    if (transition instanceof WildcardTransition) {
                        throw new UnsupportedOperationException("not yet implemented: wildcard transition");
                    }
                    IntervalSet labels = transition.label();
                    if (transition instanceof NotSetTransition) {
                        labels = labels.complement((IntSet)IntervalSet.of((int)1, (int)this.atn.maxTokenType));
                    }
                    if (labels.contains(currentToken) && tokenIndex < this.stream.size() - 1) {
                        activeStates.push(new ParsingState(transition.target, tokenIndex + 1, false, this.parser));
                        continue;
                    }
                    if (suppressed) continue;
                    this.record(tokenIndex, this.getTokenNames(labels));
                }
            }
            result = endTokens.build();
            this.memo.put(start, (Set<Integer>)result);
            return result;
        }

        private void record(int tokenIndex, String label) {
            this.record(tokenIndex, (Set<String>)ImmutableSet.of((Object)label));
        }

        private void record(int tokenIndex, Set<String> labels) {
            if (tokenIndex >= this.furthestTokenIndex) {
                if (tokenIndex > this.furthestTokenIndex) {
                    this.candidates.clear();
                    this.furthestTokenIndex = tokenIndex;
                }
                this.candidates.addAll(labels);
            }
        }

        private Set<String> getTokenNames(IntervalSet tokens) {
            HashSet<String> names = new HashSet<String>();
            for (int i = 0; i < tokens.size(); ++i) {
                int token = tokens.get(i);
                if (token == -1) {
                    names.add("<EOF>");
                    continue;
                }
                names.add(this.specialTokens.getOrDefault(token, this.vocabulary.getDisplayName(token)));
            }
            return names;
        }
    }

    private static class ParsingState {
        public final ATNState state;
        public final int tokenIndex;
        public final boolean suppressed;
        public final Parser parser;

        public ParsingState(ATNState state, int tokenIndex, boolean suppressed, Parser parser) {
            this.state = state;
            this.tokenIndex = tokenIndex;
            this.suppressed = suppressed;
            this.parser = parser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParsingState that = (ParsingState)o;
            return this.tokenIndex == that.tokenIndex && this.state.equals((Object)that.state);
        }

        public int hashCode() {
            return Objects.hash(this.state, this.tokenIndex);
        }

        public String toString() {
            Token token = this.parser.getTokenStream().get(this.tokenIndex);
            String text = (String)MoreObjects.firstNonNull((Object)token.getText(), (Object)"?");
            if (text != null) {
                text = text.replace("\\", "\\\\");
                text = text.replace("\n", "\\n");
                text = text.replace("\r", "\\r");
                text = text.replace("\t", "\\t");
            }
            return String.format("%s%s:%s @ %s:<%s>:%s", this.suppressed ? "-" : "+", this.parser.getRuleNames()[this.state.ruleIndex], this.state.stateNumber, this.tokenIndex, this.parser.getVocabulary().getSymbolicName(token.getType()), text);
        }
    }
}

