/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.FrameBound;
import io.trino.sql.tree.MeasureDefinition;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.PatternSearchMode;
import io.trino.sql.tree.RowPattern;
import io.trino.sql.tree.SkipTo;
import io.trino.sql.tree.SubsetDefinition;
import io.trino.sql.tree.VariableDefinition;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WindowFrame
extends Node {
    private final Type type;
    private final FrameBound start;
    private final Optional<FrameBound> end;
    private final List<MeasureDefinition> measures;
    private final Optional<SkipTo> afterMatchSkipTo;
    private final Optional<PatternSearchMode> patternSearchMode;
    private final Optional<RowPattern> pattern;
    private final List<SubsetDefinition> subsets;
    private final List<VariableDefinition> variableDefinitions;

    public WindowFrame(Type type, FrameBound start, Optional<FrameBound> end, List<MeasureDefinition> measures, Optional<SkipTo> afterMatchSkipTo, Optional<PatternSearchMode> patternSearchMode, Optional<RowPattern> pattern, List<SubsetDefinition> subsets, List<VariableDefinition> variableDefinitions) {
        this(Optional.empty(), type, start, end, measures, afterMatchSkipTo, patternSearchMode, pattern, subsets, variableDefinitions);
    }

    public WindowFrame(NodeLocation location, Type type, FrameBound start, Optional<FrameBound> end, List<MeasureDefinition> measures, Optional<SkipTo> afterMatchSkipTo, Optional<PatternSearchMode> patternSearchMode, Optional<RowPattern> pattern, List<SubsetDefinition> subsets, List<VariableDefinition> variableDefinitions) {
        this(Optional.of(location), type, start, end, measures, afterMatchSkipTo, patternSearchMode, pattern, subsets, variableDefinitions);
    }

    private WindowFrame(Optional<NodeLocation> location, Type type, FrameBound start, Optional<FrameBound> end, List<MeasureDefinition> measures, Optional<SkipTo> afterMatchSkipTo, Optional<PatternSearchMode> patternSearchMode, Optional<RowPattern> pattern, List<SubsetDefinition> subsets, List<VariableDefinition> variableDefinitions) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.start = Objects.requireNonNull(start, "start is null");
        this.end = Objects.requireNonNull(end, "end is null");
        this.measures = Objects.requireNonNull(measures, "measures is null");
        this.afterMatchSkipTo = Objects.requireNonNull(afterMatchSkipTo, "afterMatchSkipTo is null");
        this.patternSearchMode = Objects.requireNonNull(patternSearchMode, "patternSearchMode is null");
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.subsets = Objects.requireNonNull(subsets, "subsets is null");
        this.variableDefinitions = Objects.requireNonNull(variableDefinitions, "variableDefinitions is null");
    }

    public Type getType() {
        return this.type;
    }

    public FrameBound getStart() {
        return this.start;
    }

    public Optional<FrameBound> getEnd() {
        return this.end;
    }

    public List<MeasureDefinition> getMeasures() {
        return this.measures;
    }

    public Optional<SkipTo> getAfterMatchSkipTo() {
        return this.afterMatchSkipTo;
    }

    public Optional<PatternSearchMode> getPatternSearchMode() {
        return this.patternSearchMode;
    }

    public Optional<RowPattern> getPattern() {
        return this.pattern;
    }

    public List<SubsetDefinition> getSubsets() {
        return this.subsets;
    }

    public List<VariableDefinition> getVariableDefinitions() {
        return this.variableDefinitions;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindowFrame(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        nodes.add((Object)this.start);
        this.end.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        nodes.addAll(this.measures);
        this.afterMatchSkipTo.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.patternSearchMode.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        this.pattern.ifPresent(arg_0 -> ((ImmutableList.Builder)nodes).add(arg_0));
        nodes.addAll(this.subsets);
        nodes.addAll(this.variableDefinitions);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WindowFrame o = (WindowFrame)obj;
        return this.type == o.type && Objects.equals(this.start, o.start) && Objects.equals(this.end, o.end) && Objects.equals(this.measures, o.measures) && Objects.equals(this.afterMatchSkipTo, o.afterMatchSkipTo) && Objects.equals(this.patternSearchMode, o.patternSearchMode) && Objects.equals(this.pattern, o.pattern) && Objects.equals(this.subsets, o.subsets) && Objects.equals(this.variableDefinitions, o.variableDefinitions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.start, this.end, this.measures, this.afterMatchSkipTo, this.patternSearchMode, this.pattern, this.subsets, this.variableDefinitions});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("start", (Object)this.start).add("end", this.end).add("measures", this.measures).add("afterMatchSkipTo", this.afterMatchSkipTo).add("patternSearchMode", this.patternSearchMode).add("pattern", this.pattern).add("subsets", this.subsets).add("variableDefinitions", this.variableDefinitions).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!WindowFrame.sameClass(this, other)) {
            return false;
        }
        WindowFrame otherNode = (WindowFrame)other;
        return this.type == otherNode.type;
    }

    public static enum Type {
        RANGE,
        ROWS,
        GROUPS;

    }
}

