/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.QualifiedName;
import io.trino.sql.tree.QueryBody;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class Table
extends QueryBody {
    private final QualifiedName name;

    public Table(QualifiedName name) {
        this(Optional.empty(), name);
    }

    public Table(NodeLocation location, QualifiedName name) {
        this(Optional.of(location), name);
    }

    private Table(Optional<NodeLocation> location, QualifiedName name) {
        super(location);
        this.name = name;
    }

    public QualifiedName getName() {
        return this.name;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.name).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Table table = (Table)o;
        return Objects.equals(this.name, table.name);
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Table.sameClass(this, other)) {
            return false;
        }
        Table otherTable = (Table)other;
        return this.name.equals(otherTable.name);
    }
}

