/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class PatternSearchMode
extends Node {
    private final Mode mode;

    public PatternSearchMode(Mode mode) {
        this(Optional.empty(), mode);
    }

    public PatternSearchMode(NodeLocation location, Mode mode) {
        this(Optional.of(location), mode);
    }

    public PatternSearchMode(Optional<NodeLocation> location, Mode mode) {
        super(location);
        this.mode = Objects.requireNonNull(mode, "mode is null");
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitPatternSearchMode(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.mode == ((PatternSearchMode)obj).mode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.mode});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mode", (Object)this.mode).toString();
    }

    public static enum Mode {
        INITIAL,
        SEEK;

    }
}

