/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.mongodb;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import com.mongodb.DBRef;
import com.mongodb.client.MongoCursor;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.mongodb.MongoColumnHandle;
import io.trino.plugin.mongodb.MongoSession;
import io.trino.plugin.mongodb.MongoTableHandle;
import io.trino.plugin.mongodb.ObjectIdType;
import io.trino.plugin.mongodb.TypeUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.joda.time.chrono.ISOChronology;

public class MongoPageSource
implements ConnectorPageSource {
    private static final ISOChronology UTC_CHRONOLOGY = ISOChronology.getInstanceUTC();
    private static final int ROWS_PER_REQUEST = 1024;
    private final MongoCursor<Document> cursor;
    private final List<String> columnNames;
    private final List<Type> columnTypes;
    private Document currentDoc;
    private boolean finished;
    private final PageBuilder pageBuilder;

    public MongoPageSource(MongoSession mongoSession, MongoTableHandle tableHandle, List<MongoColumnHandle> columns) {
        this.columnNames = columns.stream().map(MongoColumnHandle::getName).collect(Collectors.toList());
        this.columnTypes = columns.stream().map(MongoColumnHandle::getType).collect(Collectors.toList());
        this.cursor = mongoSession.execute(tableHandle, columns);
        this.currentDoc = null;
        this.pageBuilder = new PageBuilder(this.columnTypes);
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public Page getNextPage() {
        Verify.verify((boolean)this.pageBuilder.isEmpty());
        for (int i = 0; i < 1024; ++i) {
            if (!this.cursor.hasNext()) {
                this.finished = true;
                break;
            }
            this.currentDoc = (Document)this.cursor.next();
            this.pageBuilder.declarePosition();
            for (int column = 0; column < this.columnTypes.size(); ++column) {
                BlockBuilder output = this.pageBuilder.getBlockBuilder(column);
                this.appendTo(this.columnTypes.get(column), this.currentDoc.get((Object)this.columnNames.get(column)), output);
            }
        }
        Page page = this.pageBuilder.build();
        this.pageBuilder.reset();
        return page;
    }

    private void appendTo(Type type, Object value, BlockBuilder output) {
        block18: {
            if (value == null) {
                output.appendNull();
                return;
            }
            Class javaType = type.getJavaType();
            try {
                if (javaType == Boolean.TYPE) {
                    type.writeBoolean(output, ((Boolean)value).booleanValue());
                    break block18;
                }
                if (javaType == Long.TYPE) {
                    if (type.equals(BigintType.BIGINT)) {
                        type.writeLong(output, ((Number)value).longValue());
                        break block18;
                    }
                    if (type.equals(IntegerType.INTEGER)) {
                        type.writeLong(output, (long)((Number)value).intValue());
                        break block18;
                    }
                    if (type.equals(SmallintType.SMALLINT)) {
                        type.writeLong(output, (long)Shorts.checkedCast((long)((Number)value).longValue()));
                        break block18;
                    }
                    if (type.equals(TinyintType.TINYINT)) {
                        type.writeLong(output, (long)SignedBytes.checkedCast((long)((Number)value).longValue()));
                        break block18;
                    }
                    if (type.equals(RealType.REAL)) {
                        type.writeLong(output, (long)Float.floatToIntBits((float)((Number)value).doubleValue()));
                        break block18;
                    }
                    if (type instanceof DecimalType) {
                        type.writeLong(output, Decimals.encodeShortScaledValue((BigDecimal)((Decimal128)value).bigDecimalValue(), (int)((DecimalType)type).getScale()));
                        break block18;
                    }
                    if (type.equals(DateType.DATE)) {
                        long utcMillis = ((Date)value).getTime();
                        type.writeLong(output, TimeUnit.MILLISECONDS.toDays(utcMillis));
                        break block18;
                    }
                    if (type.equals(TimeType.TIME)) {
                        long millis = UTC_CHRONOLOGY.millisOfDay().get(((Date)value).getTime());
                        type.writeLong(output, Math.multiplyExact(millis, 1000000000));
                        break block18;
                    }
                    if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
                        type.writeLong(output, ((Date)value).getTime() * 1000L);
                        break block18;
                    }
                    if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
                        type.writeLong(output, DateTimeEncoding.packDateTimeWithZone((long)((Date)value).getTime(), (TimeZoneKey)TimeZoneKey.UTC_KEY));
                        break block18;
                    }
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for " + javaType.getSimpleName() + ":" + type.getTypeSignature());
                }
                if (javaType == Double.TYPE) {
                    type.writeDouble(output, ((Number)value).doubleValue());
                    break block18;
                }
                if (javaType == Slice.class) {
                    this.writeSlice(output, type, value);
                    break block18;
                }
                if (javaType == Block.class) {
                    this.writeBlock(output, type, value);
                    break block18;
                }
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for " + javaType.getSimpleName() + ":" + type.getTypeSignature());
            }
            catch (ClassCastException ignore) {
                output.appendNull();
            }
        }
    }

    private String toVarcharValue(Object value) {
        if (value instanceof Collection) {
            return "[" + String.join((CharSequence)", ", ((Collection)value).stream().map(this::toVarcharValue).collect(Collectors.toList())) + "]";
        }
        if (value instanceof Document) {
            return ((Document)value).toJson();
        }
        return String.valueOf(value);
    }

    private void writeSlice(BlockBuilder output, Type type, Object value) {
        if (type instanceof VarcharType) {
            type.writeSlice(output, Slices.utf8Slice((String)this.toVarcharValue(value)));
        } else if (type instanceof CharType) {
            type.writeSlice(output, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)((String)value)), (CharType)((CharType)type)));
        } else if (type.equals((Object)ObjectIdType.OBJECT_ID)) {
            type.writeSlice(output, Slices.wrappedBuffer((byte[])((ObjectId)value).toByteArray()));
        } else if (type instanceof VarbinaryType) {
            if (value instanceof Binary) {
                type.writeSlice(output, Slices.wrappedBuffer((byte[])((Binary)value).getData()));
            } else {
                output.appendNull();
            }
        } else if (type instanceof DecimalType) {
            type.writeObject(output, (Object)Decimals.encodeScaledValue((BigDecimal)((Decimal128)value).bigDecimalValue(), (int)((DecimalType)type).getScale()));
        } else if (TypeUtils.isJsonType(type)) {
            type.writeSlice(output, JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)this.toVarcharValue(value))));
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Slice: " + type.getTypeSignature());
        }
    }

    public static JsonGenerator createJsonGenerator(JsonFactory factory, SliceOutput output) throws IOException {
        return factory.createGenerator((OutputStream)output);
    }

    private void writeBlock(BlockBuilder output, Type type, Object value) {
        if (TypeUtils.isArrayType(type)) {
            if (value instanceof List) {
                BlockBuilder builder = output.beginBlockEntry();
                ((List)value).forEach(element -> this.appendTo((Type)type.getTypeParameters().get(0), element, builder));
                output.closeEntry();
                return;
            }
        } else if (TypeUtils.isMapType(type)) {
            if (value instanceof List) {
                BlockBuilder builder = output.beginBlockEntry();
                for (Object element2 : (List)value) {
                    Map document;
                    if (!(element2 instanceof Map) || !(document = (Map)element2).containsKey("key") || !document.containsKey("value")) continue;
                    this.appendTo((Type)type.getTypeParameters().get(0), document.get("key"), builder);
                    this.appendTo((Type)type.getTypeParameters().get(1), document.get("value"), builder);
                }
                output.closeEntry();
                return;
            }
            if (value instanceof Map) {
                BlockBuilder builder = output.beginBlockEntry();
                Map document = (Map)value;
                for (Map.Entry entry : document.entrySet()) {
                    this.appendTo((Type)type.getTypeParameters().get(0), entry.getKey(), builder);
                    this.appendTo((Type)type.getTypeParameters().get(1), entry.getValue(), builder);
                }
                output.closeEntry();
                return;
            }
        } else if (TypeUtils.isRowType(type)) {
            if (value instanceof Map) {
                Map mapValue = (Map)value;
                BlockBuilder builder = output.beginBlockEntry();
                ArrayList<String> fieldNames = new ArrayList<String>();
                for (int i = 0; i < type.getTypeSignature().getParameters().size(); ++i) {
                    TypeSignatureParameter parameter = (TypeSignatureParameter)type.getTypeSignature().getParameters().get(i);
                    fieldNames.add((String)((Object)parameter.getNamedTypeSignature().getName().orElse("field" + i)));
                }
                Preconditions.checkState((fieldNames.size() == type.getTypeParameters().size() ? 1 : 0) != 0, (String)"fieldName doesn't match with type size : %s", (Object)type);
                for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                    this.appendTo((Type)type.getTypeParameters().get(index), mapValue.get(fieldNames.get(index)), builder);
                }
                output.closeEntry();
                return;
            }
            if (value instanceof DBRef) {
                DBRef dbRefValue = (DBRef)value;
                BlockBuilder builder = output.beginBlockEntry();
                Preconditions.checkState((type.getTypeParameters().size() == 3 ? 1 : 0) != 0, (String)"DBRef should have 3 fields : %s", (Object)type);
                this.appendTo((Type)type.getTypeParameters().get(0), dbRefValue.getDatabaseName(), builder);
                this.appendTo((Type)type.getTypeParameters().get(1), dbRefValue.getCollectionName(), builder);
                this.appendTo((Type)type.getTypeParameters().get(2), dbRefValue.getId(), builder);
                output.closeEntry();
                return;
            }
            if (value instanceof List) {
                List listValue = (List)value;
                BlockBuilder builder = output.beginBlockEntry();
                for (int index = 0; index < type.getTypeParameters().size(); ++index) {
                    if (index < listValue.size()) {
                        this.appendTo((Type)type.getTypeParameters().get(index), listValue.get(index), builder);
                        continue;
                    }
                    builder.appendNull();
                }
                output.closeEntry();
                return;
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Unhandled type for Block: " + type.getTypeSignature());
        }
        output.appendNull();
    }

    public void close() {
        this.cursor.close();
    }
}

