/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.base.Preconditions;
import io.airlift.json.JsonCodec;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.HostAddress;
import java.util.Objects;

public record MemoryDataFragment(HostAddress hostAddress, long rows) {
    private static final JsonCodec<MemoryDataFragment> MEMORY_DATA_FRAGMENT_CODEC = JsonCodec.jsonCodec(MemoryDataFragment.class);

    public MemoryDataFragment {
        Objects.requireNonNull(hostAddress, "hostAddress is null");
        Preconditions.checkArgument((rows >= 0L ? 1 : 0) != 0, (Object)"Rows number cannot be negative");
    }

    public Slice toSlice() {
        return Slices.wrappedBuffer((byte[])MEMORY_DATA_FRAGMENT_CODEC.toJsonBytes((Object)this));
    }

    public static MemoryDataFragment fromSlice(Slice fragment) {
        return (MemoryDataFragment)MEMORY_DATA_FRAGMENT_CODEC.fromJson(fragment.getBytes());
    }

    public static MemoryDataFragment merge(MemoryDataFragment a, MemoryDataFragment b) {
        Preconditions.checkArgument((boolean)a.hostAddress().equals((Object)b.hostAddress()), (Object)"Cannot merge fragments from different hosts");
        return new MemoryDataFragment(a.hostAddress(), a.rows() + b.rows());
    }
}

