/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import io.trino.plugin.memory.ColumnInfo;
import io.trino.plugin.memory.MemoryDataFragment;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.SchemaTableName;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public record TableInfo(long id, String schemaName, String tableName, List<ColumnInfo> columns, Map<HostAddress, MemoryDataFragment> dataFragments, Optional<String> comment) {
    public TableInfo {
        Objects.requireNonNull(schemaName, "schemaName is null");
        Objects.requireNonNull(tableName, "tableName is null");
        columns = ImmutableList.copyOf(columns);
        dataFragments = ImmutableMap.copyOf(dataFragments);
        Objects.requireNonNull(comment, "comment is null");
    }

    @JsonIgnore
    public SchemaTableName getSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    @JsonIgnore
    public ConnectorTableMetadata getMetadata() {
        return new ConnectorTableMetadata(new SchemaTableName(this.schemaName, this.tableName), this.columns.stream().map(ColumnInfo::getMetadata).collect(Collectors.toList()), Collections.emptyMap(), this.comment);
    }

    @JsonIgnore
    public ColumnInfo getColumn(ColumnHandle handle) {
        return (ColumnInfo)this.columns.stream().filter(column -> column.handle().equals((Object)handle)).collect(MoreCollectors.onlyElement());
    }
}

