/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.inject.Inject;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.memory.MemoryMetadata;
import io.trino.plugin.memory.MemoryPageSinkProvider;
import io.trino.plugin.memory.MemoryPageSourceProvider;
import io.trino.plugin.memory.MemorySplitManager;
import io.trino.plugin.memory.MemoryTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;

public class MemoryConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final MemoryMetadata metadata;
    private final MemorySplitManager splitManager;
    private final MemoryPageSourceProvider pageSourceProvider;
    private final MemoryPageSinkProvider pageSinkProvider;

    @Inject
    public MemoryConnector(LifeCycleManager lifeCycleManager, MemoryMetadata metadata, MemorySplitManager splitManager, MemoryPageSourceProvider pageSourceProvider, MemoryPageSinkProvider pageSinkProvider) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return MemoryTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public void shutdown() {
        this.lifeCycleManager.stop();
    }
}

