/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.plugin.memory.ColumnInfo;
import io.trino.plugin.memory.MemoryColumnHandle;
import io.trino.plugin.memory.MemoryDataFragment;
import io.trino.plugin.memory.MemoryInsertTableHandle;
import io.trino.plugin.memory.MemoryOutputTableHandle;
import io.trino.plugin.memory.MemoryTableHandle;
import io.trino.plugin.memory.TableInfo;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.NodeManager;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.ViewNotFoundException;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;

@ThreadSafe
public class MemoryMetadata
implements ConnectorMetadata {
    public static final String SCHEMA_NAME = "default";
    private final NodeManager nodeManager;
    @GuardedBy(value="this")
    private final List<String> schemas = new ArrayList<String>();
    private final AtomicLong nextTableId = new AtomicLong();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, Long> tableIds = new HashMap<SchemaTableName, Long>();
    @GuardedBy(value="this")
    private final Map<Long, TableInfo> tables = new HashMap<Long, TableInfo>();
    @GuardedBy(value="this")
    private final Map<SchemaTableName, ConnectorViewDefinition> views = new HashMap<SchemaTableName, ConnectorViewDefinition>();
    private final Map<SchemaFunctionName, Map<String, LanguageFunction>> functions = new HashMap<SchemaFunctionName, Map<String, LanguageFunction>>();

    @Inject
    public MemoryMetadata(NodeManager nodeManager) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.schemas.add(SCHEMA_NAME);
    }

    public synchronized List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.copyOf(this.schemas);
    }

    public synchronized void createSchema(ConnectorSession session, String schemaName, Map<String, Object> properties, TrinoPrincipal owner) {
        if (this.schemas.contains(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Schema [%s] already exists", schemaName));
        }
        this.schemas.add(schemaName);
    }

    public synchronized void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        if (!this.schemas.contains(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, String.format("Schema [%s] does not exist", schemaName));
        }
        if (cascade) {
            Set viewNames = (Set)this.views.keySet().stream().filter(view -> view.getSchemaName().equals(schemaName)).collect(ImmutableSet.toImmutableSet());
            viewNames.forEach(viewName -> this.dropView(session, (SchemaTableName)viewName));
            Set tableNames = (Set)this.tables.values().stream().filter(table -> table.getSchemaName().equals(schemaName)).map(TableInfo::getSchemaTableName).collect(ImmutableSet.toImmutableSet());
            tableNames.forEach(tableName -> this.dropTable(session, this.getTableHandle(session, (SchemaTableName)tableName, Optional.empty(), Optional.empty())));
        }
        if (!this.isSchemaEmpty(schemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SCHEMA_NOT_EMPTY, "Schema not empty: " + schemaName);
        }
        Verify.verify((boolean)this.schemas.remove(schemaName));
    }

    @GuardedBy(value="this")
    private boolean isSchemaEmpty(String schemaName) {
        return this.tables.values().stream().noneMatch(table -> table.getSchemaName().equals(schemaName)) && this.views.keySet().stream().noneMatch(view -> view.getSchemaName().equals(schemaName));
    }

    public ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        throw new UnsupportedOperationException("This method is not supported because getTableHandle with versions is implemented instead");
    }

    public synchronized ConnectorTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        Long id = this.tableIds.get(schemaTableName);
        if (id == null) {
            return null;
        }
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        return new MemoryTableHandle(id);
    }

    public synchronized ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        return this.tables.get(handle.getId()).getMetadata();
    }

    public synchronized List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.views.keySet().stream().filter(table -> schemaName.map(table.getSchemaName()::contentEquals).orElse(true)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.tables.values().stream().filter(table -> schemaName.map(table.getSchemaName()::contentEquals).orElse(true)).map(TableInfo::getSchemaTableName).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public synchronized Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        return (Map)this.tables.get(handle.getId()).getColumns().stream().collect(ImmutableMap.toImmutableMap(ColumnInfo::getName, ColumnInfo::getHandle));
    }

    public synchronized ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        return this.tables.get(handle.getId()).getColumn(columnHandle).getMetadata();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated streamTableColumns is not supported because streamRelationColumns is implemented instead");
    }

    public synchronized Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        Map relationsColumns = (Map)Streams.concat((Stream[])new Stream[]{this.tables.values().stream().map(tableInfo -> RelationColumnsMetadata.forTable((SchemaTableName)tableInfo.getSchemaTableName(), (List)tableInfo.getMetadata().getColumns())), this.views.entrySet().stream().map(entry -> RelationColumnsMetadata.forView((SchemaTableName)((SchemaTableName)entry.getKey()), (List)((ConnectorViewDefinition)entry.getValue()).getColumns()))}).collect(ImmutableMap.toImmutableMap(RelationColumnsMetadata::name, Function.identity()));
        return ((Set)relationFilter.apply(relationsColumns.keySet())).stream().map(relationsColumns::get).iterator();
    }

    public synchronized Iterator<RelationCommentMetadata> streamRelationComments(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        Map relationsColumns = (Map)Streams.concat((Stream[])new Stream[]{this.tables.values().stream().map(tableInfo -> RelationCommentMetadata.forRelation((SchemaTableName)tableInfo.getSchemaTableName(), (Optional)tableInfo.getMetadata().getComment())), this.views.entrySet().stream().map(entry -> RelationCommentMetadata.forRelation((SchemaTableName)((SchemaTableName)entry.getKey()), (Optional)((ConnectorViewDefinition)entry.getValue()).getComment()))}).collect(ImmutableMap.toImmutableMap(RelationCommentMetadata::name, Function.identity()));
        return ((Set)relationFilter.apply(relationsColumns.keySet())).stream().map(relationsColumns::get).iterator();
    }

    public synchronized void dropTable(ConnectorSession session, ConnectorTableHandle tableHandle) {
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        TableInfo info = this.tables.remove(handle.getId());
        if (info != null) {
            this.tableIds.remove(info.getSchemaTableName());
        }
    }

    public synchronized void renameTable(ConnectorSession session, ConnectorTableHandle tableHandle, SchemaTableName newTableName) {
        this.checkSchemaExists(newTableName.getSchemaName());
        this.checkTableNotExists(newTableName);
        MemoryTableHandle handle = (MemoryTableHandle)tableHandle;
        long tableId = handle.getId();
        TableInfo oldInfo = this.tables.get(tableId);
        this.tables.put(tableId, new TableInfo(tableId, newTableName.getSchemaName(), newTableName.getTableName(), oldInfo.getColumns(), oldInfo.getDataFragments(), oldInfo.getComment()));
        this.tableIds.remove(oldInfo.getSchemaTableName());
        this.tableIds.put(newTableName, tableId);
    }

    public synchronized void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        ConnectorOutputTableHandle outputTableHandle = this.beginCreateTable(session, tableMetadata, Optional.empty(), RetryMode.NO_RETRIES);
        this.finishCreateTable(session, outputTableHandle, (Collection<Slice>)ImmutableList.of(), (Collection<ComputedStatistics>)ImmutableList.of());
    }

    public synchronized MemoryOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode) {
        this.checkSchemaExists(tableMetadata.getTable().getSchemaName());
        this.checkTableNotExists(tableMetadata.getTable());
        long tableId = this.nextTableId.getAndIncrement();
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No Memory nodes available");
        ImmutableList.Builder columns = ImmutableList.builder();
        for (int i = 0; i < tableMetadata.getColumns().size(); ++i) {
            ColumnMetadata column = (ColumnMetadata)tableMetadata.getColumns().get(i);
            columns.add((Object)new ColumnInfo(new MemoryColumnHandle(i), column.getName(), column.getType(), Optional.ofNullable(column.getComment())));
        }
        this.tableIds.put(tableMetadata.getTable(), tableId);
        this.tables.put(tableId, new TableInfo(tableId, tableMetadata.getTable().getSchemaName(), tableMetadata.getTable().getTableName(), (List<ColumnInfo>)columns.build(), new HashMap<HostAddress, MemoryDataFragment>(), tableMetadata.getComment()));
        return new MemoryOutputTableHandle(tableId, (Set<Long>)ImmutableSet.copyOf(this.tableIds.values()));
    }

    @GuardedBy(value="this")
    private void checkSchemaExists(String schemaName) {
        if (!this.schemas.contains(schemaName)) {
            throw new SchemaNotFoundException(schemaName);
        }
    }

    @GuardedBy(value="this")
    private void checkTableNotExists(SchemaTableName tableName) {
        if (this.tableIds.containsKey(tableName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("Table [%s] already exists", tableName));
        }
        if (this.views.containsKey(tableName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, String.format("View [%s] already exists", tableName));
        }
    }

    public synchronized Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        MemoryOutputTableHandle memoryOutputHandle = (MemoryOutputTableHandle)tableHandle;
        this.updateRowsOnHosts(memoryOutputHandle.getTable(), fragments);
        return Optional.empty();
    }

    public synchronized MemoryInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        MemoryTableHandle memoryTableHandle = (MemoryTableHandle)tableHandle;
        return new MemoryInsertTableHandle(memoryTableHandle.getId(), (Set<Long>)ImmutableSet.copyOf(this.tableIds.values()));
    }

    public synchronized Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Objects.requireNonNull(insertHandle, "insertHandle is null");
        MemoryInsertTableHandle memoryInsertHandle = (MemoryInsertTableHandle)insertHandle;
        this.updateRowsOnHosts(memoryInsertHandle.getTable(), fragments);
        return Optional.empty();
    }

    public synchronized void createView(ConnectorSession session, SchemaTableName viewName, ConnectorViewDefinition definition, boolean replace) {
        this.checkSchemaExists(viewName.getSchemaName());
        if (this.tableIds.containsKey(viewName) && !replace) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + String.valueOf(viewName));
        }
        if (replace) {
            this.views.put(viewName, definition);
        } else if (this.views.putIfAbsent(viewName, definition) != null) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + String.valueOf(viewName));
        }
        this.tableIds.put(viewName, this.nextTableId.getAndIncrement());
    }

    public synchronized void setViewComment(ConnectorSession session, SchemaTableName viewName, Optional<String> comment) {
        ConnectorViewDefinition view = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        this.views.put(viewName, new ConnectorViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), view.getColumns(), comment, view.getOwner(), view.isRunAsInvoker(), view.getPath()));
    }

    public synchronized void setViewColumnComment(ConnectorSession session, SchemaTableName viewName, String columnName, Optional<String> comment) {
        ConnectorViewDefinition view = this.getView(session, viewName).orElseThrow(() -> new ViewNotFoundException(viewName));
        this.views.put(viewName, new ConnectorViewDefinition(view.getOriginalSql(), view.getCatalog(), view.getSchema(), (List)view.getColumns().stream().map(currentViewColumn -> Objects.equals(columnName, currentViewColumn.getName()) ? new ConnectorViewDefinition.ViewColumn(currentViewColumn.getName(), currentViewColumn.getType(), comment) : currentViewColumn).collect(ImmutableList.toImmutableList()), view.getComment(), view.getOwner(), view.isRunAsInvoker(), view.getPath()));
    }

    public synchronized void renameView(ConnectorSession session, SchemaTableName viewName, SchemaTableName newViewName) {
        this.checkSchemaExists(newViewName.getSchemaName());
        if (!this.tableIds.containsKey(viewName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "View not found: " + String.valueOf(viewName));
        }
        if (this.tableIds.containsKey(newViewName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + String.valueOf(newViewName));
        }
        if (this.views.containsKey(newViewName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "View already exists: " + String.valueOf(newViewName));
        }
        this.tableIds.put(newViewName, this.tableIds.remove(viewName));
        this.views.put(newViewName, this.views.remove(viewName));
    }

    public synchronized void dropView(ConnectorSession session, SchemaTableName viewName) {
        if (this.views.remove(viewName) == null) {
            throw new ViewNotFoundException(viewName);
        }
        this.tableIds.remove(viewName);
    }

    public synchronized List<SchemaTableName> listViews(ConnectorSession session, Optional<String> schemaName) {
        return (List)this.views.keySet().stream().filter(viewName -> schemaName.map(viewName.getSchemaName()::equals).orElse(true)).collect(ImmutableList.toImmutableList());
    }

    public synchronized Map<SchemaTableName, ConnectorViewDefinition> getViews(ConnectorSession session, Optional<String> schemaName) {
        SchemaTablePrefix prefix = schemaName.map(SchemaTablePrefix::new).orElseGet(SchemaTablePrefix::new);
        return ImmutableMap.copyOf((Map)Maps.filterKeys(this.views, arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)));
    }

    public synchronized Optional<ConnectorViewDefinition> getView(ConnectorSession session, SchemaTableName viewName) {
        return Optional.ofNullable(this.views.get(viewName));
    }

    @GuardedBy(value="this")
    private void updateRowsOnHosts(long tableId, Collection<Slice> fragments) {
        TableInfo info = this.tables.get(tableId);
        Preconditions.checkState((info != null ? 1 : 0) != 0, (String)"Uninitialized tableId %s", (long)tableId);
        HashMap<HostAddress, MemoryDataFragment> dataFragments = new HashMap<HostAddress, MemoryDataFragment>(info.getDataFragments());
        for (Slice fragment : fragments) {
            MemoryDataFragment memoryDataFragment = MemoryDataFragment.fromSlice(fragment);
            dataFragments.merge(memoryDataFragment.getHostAddress(), memoryDataFragment, MemoryDataFragment::merge);
        }
        this.tables.put(tableId, new TableInfo(tableId, info.getSchemaName(), info.getTableName(), info.getColumns(), dataFragments, info.getComment()));
    }

    public synchronized List<MemoryDataFragment> getDataFragments(long tableId) {
        return ImmutableList.copyOf(this.tables.get(tableId).getDataFragments().values());
    }

    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle) {
        List<MemoryDataFragment> dataFragments = this.getDataFragments(((MemoryTableHandle)tableHandle).getId());
        long rows = dataFragments.stream().mapToLong(MemoryDataFragment::getRows).sum();
        return TableStatistics.builder().setRowCount(Estimate.of((double)rows)).build();
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle handle, long limit) {
        MemoryTableHandle table = (MemoryTableHandle)handle;
        if (table.getLimit().isPresent() && table.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        return Optional.of(new LimitApplicationResult((Object)new MemoryTableHandle(table.getId(), OptionalLong.of(limit), OptionalDouble.empty()), true, true));
    }

    public Optional<SampleApplicationResult<ConnectorTableHandle>> applySample(ConnectorSession session, ConnectorTableHandle handle, SampleType sampleType, double sampleRatio) {
        MemoryTableHandle table = (MemoryTableHandle)handle;
        if (table.getSampleRatio().isPresent() && table.getSampleRatio().getAsDouble() == sampleRatio || sampleType != SampleType.SYSTEM || table.getLimit().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new SampleApplicationResult((Object)new MemoryTableHandle(table.getId(), table.getLimit(), OptionalDouble.of(table.getSampleRatio().orElse(1.0) * sampleRatio)), true));
    }

    public synchronized void setTableComment(ConnectorSession session, ConnectorTableHandle tableHandle, Optional<String> comment) {
        MemoryTableHandle table = (MemoryTableHandle)tableHandle;
        TableInfo info = this.tables.get(table.getId());
        Preconditions.checkArgument((info != null ? 1 : 0) != 0, (Object)"Table not found");
        this.tables.put(table.getId(), new TableInfo(table.getId(), info.getSchemaName(), info.getTableName(), info.getColumns(), info.getDataFragments(), comment));
    }

    public synchronized void setColumnComment(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle, Optional<String> comment) {
        MemoryTableHandle table = (MemoryTableHandle)tableHandle;
        TableInfo info = this.tables.get(table.getId());
        Preconditions.checkArgument((info != null ? 1 : 0) != 0, (Object)"Table not found");
        this.tables.put(table.getId(), new TableInfo(table.getId(), info.getSchemaName(), info.getTableName(), (List)info.getColumns().stream().map(tableColumn -> Objects.equals(tableColumn.getHandle(), columnHandle) ? new ColumnInfo(tableColumn.getHandle(), tableColumn.getName(), tableColumn.getMetadata().getType(), comment) : tableColumn).collect(ImmutableList.toImmutableList()), info.getDataFragments(), info.getComment()));
    }

    public synchronized Collection<LanguageFunction> listLanguageFunctions(ConnectorSession session, String schemaName) {
        return this.functions.entrySet().stream().filter(entry -> ((SchemaFunctionName)entry.getKey()).getSchemaName().equals(schemaName)).flatMap(entry -> ((Map)entry.getValue()).values().stream()).toList();
    }

    public synchronized Collection<LanguageFunction> getLanguageFunctions(ConnectorSession session, SchemaFunctionName name) {
        return this.functions.getOrDefault(name, Map.of()).values();
    }

    public synchronized boolean languageFunctionExists(ConnectorSession session, SchemaFunctionName name, String signatureToken) {
        return this.functions.getOrDefault(name, Map.of()).containsKey(signatureToken);
    }

    public synchronized void createLanguageFunction(ConnectorSession session, SchemaFunctionName name, LanguageFunction function, boolean replace) {
        Map map = this.functions.computeIfAbsent(name, ignored -> new HashMap());
        if (!replace && map.containsKey(function.signatureToken())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Function already exists");
        }
        map.put(function.signatureToken(), function);
    }

    public synchronized void dropLanguageFunction(ConnectorSession session, SchemaFunctionName name, String signatureToken) {
        Map<String, LanguageFunction> map = this.functions.get(name);
        if (map == null || !map.containsKey(signatureToken)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Function not found");
        }
        map.remove(signatureToken);
        if (map.isEmpty()) {
            this.functions.remove(name);
        }
    }
}

