/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;

public class MemorySplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MemorySplit.class);
    private final long table;
    private final int totalPartsPerWorker;
    private final int partNumber;
    private final HostAddress address;
    private final long expectedRows;
    private final OptionalLong limit;

    @JsonCreator
    public MemorySplit(@JsonProperty(value="table") long table, @JsonProperty(value="partNumber") int partNumber, @JsonProperty(value="totalPartsPerWorker") int totalPartsPerWorker, @JsonProperty(value="address") HostAddress address, @JsonProperty(value="expectedRows") long expectedRows, @JsonProperty(value="limit") OptionalLong limit) {
        Preconditions.checkState((partNumber >= 0 ? 1 : 0) != 0, (Object)"partNumber must be >= 0");
        Preconditions.checkState((totalPartsPerWorker >= 1 ? 1 : 0) != 0, (Object)"totalPartsPerWorker must be >= 1");
        Preconditions.checkState((totalPartsPerWorker > partNumber ? 1 : 0) != 0, (Object)"totalPartsPerWorker must be > partNumber");
        this.table = table;
        this.partNumber = partNumber;
        this.totalPartsPerWorker = totalPartsPerWorker;
        this.address = Objects.requireNonNull(address, "address is null");
        this.expectedRows = expectedRows;
        this.limit = limit;
    }

    @JsonProperty
    public long getTable() {
        return this.table;
    }

    @JsonProperty
    public int getTotalPartsPerWorker() {
        return this.totalPartsPerWorker;
    }

    @JsonProperty
    public int getPartNumber() {
        return this.partNumber;
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.address.getRetainedSizeInBytes() + SizeOf.sizeOf((OptionalLong)this.limit);
    }

    public boolean isRemotelyAccessible() {
        return false;
    }

    @JsonProperty
    public HostAddress getAddress() {
        return this.address;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of((Object)this.address);
    }

    @JsonProperty
    public long getExpectedRows() {
        return this.expectedRows;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemorySplit other = (MemorySplit)obj;
        return Objects.equals(this.table, other.table) && Objects.equals(this.totalPartsPerWorker, other.totalPartsPerWorker) && Objects.equals(this.partNumber, other.partNumber);
    }

    public int hashCode() {
        return Objects.hash(this.table, this.totalPartsPerWorker, this.partNumber);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableHandle", this.table).add("partNumber", this.partNumber).add("totalPartsPerWorker", this.totalPartsPerWorker).toString();
    }
}

