/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.memory;

import io.airlift.configuration.Config;
import io.airlift.units.DataSize;
import javax.validation.constraints.NotNull;

public class MemoryConfig {
    private int splitsPerNode = Runtime.getRuntime().availableProcessors();
    private DataSize maxDataPerNode = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private boolean enableLazyDynamicFiltering = true;

    @NotNull
    public int getSplitsPerNode() {
        return this.splitsPerNode;
    }

    @Config(value="memory.splits-per-node")
    public MemoryConfig setSplitsPerNode(int splitsPerNode) {
        this.splitsPerNode = splitsPerNode;
        return this;
    }

    @NotNull
    public DataSize getMaxDataPerNode() {
        return this.maxDataPerNode;
    }

    @Config(value="memory.max-data-per-node")
    public MemoryConfig setMaxDataPerNode(DataSize maxDataPerNode) {
        this.maxDataPerNode = maxDataPerNode;
        return this;
    }

    public boolean isEnableLazyDynamicFiltering() {
        return this.enableLazyDynamicFiltering;
    }

    @Config(value="memory.enable-lazy-dynamic-filtering")
    public MemoryConfig setEnableLazyDynamicFiltering(boolean enableLazyDynamicFiltering) {
        this.enableLazyDynamicFiltering = enableLazyDynamicFiltering;
        return this;
    }
}

