/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory.context;

import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.log.Logger;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.memory.context.MemoryAllocationValidator;
import java.util.Objects;

public class ValidatingLocalMemoryContext
implements LocalMemoryContext {
    private static final Logger log = Logger.get(ValidatingLocalMemoryContext.class);
    private final LocalMemoryContext delegate;
    private final String allocationTag;
    private final MemoryAllocationValidator memoryValidator;

    public ValidatingLocalMemoryContext(LocalMemoryContext delegate, String allocationTag, MemoryAllocationValidator memoryValidator) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.allocationTag = Objects.requireNonNull(allocationTag, "allocationTag is null");
        this.memoryValidator = Objects.requireNonNull(memoryValidator, "memoryValidator is null");
    }

    @Override
    public long getBytes() {
        return this.delegate.getBytes();
    }

    @Override
    public ListenableFuture<Void> setBytes(long bytes) {
        long delta = bytes - this.delegate.getBytes();
        this.memoryValidator.reserveMemory(this.allocationTag, delta);
        try {
            return this.delegate.setBytes(bytes);
        }
        catch (Exception e) {
            this.revertReservationInValidatorSuppressing(this.allocationTag, delta, e);
            throw e;
        }
    }

    @Override
    public boolean trySetBytes(long bytes) {
        long delta = bytes - this.delegate.getBytes();
        if (!this.memoryValidator.tryReserveMemory(this.allocationTag, delta)) {
            return false;
        }
        try {
            if (this.delegate.trySetBytes(bytes)) {
                return true;
            }
        }
        catch (Exception e) {
            this.revertReservationInValidatorSuppressing(this.allocationTag, delta, e);
            throw e;
        }
        this.revertReservationInValidator(this.allocationTag, delta);
        return false;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private void revertReservationInValidatorSuppressing(String allocationTag, long delta, Exception revertCause) {
        block2: {
            try {
                this.revertReservationInValidator(allocationTag, delta);
            }
            catch (Exception suppressed) {
                log.warn((Throwable)suppressed, "Could not rollback memory reservation within allocation validator");
                if (suppressed == revertCause) break block2;
                revertCause.addSuppressed(suppressed);
            }
        }
    }

    private void revertReservationInValidator(String allocationTag, long delta) {
        this.memoryValidator.reserveMemory(allocationTag, -delta);
    }
}

