/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MoreMaps {
    private MoreMaps() {
    }

    public static <K, V> Map<K, V> mergeMaps(Map<K, V> map1, Map<K, V> map2, BinaryOperator<V> merger) {
        return MoreMaps.mergeMaps(Stream.of(map1, map2), merger);
    }

    public static <K, V> Map<K, V> mergeMaps(Stream<Map<K, V>> mapStream, BinaryOperator<V> merger) {
        return mapStream.map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, merger));
    }

    public static <K, V> Map<K, V> asMap(List<K> keyList, List<V> valueList) {
        if (keyList.size() != valueList.size()) {
            throw new AssertionError((Object)"keyList should have same size with valueList");
        }
        HashMap<K, V> map = new HashMap<K, V>();
        for (int i = 0; i < keyList.size(); ++i) {
            if (map.put(keyList.get(i), valueList.get(i)) != null) {
                throw new AssertionError((Object)"keyList should have same size with valueList");
            }
        }
        return map;
    }
}

