/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type.setdigest;

import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.GroupedAccumulatorState;
import io.trino.type.setdigest.SetDigest;
import io.trino.type.setdigest.SetDigestState;

public class SetDigestStateFactory
implements AccumulatorStateFactory<SetDigestState> {
    private static final int SIZE_OF_SINGLE = SizeOf.instanceSize(SingleSetDigestState.class);
    private static final int SIZE_OF_GROUPED = SizeOf.instanceSize(GroupedSetDigestState.class);

    public SetDigestState createSingleState() {
        return new SingleSetDigestState();
    }

    public SetDigestState createGroupedState() {
        return new GroupedSetDigestState();
    }

    public static class SingleSetDigestState
    implements SetDigestState {
        private SetDigest digest;

        @Override
        public SetDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(SetDigest value) {
            this.digest = value;
        }

        public long getEstimatedSize() {
            if (this.digest == null) {
                return SIZE_OF_SINGLE;
            }
            return SIZE_OF_SINGLE + this.digest.estimatedInMemorySize();
        }
    }

    public static class GroupedSetDigestState
    implements GroupedAccumulatorState,
    SetDigestState {
        private final ObjectBigArray<SetDigest> digests = new ObjectBigArray();
        private int groupId;
        private long size;

        public void setGroupId(int groupId) {
            this.groupId = groupId;
        }

        public void ensureCapacity(int size) {
            this.digests.ensureCapacity((long)size);
        }

        @Override
        public SetDigest getDigest() {
            return (SetDigest)this.digests.get((long)this.groupId);
        }

        @Override
        public void setDigest(SetDigest value) {
            if (this.getDigest() != null) {
                this.size -= (long)this.getDigest().estimatedInMemorySize();
            }
            this.size += (long)value.estimatedInMemorySize();
            this.digests.set((long)this.groupId, (Object)value);
        }

        public long getEstimatedSize() {
            return (long)SIZE_OF_GROUPED + this.size + this.digests.sizeOf();
        }
    }
}

