/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.metadata.PolymorphicScalarFunctionBuilder;
import io.trino.metadata.SqlScalarFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.Signature;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarcharType;
import io.trino.type.JsonType;
import io.trino.util.Failures;
import io.trino.util.JsonCastException;
import io.trino.util.JsonUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;

public final class DecimalCasts {
    public static final SqlScalarFunction DECIMAL_TO_BOOLEAN_CAST = DecimalCasts.castFunctionFromDecimalTo(BooleanType.BOOLEAN.getTypeSignature(), "shortDecimalToBoolean", "longDecimalToBoolean");
    public static final SqlScalarFunction BOOLEAN_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(BooleanType.BOOLEAN.getTypeSignature(), "booleanToShortDecimal", "booleanToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_BIGINT_CAST = DecimalCasts.castFunctionFromDecimalTo(BigintType.BIGINT.getTypeSignature(), "shortDecimalToBigint", "longDecimalToBigint");
    public static final SqlScalarFunction BIGINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(BigintType.BIGINT.getTypeSignature(), "bigintToShortDecimal", "bigintToLongDecimal");
    public static final SqlScalarFunction INTEGER_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(IntegerType.INTEGER.getTypeSignature(), "integerToShortDecimal", "integerToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_INTEGER_CAST = DecimalCasts.castFunctionFromDecimalTo(IntegerType.INTEGER.getTypeSignature(), "shortDecimalToInteger", "longDecimalToInteger");
    public static final SqlScalarFunction SMALLINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(SmallintType.SMALLINT.getTypeSignature(), "smallintToShortDecimal", "smallintToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_SMALLINT_CAST = DecimalCasts.castFunctionFromDecimalTo(SmallintType.SMALLINT.getTypeSignature(), "shortDecimalToSmallint", "longDecimalToSmallint");
    public static final SqlScalarFunction TINYINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(TinyintType.TINYINT.getTypeSignature(), "tinyintToShortDecimal", "tinyintToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_TINYINT_CAST = DecimalCasts.castFunctionFromDecimalTo(TinyintType.TINYINT.getTypeSignature(), "shortDecimalToTinyint", "longDecimalToTinyint");
    public static final SqlScalarFunction DECIMAL_TO_DOUBLE_CAST = DecimalCasts.castFunctionFromDecimalTo(DoubleType.DOUBLE.getTypeSignature(), "shortDecimalToDouble", "longDecimalToDouble");
    public static final SqlScalarFunction DOUBLE_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(DoubleType.DOUBLE.getTypeSignature(), "doubleToShortDecimal", "doubleToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_REAL_CAST = DecimalCasts.castFunctionFromDecimalTo(RealType.REAL.getTypeSignature(), "shortDecimalToReal", "longDecimalToReal");
    public static final SqlScalarFunction REAL_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(RealType.REAL.getTypeSignature(), "realToShortDecimal", "realToLongDecimal");
    public static final SqlScalarFunction VARCHAR_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")}), "varcharToShortDecimal", "varcharToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_JSON_CAST = DecimalCasts.castFunctionFromDecimalTo(JsonType.JSON.getTypeSignature(), "shortDecimalToJson", "longDecimalToJson");
    public static final SqlScalarFunction JSON_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFromBuilder(JsonType.JSON.getTypeSignature(), true, "jsonToShortDecimal", "jsonToLongDecimal");
    private static final JsonFactory JSON_FACTORY = JsonUtil.createJsonFactory();
    public static final SqlScalarFunction DECIMAL_TO_VARCHAR_CAST = new PolymorphicScalarFunctionBuilder(OperatorType.CAST, DecimalCasts.class).signature(Signature.builder().argumentType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"precision"), TypeSignatureParameter.typeVariable((String)"scale")})).returnType(new TypeSignature("varchar", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"x")})).build()).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods("shortDecimalToVarchar", "longDecimalToVarchar").withExtraParameters(context -> {
        long scale = context.getLiteral("scale");
        VarcharType resultType = (VarcharType)context.getReturnType();
        long length = resultType.isUnbounded() ? Integer.MAX_VALUE : (long)resultType.getBoundedLength();
        return ImmutableList.of((Object)scale, (Object)length);
    }))).build();

    private static SqlScalarFunction castFunctionFromDecimalTo(TypeSignature to, String ... methodNames) {
        Signature signature = Signature.builder().argumentType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"precision"), TypeSignatureParameter.typeVariable((String)"scale")})).returnType(to).build();
        return new PolymorphicScalarFunctionBuilder(OperatorType.CAST, DecimalCasts.class).signature(signature).deterministic(true).choice(choice -> choice.implementation(methodsGroup -> methodsGroup.methods(methodNames).withExtraParameters(context -> {
            long precision = context.getLiteral("precision");
            long scale = context.getLiteral("scale");
            Object tenToScale = ((DecimalType)context.getParameterTypes().get(0)).isShort() ? Long.valueOf(Decimals.longTenToNth((int)DecimalConversions.intScale((long)scale))) : Int128Math.powerOfTen((int)DecimalConversions.intScale((long)scale));
            return ImmutableList.of((Object)precision, (Object)scale, (Object)tenToScale);
        }))).build();
    }

    private static SqlScalarFunction castFunctionToDecimalFrom(TypeSignature from, String ... methodNames) {
        return DecimalCasts.castFunctionToDecimalFromBuilder(from, false, methodNames);
    }

    private static SqlScalarFunction castFunctionToDecimalFromBuilder(TypeSignature from, boolean nullableResult, String ... methodNames) {
        Signature signature = Signature.builder().argumentType(from).returnType(new TypeSignature("decimal", new TypeSignatureParameter[]{TypeSignatureParameter.typeVariable((String)"precision"), TypeSignatureParameter.typeVariable((String)"scale")})).build();
        return new PolymorphicScalarFunctionBuilder(OperatorType.CAST, DecimalCasts.class).signature(signature).nullableResult(nullableResult).deterministic(true).choice(choice -> choice.returnConvention(nullableResult ? InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN : InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL).implementation(methodsGroup -> methodsGroup.methods(methodNames).withExtraParameters(context -> {
            DecimalType resultType = (DecimalType)context.getReturnType();
            Object tenToScale = resultType.isShort() ? Long.valueOf(Decimals.longTenToNth((int)resultType.getScale())) : Int128Math.powerOfTen((int)resultType.getScale());
            return ImmutableList.of((Object)resultType.getPrecision(), (Object)resultType.getScale(), (Object)tenToScale);
        }))).build();
    }

    private DecimalCasts() {
    }

    @UsedByGeneratedCode
    public static boolean shortDecimalToBoolean(long decimal, long precision, long scale, long tenToScale) {
        return decimal != 0L;
    }

    @UsedByGeneratedCode
    public static boolean longDecimalToBoolean(Int128 decimal, long precision, long scale, Int128 tenToScale) {
        return !decimal.isZero();
    }

    @UsedByGeneratedCode
    public static long booleanToShortDecimal(boolean value, long precision, long scale, long tenToScale) {
        return value ? tenToScale : 0L;
    }

    @UsedByGeneratedCode
    public static Int128 booleanToLongDecimal(boolean value, long precision, long scale, Int128 tenToScale) {
        return value ? tenToScale : Int128.ZERO;
    }

    @UsedByGeneratedCode
    public static long shortDecimalToBigint(long decimal, long precision, long scale, long tenToScale) {
        if (decimal >= 0L) {
            return (decimal + tenToScale / 2L) / tenToScale;
        }
        return -((-decimal + tenToScale / 2L) / tenToScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToBigint(Int128 decimal, long precision, long scale, Int128 tenToScale) {
        try {
            return Int128Math.rescale((Int128)decimal, (int)DecimalConversions.intScale((long)(-scale))).toLongExact();
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to BIGINT", Decimals.toString((Int128)decimal, (int)DecimalConversions.intScale((long)scale))));
        }
    }

    @UsedByGeneratedCode
    public static long bigintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Int128 bigintToLongDecimal(long value, long precision, long scale, Int128 tenToScale) {
        try {
            Int128 result = Int128Math.multiply((Int128)tenToScale, (long)value);
            if (Decimals.overflows((Int128)result, (int)((int)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToInteger(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return Math.toIntExact(longResult);
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INTEGER", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToInteger(Int128 decimal, long precision, long scale, Int128 tenToScale) {
        try {
            return Math.toIntExact(Int128Math.rescale((Int128)decimal, (int)DecimalConversions.intScale((long)(-scale))).toLongExact());
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INTEGER", Decimals.toString((Int128)decimal, (int)DecimalConversions.intScale((long)scale))));
        }
    }

    @UsedByGeneratedCode
    public static long integerToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Int128 integerToLongDecimal(long value, long precision, long scale, Int128 tenToScale) {
        try {
            Int128 result = Int128Math.multiply((Int128)tenToScale, (long)value);
            if (Decimals.overflows((Int128)result, (int)((int)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToSmallint(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return Shorts.checkedCast((long)longResult);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToSmallint(Int128 decimal, long precision, long scale, Int128 tenToScale) {
        try {
            Int128 decimal1 = Int128Math.rescale((Int128)decimal, (int)DecimalConversions.intScale((long)(-scale)));
            return Shorts.checkedCast((long)decimal1.toLongExact());
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", Decimals.toString((Int128)decimal, (int)DecimalConversions.intScale((long)scale))));
        }
    }

    @UsedByGeneratedCode
    public static long smallintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Int128 smallintToLongDecimal(long value, long precision, long scale, Int128 tenToScale) {
        try {
            Int128 result = Int128Math.multiply((Int128)tenToScale, (long)value);
            if (Decimals.overflows((Int128)result, (int)((int)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static long shortDecimalToTinyint(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return SignedBytes.checkedCast((long)longResult);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToTinyint(Int128 decimal, long precision, long scale, Int128 tenToScale) {
        try {
            return SignedBytes.checkedCast((long)Int128Math.rescale((Int128)decimal, (int)DecimalConversions.intScale((long)(-scale))).toLongExact());
        }
        catch (ArithmeticException | IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", Decimals.toString((Int128)decimal, (int)DecimalConversions.intScale((long)scale))));
        }
    }

    @UsedByGeneratedCode
    public static long tinyintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)DecimalConversions.intScale((long)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Int128 tinyintToLongDecimal(long value, long precision, long scale, Int128 tenToScale) {
        try {
            Int128 result = Int128Math.multiply((Int128)tenToScale, (long)value);
            if (Decimals.overflows((Int128)result, (int)((int)precision))) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return result;
        }
        catch (ArithmeticException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static double shortDecimalToDouble(long decimal, long precision, long scale, long tenToScale) {
        return (double)decimal / (double)tenToScale;
    }

    @UsedByGeneratedCode
    public static double longDecimalToDouble(Int128 decimal, long precision, long scale, Int128 tenToScale) {
        return DecimalConversions.longDecimalToDouble((Int128)decimal, (long)scale);
    }

    @UsedByGeneratedCode
    public static long shortDecimalToReal(long decimal, long precision, long scale, long tenToScale) {
        return DecimalConversions.shortDecimalToReal((long)decimal, (long)tenToScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToReal(Int128 decimal, long precision, long scale, Int128 tenToScale) {
        return DecimalConversions.longDecimalToReal((Int128)decimal, (long)scale);
    }

    @UsedByGeneratedCode
    public static long doubleToShortDecimal(double value, long precision, long scale, long tenToScale) {
        return DecimalConversions.doubleToShortDecimal((double)value, (long)precision, (long)scale);
    }

    @UsedByGeneratedCode
    public static Int128 doubleToLongDecimal(double value, long precision, long scale, Int128 tenToScale) {
        return DecimalConversions.doubleToLongDecimal((double)value, (long)precision, (long)scale);
    }

    @UsedByGeneratedCode
    public static long realToShortDecimal(long value, long precision, long scale, long tenToScale) {
        float floatValue = Float.intBitsToFloat((int)value);
        return DecimalConversions.realToShortDecimal((float)floatValue, (long)precision, (long)scale);
    }

    @UsedByGeneratedCode
    public static Int128 realToLongDecimal(long value, long precision, long scale, Int128 tenToScale) {
        float floatValue = Float.intBitsToFloat((int)value);
        return DecimalConversions.realToLongDecimal((float)floatValue, (long)precision, (long)scale);
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToVarchar(long decimal, long scale, long varcharLength) {
        String stringValue = Decimals.toString((long)decimal, (int)DecimalConversions.intScale((long)scale));
        if ((long)stringValue.length() <= varcharLength) {
            return Slices.utf8Slice((String)stringValue);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Value %s cannot be represented as varchar(%s)", stringValue, varcharLength));
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToVarchar(Int128 decimal, long scale, long varcharLength) {
        String stringValue = Decimals.toString((Int128)decimal, (int)DecimalConversions.intScale((long)scale));
        if ((long)stringValue.length() <= varcharLength) {
            return Slices.utf8Slice((String)stringValue);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Value %s cannot be represented as varchar(%s)", stringValue, varcharLength));
    }

    @UsedByGeneratedCode
    public static long varcharToShortDecimal(Slice value, long precision, long scale, long tenToScale) {
        BigDecimal result;
        String stringValue = value.toString(StandardCharsets.UTF_8);
        try {
            result = new BigDecimal(stringValue).setScale(DecimalConversions.intScale((long)scale), RoundingMode.HALF_UP);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value is not a number.", stringValue, precision, scale));
        }
        if (Decimals.overflows((BigDecimal)result, (long)precision)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value too large.", stringValue, precision, scale));
        }
        return result.unscaledValue().longValue();
    }

    @UsedByGeneratedCode
    public static Int128 varcharToLongDecimal(Slice value, long precision, long scale, Int128 tenToScale) {
        BigDecimal result;
        String stringValue = value.toString(StandardCharsets.UTF_8);
        try {
            result = new BigDecimal(stringValue).setScale(DecimalConversions.intScale((long)scale), RoundingMode.HALF_UP);
        }
        catch (NumberFormatException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value is not a number.", stringValue, precision, scale));
        }
        if (Decimals.overflows((BigDecimal)result, (long)precision)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s). Value too large.", stringValue, precision, scale));
        }
        return Int128.valueOf((BigInteger)result.unscaledValue());
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToJson(long decimal, long precision, long scale, long tenToScale) {
        return DecimalCasts.decimalToJson(BigDecimal.valueOf(decimal, DecimalConversions.intScale((long)scale)));
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToJson(Int128 decimal, long precision, long scale, Int128 tenToScale) {
        return DecimalCasts.decimalToJson(new BigDecimal(decimal.toBigInteger(), DecimalConversions.intScale((long)scale)));
    }

    private static Slice decimalToJson(BigDecimal bigDecimal) {
        try {
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)dynamicSliceOutput);){
                jsonGenerator.writeNumber(bigDecimal);
            }
            return dynamicSliceOutput.slice();
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%f' to %s", bigDecimal, "json"));
        }
    }

    @UsedByGeneratedCode
    public static Int128 jsonToLongDecimal(Slice json, long precision, long scale, Int128 tenToScale) {
        Int128 int128;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Int128 result = JsonUtil.currentTokenAsLongDecimal(parser, DecimalCasts.intPrecision(precision), DecimalConversions.intScale((long)scale));
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DECIMAL(%s,%s)", precision, scale);
                int128 = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException | NumberFormatException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DECIMAL(%s,%s)", json.toStringUtf8(), precision, scale), (Throwable)e);
                }
            }
            parser.close();
        }
        return int128;
    }

    @UsedByGeneratedCode
    public static Long jsonToShortDecimal(Slice json, long precision, long scale, long tenToScale) {
        Long l;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Long result = JsonUtil.currentTokenAsShortDecimal(parser, DecimalCasts.intPrecision(precision), DecimalConversions.intScale((long)scale));
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DECIMAL(%s,%s)", precision, scale);
                l = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException | NumberFormatException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DECIMAL(%s,%s)", json.toStringUtf8(), precision, scale), (Throwable)e);
                }
            }
            parser.close();
        }
        return l;
    }

    private static int intPrecision(long precision) {
        return (int)precision;
    }
}

