/*
 * Decompiled with CFR 0.152.
 */
package io.trino.transaction;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.transaction.IsolationLevel;
import io.trino.transaction.TransactionId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTime;

public class TransactionInfo {
    private final TransactionId transactionId;
    private final IsolationLevel isolationLevel;
    private final boolean readOnly;
    private final boolean autoCommitContext;
    private final DateTime createTime;
    private final Duration idleTime;
    private final List<String> catalogNames;
    private final Optional<String> writtenCatalogName;
    private final Set<CatalogHandle> activeCatalogs;

    public TransactionInfo(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext, DateTime createTime, Duration idleTime, List<String> catalogNames, Optional<String> writtenCatalogName, Set<CatalogHandle> activeCatalogs) {
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.isolationLevel = Objects.requireNonNull(isolationLevel, "isolationLevel is null");
        this.readOnly = readOnly;
        this.autoCommitContext = autoCommitContext;
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.idleTime = Objects.requireNonNull(idleTime, "idleTime is null");
        this.catalogNames = ImmutableList.copyOf((Collection)Objects.requireNonNull(catalogNames, "catalogNames is null"));
        this.writtenCatalogName = Objects.requireNonNull(writtenCatalogName, "writtenCatalogName is null");
        this.activeCatalogs = ImmutableSet.copyOf((Collection)Objects.requireNonNull(activeCatalogs, "activeCatalogs is null"));
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isAutoCommitContext() {
        return this.autoCommitContext;
    }

    public DateTime getCreateTime() {
        return this.createTime;
    }

    public Duration getIdleTime() {
        return this.idleTime;
    }

    public List<String> getCatalogNames() {
        return this.catalogNames;
    }

    public Optional<String> getWrittenCatalogName() {
        return this.writtenCatalogName;
    }

    public Set<CatalogHandle> getActiveCatalogs() {
        return this.activeCatalogs;
    }
}

