/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tracing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.Session;
import io.trino.metadata.AnalyzeMetadata;
import io.trino.metadata.AnalyzeTableHandle;
import io.trino.metadata.CatalogFunctionMetadata;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MergeHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.ResolvedIndex;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableFunctionHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TableSchema;
import io.trino.metadata.TableVersion;
import io.trino.metadata.ViewDefinition;
import io.trino.metadata.ViewInfo;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.EntityPrivilege;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.RelationType;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.connector.WriterScalingOptions;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.function.AggregationFunctionMetadata;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.tracing.ForTracing;
import io.trino.tracing.ScopedSpan;
import io.trino.tracing.TrinoAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class TracingMetadata
implements Metadata {
    private final Tracer tracer;
    private final Metadata delegate;

    @Inject
    public TracingMetadata(Tracer tracer, @ForTracing Metadata delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    @VisibleForTesting
    public Metadata getDelegate() {
        return this.delegate;
    }

    @Override
    public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogHandle catalogHandle) {
        Span span = this.startSpan("getConnectorCapabilities", catalogHandle.getCatalogName());
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Set<ConnectorCapabilities> set = this.delegate.getConnectorCapabilities(session, catalogHandle);
            return set;
        }
    }

    @Override
    public boolean catalogExists(Session session, String catalogName) {
        Span span = this.startSpan("catalogExists", catalogName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.catalogExists(session, catalogName);
            return bl;
        }
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        Span span = this.startSpan("schemaExists", schema);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.schemaExists(session, schema);
            return bl;
        }
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        Span span = this.startSpan("listSchemaNames", catalogName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            List<String> list = this.delegate.listSchemaNames(session, catalogName);
            return list;
        }
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
        Span span = this.startSpan("getTableHandle", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableHandle> optional = this.delegate.getTableHandle(session, tableName);
            return optional;
        }
    }

    @Override
    public Optional<SystemTable> getSystemTable(Session session, QualifiedObjectName tableName) {
        Span span = this.startSpan("getSystemTable", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<SystemTable> optional = this.delegate.getSystemTable(session, tableName);
            return optional;
        }
    }

    @Override
    public Optional<TableExecuteHandle> getTableHandleForExecute(Session session, TableHandle tableHandle, String procedureName, Map<String, Object> executeProperties) {
        Span span = this.startSpan("getTableHandleForExecute", tableHandle).setAttribute(TrinoAttributes.PROCEDURE, (Object)procedureName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableExecuteHandle> optional = this.delegate.getTableHandleForExecute(session, tableHandle, procedureName, executeProperties);
            return optional;
        }
    }

    @Override
    public Optional<TableLayout> getLayoutForTableExecute(Session session, TableExecuteHandle tableExecuteHandle) {
        Span span = this.startSpan("getLayoutForTableExecute", tableExecuteHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableLayout> optional = this.delegate.getLayoutForTableExecute(session, tableExecuteHandle);
            return optional;
        }
    }

    @Override
    public BeginTableExecuteResult<TableExecuteHandle, TableHandle> beginTableExecute(Session session, TableExecuteHandle handle, TableHandle updatedSourceTableHandle) {
        Span span = this.startSpan("beginTableExecute", handle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            BeginTableExecuteResult<TableExecuteHandle, TableHandle> beginTableExecuteResult = this.delegate.beginTableExecute(session, handle, updatedSourceTableHandle);
            return beginTableExecuteResult;
        }
    }

    @Override
    public void finishTableExecute(Session session, TableExecuteHandle handle, Collection<Slice> fragments, List<Object> tableExecuteState) {
        Span span = this.startSpan("finishTableExecute", handle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.finishTableExecute(session, handle, fragments, tableExecuteState);
        }
    }

    @Override
    public void executeTableExecute(Session session, TableExecuteHandle handle) {
        Span span = this.startSpan("executeTableExecute", handle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.executeTableExecute(session, handle);
        }
    }

    @Override
    public TableProperties getTableProperties(Session session, TableHandle handle) {
        Span span = this.startSpan("getTableProperties", handle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            TableProperties tableProperties = this.delegate.getTableProperties(session, handle);
            return tableProperties;
        }
    }

    @Override
    public TableHandle makeCompatiblePartitioning(Session session, TableHandle table, PartitioningHandle partitioningHandle) {
        Span span = this.startSpan("makeCompatiblePartitioning", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            TableHandle tableHandle = this.delegate.makeCompatiblePartitioning(session, table, partitioningHandle);
            return tableHandle;
        }
    }

    @Override
    public Optional<PartitioningHandle> getCommonPartitioning(Session session, PartitioningHandle left, PartitioningHandle right) {
        Span span = this.startSpan("getCommonPartitioning");
        if (span.isRecording() && left.getCatalogHandle().equals(right.getCatalogHandle()) && left.getCatalogHandle().isPresent()) {
            span.setAttribute(TrinoAttributes.CATALOG, (Object)left.getCatalogHandle().get().getCatalogName().toString());
        }
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<PartitioningHandle> optional = this.delegate.getCommonPartitioning(session, left, right);
            return optional;
        }
    }

    @Override
    public Optional<Object> getInfo(Session session, TableHandle handle) {
        Span span = this.startSpan("getInfo", handle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<Object> optional = this.delegate.getInfo(session, handle);
            return optional;
        }
    }

    @Override
    public CatalogSchemaTableName getTableName(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getTableName", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            CatalogSchemaTableName catalogSchemaTableName = this.delegate.getTableName(session, tableHandle);
            return catalogSchemaTableName;
        }
    }

    @Override
    public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getTableSchema", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            TableSchema tableSchema = this.delegate.getTableSchema(session, tableHandle);
            return tableSchema;
        }
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getTableMetadata", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            TableMetadata tableMetadata = this.delegate.getTableMetadata(session, tableHandle);
            return tableMetadata;
        }
    }

    @Override
    public TableStatistics getTableStatistics(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getTableStatistics", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            TableStatistics tableStatistics = this.delegate.getTableStatistics(session, tableHandle);
            return tableStatistics;
        }
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("listTables", prefix);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            List<QualifiedObjectName> list = this.delegate.listTables(session, prefix);
            return list;
        }
    }

    @Override
    public Map<SchemaTableName, RelationType> getRelationTypes(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("getRelationTypes", prefix);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Map<SchemaTableName, RelationType> map = this.delegate.getRelationTypes(session, prefix);
            return map;
        }
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getColumnHandles", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Map<String, ColumnHandle> map = this.delegate.getColumnHandles(session, tableHandle);
            return map;
        }
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Span span = this.startSpan("getColumnMetadata", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            ColumnMetadata columnMetadata = this.delegate.getColumnMetadata(session, tableHandle, columnHandle);
            return columnMetadata;
        }
    }

    @Override
    public List<TableColumnsMetadata> listTableColumns(Session session, QualifiedTablePrefix prefix, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        Span span = this.startSpan("listTableColumns", prefix);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            List<TableColumnsMetadata> list = this.delegate.listTableColumns(session, prefix, relationFilter);
            return list;
        }
    }

    @Override
    public List<RelationCommentMetadata> listRelationComments(Session session, String catalogName, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        Span span = this.startSpan("listRelationComments", new QualifiedTablePrefix(catalogName, schemaName, Optional.empty()));
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            List<RelationCommentMetadata> list = this.delegate.listRelationComments(session, catalogName, schemaName, relationFilter);
            return list;
        }
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
        Span span = this.startSpan("createSchema", schema);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.createSchema(session, schema, properties, principal);
        }
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema, boolean cascade) {
        Span span = this.startSpan("dropSchema", schema);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropSchema(session, schema, cascade);
        }
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        Span span = this.startSpan("renameSchema", source);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.renameSchema(session, source, target);
        }
    }

    @Override
    public void setSchemaAuthorization(Session session, CatalogSchemaName source, TrinoPrincipal principal) {
        Span span = this.startSpan("setSchemaAuthorization", source);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setSchemaAuthorization(session, source, principal);
        }
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        Span span = this.startSpan("createTable", catalogName, tableMetadata);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.createTable(session, catalogName, tableMetadata, saveMode);
        }
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, CatalogSchemaTableName currentTableName, QualifiedObjectName newTableName) {
        Span span = this.startSpan("renameTable", currentTableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.renameTable(session, tableHandle, currentTableName, newTableName);
        }
    }

    @Override
    public void setTableProperties(Session session, TableHandle tableHandle, Map<String, Optional<Object>> properties) {
        Span span = this.startSpan("setTableProperties", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setTableProperties(session, tableHandle, properties);
        }
    }

    @Override
    public void setTableComment(Session session, TableHandle tableHandle, Optional<String> comment) {
        Span span = this.startSpan("setTableComment", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setTableComment(session, tableHandle, comment);
        }
    }

    @Override
    public void setViewComment(Session session, QualifiedObjectName viewName, Optional<String> comment) {
        Span span = this.startSpan("setViewComment", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setViewComment(session, viewName, comment);
        }
    }

    @Override
    public void setViewColumnComment(Session session, QualifiedObjectName viewName, String columnName, Optional<String> comment) {
        Span span = this.startSpan("setViewColumnComment", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setViewColumnComment(session, viewName, columnName, comment);
        }
    }

    @Override
    public void setColumnComment(Session session, TableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        Span span = this.startSpan("setColumnComment", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setColumnComment(session, tableHandle, column, comment);
        }
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnHandle source, String target) {
        Span span = this.startSpan("renameColumn", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.renameColumn(session, tableHandle, table, source, target);
        }
    }

    @Override
    public void renameField(Session session, TableHandle tableHandle, List<String> fieldPath, String target) {
        Span span = this.startSpan("renameField", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.renameField(session, tableHandle, fieldPath, target);
        }
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnMetadata column) {
        Span span = this.startSpan("addColumn", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.addColumn(session, tableHandle, table, column);
        }
    }

    @Override
    public void addField(Session session, TableHandle tableHandle, List<String> parentPath, String fieldName, Type type, boolean ignoreExisting) {
        Span span = this.startSpan("addField", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.addField(session, tableHandle, parentPath, fieldName, type, ignoreExisting);
        }
    }

    @Override
    public void setColumnType(Session session, TableHandle tableHandle, ColumnHandle column, Type type) {
        Span span = this.startSpan("setColumnType", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setColumnType(session, tableHandle, column, type);
        }
    }

    @Override
    public void setFieldType(Session session, TableHandle tableHandle, List<String> fieldPath, Type type) {
        Span span = this.startSpan("setFieldType", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setFieldType(session, tableHandle, fieldPath, type);
        }
    }

    @Override
    public void dropNotNullConstraint(Session session, TableHandle tableHandle, ColumnHandle column) {
        Span span = this.startSpan("dropNotNullConstraint", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropNotNullConstraint(session, tableHandle, column);
        }
    }

    @Override
    public void setTableAuthorization(Session session, CatalogSchemaTableName table, TrinoPrincipal principal) {
        Span span = this.startSpan("setTableAuthorization", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setTableAuthorization(session, table, principal);
        }
    }

    @Override
    public void dropColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnHandle column) {
        Span span = this.startSpan("dropColumn", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropColumn(session, tableHandle, table, column);
        }
    }

    @Override
    public void dropField(Session session, TableHandle tableHandle, ColumnHandle column, List<String> fieldPath) {
        Span span = this.startSpan("dropField", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropField(session, tableHandle, column, fieldPath);
        }
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle, CatalogSchemaTableName tableName) {
        Span span = this.startSpan("dropTable", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropTable(session, tableHandle, tableName);
        }
    }

    @Override
    public void truncateTable(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("truncateTable", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.truncateTable(session, tableHandle);
        }
    }

    @Override
    public Optional<TableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        Span span = this.startSpan("getNewTableLayout", catalogName, tableMetadata);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableLayout> optional = this.delegate.getNewTableLayout(session, catalogName, tableMetadata);
            return optional;
        }
    }

    @Override
    public Optional<Type> getSupportedType(Session session, CatalogHandle catalogHandle, Map<String, Object> tableProperties, Type type) {
        Span span = this.startSpan("getSupportedType", catalogHandle.getCatalogName());
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<Type> optional = this.delegate.getSupportedType(session, catalogHandle, tableProperties, type);
            return optional;
        }
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<TableLayout> layout, boolean replace) {
        Span span = this.startSpan("beginCreateTable", catalogName, tableMetadata);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            OutputTableHandle outputTableHandle = this.delegate.beginCreateTable(session, catalogName, tableMetadata, layout, replace);
            return outputTableHandle;
        }
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Span span = this.startSpan("finishCreateTable", tableHandle.catalogHandle().getCatalogName());
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.TABLE, (Object)tableHandle.connectorHandle().toString());
        }
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<ConnectorOutputMetadata> optional = this.delegate.finishCreateTable(session, tableHandle, fragments, computedStatistics);
            return optional;
        }
    }

    @Override
    public Optional<TableLayout> getInsertLayout(Session session, TableHandle target) {
        Span span = this.startSpan("getInsertLayout", target);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableLayout> optional = this.delegate.getInsertLayout(session, target);
            return optional;
        }
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session session, CatalogHandle catalogHandle, ConnectorTableMetadata tableMetadata) {
        Span span = this.startSpan("getStatisticsCollectionMetadataForWrite", catalogHandle.getCatalogName().toString(), tableMetadata);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            TableStatisticsMetadata tableStatisticsMetadata = this.delegate.getStatisticsCollectionMetadataForWrite(session, catalogHandle, tableMetadata);
            return tableStatisticsMetadata;
        }
    }

    @Override
    public AnalyzeMetadata getStatisticsCollectionMetadata(Session session, TableHandle tableHandle, Map<String, Object> analyzeProperties) {
        Span span = this.startSpan("getStatisticsCollectionMetadata", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            AnalyzeMetadata analyzeMetadata = this.delegate.getStatisticsCollectionMetadata(session, tableHandle, analyzeProperties);
            return analyzeMetadata;
        }
    }

    @Override
    public AnalyzeTableHandle beginStatisticsCollection(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("beginStatisticsCollection", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            AnalyzeTableHandle analyzeTableHandle = this.delegate.beginStatisticsCollection(session, tableHandle);
            return analyzeTableHandle;
        }
    }

    @Override
    public void finishStatisticsCollection(Session session, AnalyzeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        Span span = this.startSpan("finishStatisticsCollection", tableHandle.catalogHandle().getCatalogName());
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.TABLE, (Object)tableHandle.connectorHandle().toString());
        }
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.finishStatisticsCollection(session, tableHandle, computedStatistics);
        }
    }

    @Override
    public void beginQuery(Session session) {
        Span span = this.startSpan("beginQuery");
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.beginQuery(session);
        }
    }

    @Override
    public void cleanupQuery(Session session) {
        Span span = this.startSpan("cleanupQuery");
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.cleanupQuery(session);
        }
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle, List<ColumnHandle> columns) {
        Span span = this.startSpan("beginInsert", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            InsertTableHandle insertTableHandle = this.delegate.beginInsert(session, tableHandle, columns);
            return insertTableHandle;
        }
    }

    @Override
    public boolean supportsMissingColumnsOnInsert(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("supportsMissingColumnsOnInsert", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.supportsMissingColumnsOnInsert(session, tableHandle);
            return bl;
        }
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, List<TableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Span span = this.startSpan("finishInsert", tableHandle.catalogHandle().getCatalogName());
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.TABLE, (Object)tableHandle.connectorHandle().toString());
        }
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<ConnectorOutputMetadata> optional = this.delegate.finishInsert(session, tableHandle, sourceTableHandles, fragments, computedStatistics);
            return optional;
        }
    }

    @Override
    public boolean delegateMaterializedViewRefreshToConnector(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("delegateMaterializedViewRefreshToConnector", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.delegateMaterializedViewRefreshToConnector(session, viewName);
            return bl;
        }
    }

    @Override
    public ListenableFuture<Void> refreshMaterializedView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("refreshMaterializedView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            ListenableFuture<Void> listenableFuture = this.delegate.refreshMaterializedView(session, viewName);
            return listenableFuture;
        }
    }

    @Override
    public InsertTableHandle beginRefreshMaterializedView(Session session, TableHandle tableHandle, List<TableHandle> sourceTableHandles) {
        Span span = this.startSpan("beginRefreshMaterializedView", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            InsertTableHandle insertTableHandle = this.delegate.beginRefreshMaterializedView(session, tableHandle, sourceTableHandles);
            return insertTableHandle;
        }
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(Session session, TableHandle tableHandle, InsertTableHandle insertTableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<TableHandle> sourceTableHandles, List<String> sourceTableFunctions) {
        Span span = this.startSpan("finishRefreshMaterializedView", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<ConnectorOutputMetadata> optional = this.delegate.finishRefreshMaterializedView(session, tableHandle, insertTableHandle, fragments, computedStatistics, sourceTableHandles, sourceTableFunctions);
            return optional;
        }
    }

    @Override
    public Optional<TableHandle> applyUpdate(Session session, TableHandle tableHandle, Map<ColumnHandle, Constant> assignments) {
        Span span = this.startSpan("applyUpdate", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableHandle> optional = this.delegate.applyUpdate(session, tableHandle, assignments);
            return optional;
        }
    }

    @Override
    public OptionalLong executeUpdate(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("executeUpdate", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            OptionalLong optionalLong = this.delegate.executeUpdate(session, tableHandle);
            return optionalLong;
        }
    }

    @Override
    public Optional<TableHandle> applyDelete(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("applyDelete", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableHandle> optional = this.delegate.applyDelete(session, tableHandle);
            return optional;
        }
    }

    @Override
    public OptionalLong executeDelete(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("executeDelete", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            OptionalLong optionalLong = this.delegate.executeDelete(session, tableHandle);
            return optionalLong;
        }
    }

    @Override
    public RowChangeParadigm getRowChangeParadigm(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getRowChangeParadigm", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            RowChangeParadigm rowChangeParadigm = this.delegate.getRowChangeParadigm(session, tableHandle);
            return rowChangeParadigm;
        }
    }

    @Override
    public ColumnHandle getMergeRowIdColumnHandle(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getMergeRowIdColumnHandle", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            ColumnHandle columnHandle = this.delegate.getMergeRowIdColumnHandle(session, tableHandle);
            return columnHandle;
        }
    }

    @Override
    public Optional<PartitioningHandle> getUpdateLayout(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getUpdateLayout", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<PartitioningHandle> optional = this.delegate.getUpdateLayout(session, tableHandle);
            return optional;
        }
    }

    @Override
    public MergeHandle beginMerge(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("beginMerge", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            MergeHandle mergeHandle = this.delegate.beginMerge(session, tableHandle);
            return mergeHandle;
        }
    }

    @Override
    public void finishMerge(Session session, MergeHandle tableHandle, List<TableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Span span = this.startSpan("finishMerge", tableHandle.tableHandle().catalogHandle().getCatalogName());
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.TABLE, (Object)tableHandle.tableHandle().connectorHandle().toString());
        }
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.finishMerge(session, tableHandle, sourceTableHandles, fragments, computedStatistics);
        }
    }

    @Override
    public Optional<CatalogHandle> getCatalogHandle(Session session, String catalogName) {
        Span span = this.startSpan("getCatalogHandle", catalogName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<CatalogHandle> optional = this.delegate.getCatalogHandle(session, catalogName);
            return optional;
        }
    }

    @Override
    public List<CatalogInfo> listCatalogs(Session session) {
        Span span = this.startSpan("listCatalogs");
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            List<CatalogInfo> list = this.delegate.listCatalogs(session);
            return list;
        }
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("listViews", prefix);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            List<QualifiedObjectName> list = this.delegate.listViews(session, prefix);
            return list;
        }
    }

    @Override
    public Map<QualifiedObjectName, ViewInfo> getViews(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("getViews", prefix);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Map<QualifiedObjectName, ViewInfo> map = this.delegate.getViews(session, prefix);
            return map;
        }
    }

    @Override
    public boolean isView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("isView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.isView(session, viewName);
            return bl;
        }
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("getView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<ViewDefinition> optional = this.delegate.getView(session, viewName);
            return optional;
        }
    }

    @Override
    public Map<String, Object> getViewProperties(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("getViewProperties", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Map<String, Object> map = this.delegate.getViewProperties(session, viewName);
            return map;
        }
    }

    @Override
    public Map<String, Object> getSchemaProperties(Session session, CatalogSchemaName schemaName) {
        Span span = this.startSpan("getSchemaProperties", schemaName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Map<String, Object> map = this.delegate.getSchemaProperties(session, schemaName);
            return map;
        }
    }

    @Override
    public Optional<TrinoPrincipal> getSchemaOwner(Session session, CatalogSchemaName schemaName) {
        Span span = this.startSpan("getSchemaOwner", schemaName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TrinoPrincipal> optional = this.delegate.getSchemaOwner(session, schemaName);
            return optional;
        }
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, ViewDefinition definition, Map<String, Object> properties, boolean replace) {
        Span span = this.startSpan("createView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.createView(session, viewName, definition, properties, replace);
        }
    }

    @Override
    public void renameView(Session session, QualifiedObjectName existingViewName, QualifiedObjectName newViewName) {
        Span span = this.startSpan("renameView", existingViewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.renameView(session, existingViewName, newViewName);
        }
    }

    @Override
    public void setViewAuthorization(Session session, CatalogSchemaTableName view, TrinoPrincipal principal) {
        Span span = this.startSpan("setViewAuthorization", view);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setViewAuthorization(session, view, principal);
        }
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("dropView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropView(session, viewName);
        }
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        Span span = this.startSpan("resolveIndex", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<ResolvedIndex> optional = this.delegate.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain);
            return optional;
        }
    }

    @Override
    public Optional<LimitApplicationResult<TableHandle>> applyLimit(Session session, TableHandle table, long limit) {
        Span span = this.startSpan("applyLimit", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<LimitApplicationResult<TableHandle>> optional = this.delegate.applyLimit(session, table, limit);
            return optional;
        }
    }

    @Override
    public Optional<ConstraintApplicationResult<TableHandle>> applyFilter(Session session, TableHandle table, Constraint constraint) {
        Span span = this.startSpan("applyFilter", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<ConstraintApplicationResult<TableHandle>> optional = this.delegate.applyFilter(session, table, constraint);
            return optional;
        }
    }

    @Override
    public Optional<ProjectionApplicationResult<TableHandle>> applyProjection(Session session, TableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        Span span = this.startSpan("applyProjection", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<ProjectionApplicationResult<TableHandle>> optional = this.delegate.applyProjection(session, table, projections, assignments);
            return optional;
        }
    }

    @Override
    public Optional<SampleApplicationResult<TableHandle>> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
        Span span = this.startSpan("applySample", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<SampleApplicationResult<TableHandle>> optional = this.delegate.applySample(session, table, sampleType, sampleRatio);
            return optional;
        }
    }

    @Override
    public Optional<AggregationApplicationResult<TableHandle>> applyAggregation(Session session, TableHandle table, List<AggregateFunction> aggregations, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        Span span = this.startSpan("applyAggregation", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<AggregationApplicationResult<TableHandle>> optional = this.delegate.applyAggregation(session, table, aggregations, assignments, groupingSets);
            return optional;
        }
    }

    @Override
    public Optional<JoinApplicationResult<TableHandle>> applyJoin(Session session, JoinType joinType, TableHandle left, TableHandle right, ConnectorExpression joinCondition, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        Span span = this.startSpan("applyJoin");
        if (span.isRecording() && left.catalogHandle().equals((Object)right.catalogHandle())) {
            span.setAttribute(TrinoAttributes.CATALOG, (Object)left.catalogHandle().getCatalogName().toString());
        }
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<JoinApplicationResult<TableHandle>> optional = this.delegate.applyJoin(session, joinType, left, right, joinCondition, leftAssignments, rightAssignments, statistics);
            return optional;
        }
    }

    @Override
    public Optional<TopNApplicationResult<TableHandle>> applyTopN(Session session, TableHandle handle, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        Span span = this.startSpan("applyTopN", handle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TopNApplicationResult<TableHandle>> optional = this.delegate.applyTopN(session, handle, topNCount, sortItems, assignments);
            return optional;
        }
    }

    @Override
    public Optional<TableFunctionApplicationResult<TableHandle>> applyTableFunction(Session session, TableFunctionHandle handle) {
        Span span = this.startSpan("applyTableFunction").setAttribute(TrinoAttributes.CATALOG, (Object)handle.catalogHandle().getCatalogName().toString()).setAttribute(TrinoAttributes.HANDLE, (Object)handle.functionHandle().toString());
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableFunctionApplicationResult<TableHandle>> optional = this.delegate.applyTableFunction(session, handle);
            return optional;
        }
    }

    @Override
    public void validateScan(Session session, TableHandle table) {
        Span span = this.startSpan("validateScan", table);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.validateScan(session, table);
        }
    }

    @Override
    public boolean isCatalogManagedSecurity(Session session, String catalog) {
        Span span = this.startSpan("isCatalogManagedSecurity", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.isCatalogManagedSecurity(session, catalog);
            return bl;
        }
    }

    @Override
    public boolean roleExists(Session session, String role, Optional<String> catalog) {
        Span span = this.startSpan("roleExists", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.roleExists(session, role, catalog);
            return bl;
        }
    }

    @Override
    public void createRole(Session session, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        Span span = this.startSpan("createRole", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.createRole(session, role, grantor, catalog);
        }
    }

    @Override
    public void dropRole(Session session, String role, Optional<String> catalog) {
        Span span = this.startSpan("dropRole", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropRole(session, role, catalog);
        }
    }

    @Override
    public Set<String> listRoles(Session session, Optional<String> catalog) {
        Span span = this.startSpan("listRoles", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.listRoles(session, catalog);
            return set;
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(Session session, Optional<String> catalog, TrinoPrincipal principal) {
        Span span = this.startSpan("listRoleGrants", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Set<RoleGrant> set = this.delegate.listRoleGrants(session, catalog, principal);
            return set;
        }
    }

    @Override
    public void grantRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        Span span = this.startSpan("grantRoles", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.grantRoles(session, roles, grantees, adminOption, grantor, catalog);
        }
    }

    @Override
    public void revokeRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        Span span = this.startSpan("revokeRoles", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.revokeRoles(session, roles, grantees, adminOption, grantor, catalog);
        }
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(Session session, TrinoPrincipal principal, Optional<String> catalog) {
        Span span = this.startSpan("listApplicableRoles", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Set<RoleGrant> set = this.delegate.listApplicableRoles(session, principal, catalog);
            return set;
        }
    }

    @Override
    public Set<String> listEnabledRoles(Identity identity) {
        Span span = this.startSpan("listEnabledRoles");
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.listEnabledRoles(identity);
            return set;
        }
    }

    @Override
    public Set<String> listEnabledRoles(Session session, String catalog) {
        Span span = this.startSpan("listEnabledRoles", catalog);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.listEnabledRoles(session, catalog);
            return set;
        }
    }

    @Override
    public void grantSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("grantSchemaPrivileges", schemaName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.grantSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
        }
    }

    @Override
    public void denySchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        Span span = this.startSpan("denySchemaPrivileges", schemaName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.denySchemaPrivileges(session, schemaName, privileges, grantee);
        }
    }

    @Override
    public void revokeSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("revokeSchemaPrivileges", schemaName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.revokeSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
        }
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("grantTablePrivileges", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    @Override
    public void denyTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        Span span = this.startSpan("denyTablePrivileges", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.denyTablePrivileges(session, tableName, privileges, grantee);
        }
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("revokeTablePrivileges", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.revokeTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    @Override
    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("listTablePrivileges", prefix);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            List<GrantInfo> list = this.delegate.listTablePrivileges(session, prefix);
            return list;
        }
    }

    @Override
    public Set<EntityPrivilege> getAllEntityKindPrivileges(String entityKind) {
        return this.delegate.getAllEntityKindPrivileges(entityKind);
    }

    @Override
    public void grantEntityPrivileges(Session session, EntityKindAndName entity, Set<EntityPrivilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("grantEntityPrivileges", entity, privileges, grantee, grantOption);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.grantEntityPrivileges(session, entity, privileges, grantee, grantOption);
        }
    }

    @Override
    public void denyEntityPrivileges(Session session, EntityKindAndName entity, Set<EntityPrivilege> privileges, TrinoPrincipal grantee) {
        Span span = this.startSpan("denyEntityPrivileges", entity, privileges, grantee, false);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.denyEntityPrivileges(session, entity, privileges, grantee);
        }
    }

    @Override
    public void revokeEntityPrivileges(Session session, EntityKindAndName entity, Set<EntityPrivilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("revokeEntityPrivileges", entity, privileges, grantee, grantOption);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.revokeEntityPrivileges(session, entity, privileges, grantee, grantOption);
        }
    }

    @Override
    public Collection<FunctionMetadata> listGlobalFunctions(Session session) {
        Span span = this.startSpan("listGlobalFunctions");
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Collection<FunctionMetadata> collection = this.delegate.listGlobalFunctions(session);
            return collection;
        }
    }

    @Override
    public Collection<FunctionMetadata> listFunctions(Session session, CatalogSchemaName schema) {
        Span span = this.startSpan("listFunctions", schema);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Collection<FunctionMetadata> collection = this.delegate.listFunctions(session, schema);
            return collection;
        }
    }

    @Override
    public Collection<CatalogFunctionMetadata> getFunctions(Session session, CatalogSchemaFunctionName catalogSchemaFunctionName) {
        Span span = this.startSpan("getFunctions", catalogSchemaFunctionName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Collection<CatalogFunctionMetadata> collection = this.delegate.getFunctions(session, catalogSchemaFunctionName);
            return collection;
        }
    }

    @Override
    public ResolvedFunction resolveBuiltinFunction(String name, List<TypeSignatureProvider> parameterTypes) {
        Span span = this.startSpan("resolveBuiltinFunction").setAttribute(TrinoAttributes.FUNCTION, (Object)name);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            ResolvedFunction resolvedFunction = this.delegate.resolveBuiltinFunction(name, parameterTypes);
            return resolvedFunction;
        }
    }

    @Override
    public ResolvedFunction resolveOperator(OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.delegate.resolveOperator(operatorType, argumentTypes);
    }

    @Override
    public ResolvedFunction getCoercion(Type fromType, Type toType) {
        return this.delegate.getCoercion(fromType, toType);
    }

    @Override
    public ResolvedFunction getCoercion(OperatorType operatorType, Type fromType, Type toType) {
        return this.delegate.getCoercion(operatorType, fromType, toType);
    }

    @Override
    public ResolvedFunction getCoercion(CatalogSchemaFunctionName name, Type fromType, Type toType) {
        return this.delegate.getCoercion(name, fromType, toType);
    }

    @Override
    public AggregationFunctionMetadata getAggregationFunctionMetadata(Session session, ResolvedFunction resolvedFunction) {
        Span span = this.startSpan("getAggregationFunctionMetadata").setAttribute(TrinoAttributes.CATALOG, (Object)resolvedFunction.catalogHandle().getCatalogName().toString()).setAttribute(TrinoAttributes.FUNCTION, (Object)resolvedFunction.signature().getName().toString());
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            AggregationFunctionMetadata aggregationFunctionMetadata = this.delegate.getAggregationFunctionMetadata(session, resolvedFunction);
            return aggregationFunctionMetadata;
        }
    }

    @Override
    public FunctionDependencyDeclaration getFunctionDependencies(Session session, CatalogHandle catalogHandle, FunctionId functionId, BoundSignature boundSignature) {
        Span span = this.startSpan("getFunctionDependencies", catalogHandle.getCatalogName()).setAttribute(TrinoAttributes.FUNCTION, (Object)functionId.toString());
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            FunctionDependencyDeclaration functionDependencyDeclaration = this.delegate.getFunctionDependencies(session, catalogHandle, functionId, boundSignature);
            return functionDependencyDeclaration;
        }
    }

    @Override
    public Collection<LanguageFunction> getLanguageFunctions(Session session, QualifiedObjectName name) {
        Span span = this.startSpan("getLanguageFunctions", name);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Collection<LanguageFunction> collection = this.delegate.getLanguageFunctions(session, name);
            return collection;
        }
    }

    @Override
    public boolean languageFunctionExists(Session session, QualifiedObjectName name, String signatureToken) {
        Span span = this.startSpan("languageFunctionExists", name);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.languageFunctionExists(session, name, signatureToken);
            return bl;
        }
    }

    @Override
    public void createLanguageFunction(Session session, QualifiedObjectName name, LanguageFunction function, boolean replace) {
        Span span = this.startSpan("createLanguageFunction", name);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.createLanguageFunction(session, name, function, replace);
        }
    }

    @Override
    public void dropLanguageFunction(Session session, QualifiedObjectName name, String signatureToken) {
        Span span = this.startSpan("dropLanguageFunction", name);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropLanguageFunction(session, name, signatureToken);
        }
    }

    @Override
    public void createMaterializedView(Session session, QualifiedObjectName viewName, MaterializedViewDefinition definition, Map<String, Object> properties, boolean replace, boolean ignoreExisting) {
        Span span = this.startSpan("createMaterializedView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.createMaterializedView(session, viewName, definition, properties, replace, ignoreExisting);
        }
    }

    @Override
    public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("dropMaterializedView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.dropMaterializedView(session, viewName);
        }
    }

    @Override
    public List<QualifiedObjectName> listMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("listMaterializedViews", prefix);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            List<QualifiedObjectName> list = this.delegate.listMaterializedViews(session, prefix);
            return list;
        }
    }

    @Override
    public Map<QualifiedObjectName, ViewInfo> getMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("getMaterializedViews", prefix);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Map<QualifiedObjectName, ViewInfo> map = this.delegate.getMaterializedViews(session, prefix);
            return map;
        }
    }

    @Override
    public boolean isMaterializedView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("isMaterializedView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.isMaterializedView(session, viewName);
            return bl;
        }
    }

    @Override
    public Optional<MaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("getMaterializedView", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<MaterializedViewDefinition> optional = this.delegate.getMaterializedView(session, viewName);
            return optional;
        }
    }

    @Override
    public Map<String, Object> getMaterializedViewProperties(Session session, QualifiedObjectName objectName, MaterializedViewDefinition materializedViewDefinition) {
        Span span = this.startSpan("getMaterializedViewProperties", objectName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Map<String, Object> map = this.delegate.getMaterializedViewProperties(session, objectName, materializedViewDefinition);
            return map;
        }
    }

    @Override
    public MaterializedViewFreshness getMaterializedViewFreshness(Session session, QualifiedObjectName name) {
        Span span = this.startSpan("getMaterializedViewFreshness", name);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            MaterializedViewFreshness materializedViewFreshness = this.delegate.getMaterializedViewFreshness(session, name);
            return materializedViewFreshness;
        }
    }

    @Override
    public void renameMaterializedView(Session session, QualifiedObjectName existingViewName, QualifiedObjectName newViewName) {
        Span span = this.startSpan("renameMaterializedView", existingViewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.renameMaterializedView(session, existingViewName, newViewName);
        }
    }

    @Override
    public void setMaterializedViewProperties(Session session, QualifiedObjectName viewName, Map<String, Optional<Object>> properties) {
        Span span = this.startSpan("setMaterializedViewProperties", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setMaterializedViewProperties(session, viewName, properties);
        }
    }

    @Override
    public void setMaterializedViewColumnComment(Session session, QualifiedObjectName viewName, String columnName, Optional<String> comment) {
        Span span = this.startSpan("setMaterializedViewColumnComment", viewName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            this.delegate.setMaterializedViewColumnComment(session, viewName, columnName, comment);
        }
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("applyTableScanRedirect", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableScanRedirectApplicationResult> optional = this.delegate.applyTableScanRedirect(session, tableHandle);
            return optional;
        }
    }

    @Override
    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName) {
        Span span = this.startSpan("getRedirectionAwareTableHandle", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            RedirectionAwareTableHandle redirectionAwareTableHandle = this.delegate.getRedirectionAwareTableHandle(session, tableName);
            return redirectionAwareTableHandle;
        }
    }

    @Override
    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        Span span = this.startSpan("getRedirectionAwareTableHandle", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            RedirectionAwareTableHandle redirectionAwareTableHandle = this.delegate.getRedirectionAwareTableHandle(session, tableName, startVersion, endVersion);
            return redirectionAwareTableHandle;
        }
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        Span span = this.startSpan("getTableHandle", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            Optional<TableHandle> optional = this.delegate.getTableHandle(session, tableName, startVersion, endVersion);
            return optional;
        }
    }

    @Override
    public OptionalInt getMaxWriterTasks(Session session, String catalogName) {
        Span span = this.startSpan("getMaxWriterTasks", catalogName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            OptionalInt optionalInt = this.delegate.getMaxWriterTasks(session, catalogName);
            return optionalInt;
        }
    }

    @Override
    public WriterScalingOptions getNewTableWriterScalingOptions(Session session, QualifiedObjectName tableName, Map<String, Object> tableProperties) {
        Span span = this.startSpan("getNewTableWriterScalingOptions", tableName);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            WriterScalingOptions writerScalingOptions = this.delegate.getNewTableWriterScalingOptions(session, tableName, tableProperties);
            return writerScalingOptions;
        }
    }

    @Override
    public WriterScalingOptions getInsertWriterScalingOptions(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getInsertWriterScalingOptions", tableHandle);
        try (ScopedSpan scopedSpan = ScopedSpan.scopedSpan(span);){
            WriterScalingOptions writerScalingOptions = this.delegate.getInsertWriterScalingOptions(session, tableHandle);
            return writerScalingOptions;
        }
    }

    private Span startSpan(String methodName) {
        return this.tracer.spanBuilder("Metadata." + methodName).startSpan();
    }

    private Span startSpan(String methodName, CatalogName catalogName) {
        return this.startSpan(methodName, catalogName.toString());
    }

    private Span startSpan(String methodName, String catalogName) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)catalogName);
    }

    private Span startSpan(String methodName, Optional<String> catalog) {
        return this.startSpan(methodName, (String)catalog.orElse(null));
    }

    private Span startSpan(String methodName, CatalogSchemaName schema) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)schema.getCatalogName()).setAttribute(TrinoAttributes.SCHEMA, (Object)schema.getSchemaName());
    }

    private Span startSpan(String methodName, QualifiedObjectName table) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)table.catalogName()).setAttribute(TrinoAttributes.SCHEMA, (Object)table.schemaName()).setAttribute(TrinoAttributes.TABLE, (Object)table.objectName());
    }

    private Span startSpan(String methodName, CatalogSchemaTableName table) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)table.getCatalogName()).setAttribute(TrinoAttributes.SCHEMA, (Object)table.getSchemaTableName().getSchemaName()).setAttribute(TrinoAttributes.TABLE, (Object)table.getSchemaTableName().getTableName());
    }

    private Span startSpan(String methodName, QualifiedTablePrefix prefix) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)prefix.getCatalogName()).setAttribute(TrinoAttributes.SCHEMA, (Object)prefix.getSchemaName().orElse(null)).setAttribute(TrinoAttributes.TABLE, (Object)prefix.getTableName().orElse(null));
    }

    private Span startSpan(String methodName, String catalogName, ConnectorTableMetadata tableMetadata) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)catalogName).setAttribute(TrinoAttributes.SCHEMA, (Object)tableMetadata.getTable().getSchemaName()).setAttribute(TrinoAttributes.TABLE, (Object)tableMetadata.getTable().getTableName());
    }

    private Span startSpan(String methodName, TableHandle handle) {
        Span span = this.startSpan(methodName);
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.CATALOG, (Object)handle.catalogHandle().getCatalogName().toString());
            span.setAttribute(TrinoAttributes.HANDLE, (Object)handle.connectorHandle().toString());
        }
        return span;
    }

    private Span startSpan(String methodName, TableExecuteHandle handle) {
        Span span = this.startSpan(methodName);
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.CATALOG, (Object)handle.catalogHandle().getCatalogName().toString());
            span.setAttribute(TrinoAttributes.HANDLE, (Object)handle.connectorHandle().toString());
        }
        return span;
    }

    private Span startSpan(String methodName, CatalogSchemaFunctionName table) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)table.getCatalogName()).setAttribute(TrinoAttributes.SCHEMA, (Object)table.getSchemaName()).setAttribute(TrinoAttributes.FUNCTION, (Object)table.getFunctionName());
    }

    private Span startSpan(String methodName, EntityKindAndName entity, Set<EntityPrivilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan(methodName);
        if (span.isRecording()) {
            String grant = String.format("%s-%s-%s-%s-%s%s", entity.entityKind(), entity.name(), grantee.getType(), grantee.getName(), privileges.stream().map(EntityPrivilege::name).collect(Collectors.joining("-")), grantOption ? "-grantOption" : "");
            span.setAttribute(TrinoAttributes.PRIVILEGE_GRANT, (Object)grant);
        }
        return span;
    }

    private Span startSpan(String methodName, EntityKindAndName entity) {
        Span span = this.startSpan(methodName);
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.ENTITY, (Object)String.format("%s-%s", entity.entityKind(), entity.name()));
        }
        return span;
    }
}

