/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tracing;

import com.google.errorprone.annotations.MustBeClosed;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import java.util.Objects;

public final class ScopedSpan
implements AutoCloseable {
    private final Span span;
    private final Scope scope;

    private ScopedSpan(Span span) {
        this.span = Objects.requireNonNull(span, "span is null");
        this.scope = span.makeCurrent();
    }

    @Override
    public void close() {
        try {
            this.scope.close();
        }
        finally {
            this.span.end();
        }
    }

    @MustBeClosed
    public static ScopedSpan scopedSpan(Tracer tracer, String name) {
        return ScopedSpan.scopedSpan(tracer.spanBuilder(name).startSpan());
    }

    @MustBeClosed
    public static ScopedSpan scopedSpan(Span span) {
        return new ScopedSpan(span);
    }
}

