/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.rowpattern.ir;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.sql.planner.rowpattern.ir.IrQuantifier;
import io.trino.sql.planner.rowpattern.ir.IrRowPattern;
import io.trino.sql.planner.rowpattern.ir.IrRowPatternVisitor;
import java.util.Objects;

public class IrQuantified
extends IrRowPattern {
    private final IrRowPattern pattern;
    private final IrQuantifier quantifier;

    @JsonCreator
    public IrQuantified(IrRowPattern pattern, IrQuantifier quantifier) {
        this.pattern = Objects.requireNonNull(pattern, "pattern is null");
        this.quantifier = Objects.requireNonNull(quantifier, "quantifier is null");
    }

    @JsonProperty
    public IrRowPattern getPattern() {
        return this.pattern;
    }

    @JsonProperty
    public IrQuantifier getQuantifier() {
        return this.quantifier;
    }

    @Override
    public <R, C> R accept(IrRowPatternVisitor<R, C> visitor, C context) {
        return visitor.visitIrQuantified(this, context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IrQuantified o = (IrQuantified)obj;
        return Objects.equals(this.pattern, o.pattern) && Objects.equals(this.quantifier, o.quantifier);
    }

    public int hashCode() {
        return Objects.hash(this.pattern, this.quantifier);
    }

    public String toString() {
        return this.pattern.toString() + String.valueOf(this.quantifier);
    }
}

