/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.planprinter;

import io.airlift.slice.Slice;
import io.trino.Session;
import io.trino.metadata.FunctionManager;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.ResolvedFunction;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.InterpretedFunctionInvoker;
import java.util.Objects;

public final class ValuePrinter {
    private final Metadata metadata;
    private final FunctionManager functionManager;
    private final Session session;

    public ValuePrinter(Metadata metadata, FunctionManager functionManager, Session session) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.functionManager = Objects.requireNonNull(functionManager, "functionManager is null");
        this.session = Objects.requireNonNull(session, "session is null");
    }

    public String castToVarchar(Type type, Object value) {
        try {
            return this.castToVarcharOrFail(type, value);
        }
        catch (OperatorNotFoundException e) {
            return "<UNREPRESENTABLE VALUE>";
        }
    }

    public String castToVarcharOrFail(Type type, Object value) throws OperatorNotFoundException {
        if (value == null) {
            return "NULL";
        }
        ResolvedFunction coercion = this.metadata.getCoercion(type, (Type)VarcharType.VARCHAR);
        Slice coerced = (Slice)new InterpretedFunctionInvoker(this.functionManager).invoke(coercion, this.session.toConnectorSession(), value);
        return coerced.toStringUtf8();
    }
}

